/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.dungeon.monster;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.stream.JsonReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Hashtable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityType;
import xiroc.dungeoncrawl.DungeonCrawl;
import xiroc.dungeoncrawl.dungeon.monster.WeightedRandomEntity;
import xiroc.dungeoncrawl.dungeon.treasure.Loot;
import xiroc.dungeoncrawl.exception.DatapackLoadException;

public class RandomMonster {
    public static final Hashtable<EntityType<?>, MobNBTPatcher> NBT_PATCHERS = new Hashtable();
    public static WeightedRandomEntity[] COMMON;
    public static WeightedRandomEntity[] RARE;
    private static final CompoundTag VILLAGER_OFFERS;

    private static CompoundTag offer(String buy, byte buyCount, String buyB, byte buyBCount, String sell, byte sellCount) {
        CompoundTag offer = new CompoundTag();
        CompoundTag buyNbt = new CompoundTag();
        buyNbt.putString("id", buy);
        buyNbt.putBoolean("Count", true);
        buyNbt.putInt("MaxUses", 3);
        buyNbt.putByte("Count", buyCount);
        CompoundTag buyTag = new CompoundTag();
        buyTag.putInt("Damage", 0);
        buyNbt.put("tag", (Tag)buyTag);
        CompoundTag buyBNbt = new CompoundTag();
        buyBNbt.putString("id", buyB);
        buyBNbt.putBoolean("Count", true);
        buyBNbt.putInt("MaxUses", 3);
        buyBNbt.putByte("Count", buyBCount);
        CompoundTag buyBTag = new CompoundTag();
        buyBTag.putInt("Damage", 0);
        buyBNbt.put("tag", (Tag)buyBTag);
        CompoundTag sellNbt = new CompoundTag();
        sellNbt.putString("id", sell);
        sellNbt.putBoolean("Count", true);
        sellNbt.putInt("MaxUses", 3);
        sellNbt.putByte("Count", sellCount);
        CompoundTag sellTag = new CompoundTag();
        sellTag.putInt("Damage", 0);
        sellNbt.put("tag", (Tag)sellTag);
        offer.put("buy", (Tag)buyNbt);
        offer.put("buyB", (Tag)buyBNbt);
        offer.put("sell", (Tag)sellNbt);
        offer.putInt("uses", 0);
        offer.putInt("xp", 0);
        offer.putFloat("priceMultiplier", 0.0f);
        offer.putInt("demand", 0);
        offer.putInt("specialPrice", 0);
        offer.putBoolean("rewardXp", false);
        return offer;
    }

    public static void loadJson(ResourceManager resourceManager) {
        COMMON = new WeightedRandomEntity[5];
        RARE = new WeightedRandomEntity[5];
        try {
            RandomMonster.loadEntityFile(resourceManager, DungeonCrawl.locate("monster/entities/stage_1.json"), 0);
            RandomMonster.loadEntityFile(resourceManager, DungeonCrawl.locate("monster/entities/stage_2.json"), 1);
            RandomMonster.loadEntityFile(resourceManager, DungeonCrawl.locate("monster/entities/stage_3.json"), 2);
            RandomMonster.loadEntityFile(resourceManager, DungeonCrawl.locate("monster/entities/stage_4.json"), 3);
            RandomMonster.loadEntityFile(resourceManager, DungeonCrawl.locate("monster/entities/stage_5.json"), 4);
        }
        catch (IOException e) {
            DungeonCrawl.LOGGER.error("Failed to load the monster entity files.");
            e.printStackTrace();
        }
    }

    private static void loadEntityFile(ResourceManager resourceManager, ResourceLocation file, int stage) throws IOException {
        DungeonCrawl.LOGGER.debug("Loading {}", (Object)file.toString());
        Resource resource = (Resource)resourceManager.getResource(file).orElseThrow(() -> new DatapackLoadException("Missing file: " + file));
        JsonObject object = JsonParser.parseReader((JsonReader)new JsonReader((Reader)new InputStreamReader(resource.open()))).getAsJsonObject();
        if (object.has("common")) {
            RandomMonster.COMMON[stage] = WeightedRandomEntity.fromJson(object.getAsJsonArray("common"));
        } else {
            DungeonCrawl.LOGGER.warn("Missing entry 'common' in {}", (Object)file.toString());
            RandomMonster.COMMON[stage] = WeightedRandomEntity.EMPTY;
        }
        if (object.has("rare")) {
            RandomMonster.RARE[stage] = WeightedRandomEntity.fromJson(object.getAsJsonArray("rare"));
        } else {
            DungeonCrawl.LOGGER.warn("Missing entry 'rare' in {}", (Object)file.toString());
            RandomMonster.RARE[stage] = WeightedRandomEntity.EMPTY;
        }
    }

    public static EntityType<?> randomMonster(RandomSource rand, int stage) {
        if (stage > 4) {
            stage = 4;
        }
        if ((double)rand.nextFloat() < 0.1) {
            EntityType<?> monster = RARE[stage].roll(rand);
            if (monster != null) {
                return monster;
            }
            return COMMON[stage].roll(rand);
        }
        return COMMON[stage].roll(rand);
    }

    static {
        VILLAGER_OFFERS = new CompoundTag();
        ListTag recipes = new ListTag();
        recipes.add((Object)RandomMonster.offer("minecraft:paper", (byte)1, "minecraft:air", (byte)0, "minecraft:paper", (byte)1));
        VILLAGER_OFFERS.put("Recipes", (Tag)recipes);
        NBT_PATCHERS.put(EntityType.WITHER_SKELETON, (nbt, rand, stage) -> {
            nbt.putString("DeathLootTable", Loot.WITHER_SKELETON.toString());
            nbt.putLong("DeathLootTableSeed", (long)rand.nextInt());
        });
        NBT_PATCHERS.put(EntityType.ZOMBIE_VILLAGER, (nbt, rand, stage) -> {
            nbt.put("Offers", (Tag)VILLAGER_OFFERS.copy());
            nbt.putInt("Xp", 1);
            nbt.putBoolean("Willing", false);
            CompoundTag villagerData = nbt.getCompound("villagerData");
            villagerData.putInt("level", 5);
        });
    }

    @FunctionalInterface
    public static interface MobNBTPatcher {
        public void patch(CompoundTag var1, RandomSource var2, int var3);
    }
}

