/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.dungeon.monster;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.EntityType;
import xiroc.dungeoncrawl.util.IRandom;

public class WeightedRandomEntity
implements IRandom<EntityType<?>> {
    public static final WeightedRandomEntity EMPTY = new WeightedRandomEntity(new Builder.Entry[0]);
    private final WeightedEntry[] entries;

    private WeightedRandomEntity(Tuple<String, Integer>[] entries) {
        int weight = 0;
        for (Tuple<String, Integer> entry : entries) {
            weight += ((Integer)entry.getB()).intValue();
        }
        this.entries = new WeightedEntry[entries.length];
        this.assign(entries, weight);
    }

    private void assign(Tuple<String, Integer>[] entries, int totalWeight) {
        float f = 0.0f;
        int i = 0;
        for (Tuple<String, Integer> entry : entries) {
            float weight = (float)((Integer)entry.getB()).intValue() / (float)totalWeight;
            this.entries[i] = new WeightedEntry((EntityType)BuiltInRegistries.ENTITY_TYPE.get(new ResourceLocation((String)entry.getA())), Float.valueOf(weight + f));
            f += weight;
            ++i;
        }
    }

    @Override
    public EntityType<?> roll(RandomSource rand) {
        float f = rand.nextFloat();
        for (WeightedEntry entry : this.entries) {
            if (!(((Float)entry.getB()).floatValue() >= f)) continue;
            return (EntityType)entry.getA();
        }
        return null;
    }

    public static WeightedRandomEntity fromJson(JsonArray array) {
        if (array.size() == 0) {
            return EMPTY;
        }
        Builder builder = new Builder();
        array.forEach(element -> {
            JsonObject object = element.getAsJsonObject();
            int weight = object.has("weight") ? object.get("weight").getAsInt() : 1;
            builder.add(object.get("entity").getAsString(), weight);
        });
        return builder.build();
    }

    private static class WeightedEntry
    extends Tuple<EntityType<?>, Float> {
        public WeightedEntry(EntityType<?> aIn, Float bIn) {
            super(aIn, (Object)bIn);
        }
    }

    public static class Builder {
        private final ArrayList<Entry> list = new ArrayList();

        public Builder add(String item, int weight) {
            this.list.add(new Entry(item, weight));
            return this;
        }

        public WeightedRandomEntity build() {
            if (this.list.isEmpty()) {
                return EMPTY;
            }
            return new WeightedRandomEntity(this.list.toArray(new Entry[0]));
        }

        private static class Entry
        extends Tuple<String, Integer> {
            public Entry(String aIn, Integer bIn) {
                super((Object)aIn, (Object)bIn);
            }
        }
    }
}

