/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.dungeon.treasure;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class TreasureItems {
    public static final ItemStack LAUDANUM;
    public static final ItemStack ANIMUS;
    public static final ItemStack NECTAR;
    public static final ItemStack LUMA;
    public static final ItemStack VELOCITAS;
    public static final ItemStack POTION_HEALING;
    public static final ItemStack POTION_HEALING_II;
    public static final ItemStack POTION_REGENERATION;
    public static final ItemStack POTION_REGENERATION_LONG;
    public static final ItemStack POTION_REGENERATION_II;
    public static final ItemStack SPLASH_POISON;
    public static final ItemStack SPLASH_POISON_LONG;
    public static final ItemStack SPLASH_HARMING;
    public static final ItemStack SPLASH_HARMING_II;
    private static final ItemStack[] POTIONS;
    private static final ItemStack[] SPECIAL_POTIONS;

    public static CompoundTag createDisplayTag(String name, String ... loreEntries) {
        CompoundTag display = new CompoundTag();
        display.put("Name", (Tag)StringTag.valueOf((String)Component.Serializer.toJson((Component)Component.literal((String)name))));
        ListTag lore = new ListTag();
        if (loreEntries.length > 0) {
            for (String line : loreEntries) {
                lore.add((Object)StringTag.valueOf((String)Component.Serializer.toJson((Component)Component.literal((String)line))));
            }
            display.put("Lore", (Tag)lore);
        }
        return display;
    }

    public static CompoundTag createPotionTag(String potionName) {
        CompoundTag potion = new CompoundTag();
        potion.putString("Potion", potionName);
        return potion;
    }

    private static ItemStack createItemWithNbt(Item item, CompoundTag nbt) {
        ItemStack stack = new ItemStack((ItemLike)item);
        stack.setTag(nbt);
        return stack;
    }

    public static ItemStack getRandomSpecialPotion(RandomSource rand, int stage) {
        if ((double)rand.nextFloat() < 0.4) {
            return POTIONS[rand.nextInt(POTIONS.length)].copy();
        }
        if (stage == 0) {
            return LAUDANUM.copy();
        }
        return SPECIAL_POTIONS[rand.nextInt(SPECIAL_POTIONS.length)].copy();
    }

    static {
        CompoundTag nbt = new CompoundTag();
        ListTag customPotionEffects = new ListTag();
        CompoundTag nausea = new CompoundTag();
        nausea.putInt("Id", 9);
        nausea.putInt("Duration", 100);
        CompoundTag blindness = new CompoundTag();
        blindness.putInt("Id", 15);
        blindness.putInt("Duration", 100);
        CompoundTag weakness = new CompoundTag();
        weakness.putInt("Id", 18);
        weakness.putInt("Duration", 100);
        CompoundTag miningFatigue = new CompoundTag();
        miningFatigue.putInt("Id", 4);
        miningFatigue.putInt("Duration", 100);
        CompoundTag regeneration = new CompoundTag();
        regeneration.putInt("Id", 10);
        regeneration.putInt("Amplifier", 1);
        regeneration.putInt("Duration", 160);
        customPotionEffects.add((Object)regeneration);
        customPotionEffects.add((Object)blindness);
        customPotionEffects.add((Object)weakness);
        customPotionEffects.add((Object)miningFatigue);
        customPotionEffects.add((Object)nausea);
        nbt.put("CustomPotionEffects", (Tag)customPotionEffects);
        nbt.putInt("CustomPotionColor", 7014144);
        nbt.putInt("HideFlags", 32);
        CompoundTag display = new CompoundTag();
        ListTag lore = new ListTag();
        lore.add((Object)StringTag.valueOf((String)Component.Serializer.toJson((Component)Component.literal((String)"A medicinal tincture."))));
        display.put("Lore", (Tag)lore);
        display.put("Name", (Tag)StringTag.valueOf((String)Component.Serializer.toJson((Component)Component.literal((String)"Laudanum"))));
        nbt.put("display", (Tag)display);
        LAUDANUM = new ItemStack((ItemLike)Items.POTION);
        LAUDANUM.setTag(nbt);
        nbt = new CompoundTag();
        customPotionEffects = new ListTag();
        CompoundTag wither = new CompoundTag();
        wither.putInt("Id", 20);
        wither.putInt("Duration", 40);
        blindness = new CompoundTag();
        blindness.putInt("Id", 15);
        blindness.putInt("Duration", 40);
        CompoundTag strength = new CompoundTag();
        strength.putInt("Id", 5);
        strength.putInt("Duration", 800);
        customPotionEffects.add((Object)strength);
        customPotionEffects.add((Object)blindness);
        customPotionEffects.add((Object)wither);
        nbt.put("CustomPotionEffects", (Tag)customPotionEffects);
        nbt.putInt("CustomPotionColor", 13050390);
        nbt.putInt("HideFlags", 32);
        CompoundTag display2 = new CompoundTag();
        ListTag lore2 = new ListTag();
        lore2.add((Object)StringTag.valueOf((String)Component.Serializer.toJson((Component)Component.literal((String)"An unstable mixture."))));
        display2.put("Lore", (Tag)lore2);
        display2.put("Name", (Tag)StringTag.valueOf((String)Component.Serializer.toJson((Component)Component.literal((String)"Animus"))));
        nbt.put("display", (Tag)display2);
        ANIMUS = new ItemStack((ItemLike)Items.POTION);
        ANIMUS.setTag(nbt);
        nbt = new CompoundTag();
        customPotionEffects = new ListTag();
        CompoundTag resistance = new CompoundTag();
        resistance.putInt("Id", 11);
        resistance.putInt("Duration", 400);
        blindness = new CompoundTag();
        blindness.putInt("Id", 15);
        blindness.putInt("Duration", 100);
        CompoundTag absorption = new CompoundTag();
        absorption.putInt("Id", 22);
        absorption.putInt("Amplifier", 8);
        absorption.putInt("Duration", 600);
        customPotionEffects.add((Object)absorption);
        customPotionEffects.add((Object)resistance);
        customPotionEffects.add((Object)blindness);
        nbt.put("CustomPotionEffects", (Tag)customPotionEffects);
        nbt.putInt("CustomPotionColor", 15446551);
        nbt.putInt("HideFlags", 32);
        display2 = new CompoundTag();
        lore2 = new ListTag();
        lore2.add((Object)StringTag.valueOf((String)Component.Serializer.toJson((Component)Component.literal((String)"A floral extract."))));
        display2.put("Lore", (Tag)lore2);
        display2.put("Name", (Tag)StringTag.valueOf((String)Component.Serializer.toJson((Component)Component.literal((String)"Nectar"))));
        nbt.put("display", (Tag)display2);
        NECTAR = new ItemStack((ItemLike)Items.POTION);
        NECTAR.setTag(nbt);
        nbt = new CompoundTag();
        customPotionEffects = new ListTag();
        CompoundTag speed = new CompoundTag();
        speed.putInt("Id", 1);
        speed.putInt("Amplifier", 1);
        speed.putInt("Duration", 400);
        blindness = new CompoundTag();
        blindness.putInt("Id", 15);
        blindness.putInt("Duration", 40);
        CompoundTag haste = new CompoundTag();
        haste.putInt("Id", 3);
        haste.putInt("Duration", 400);
        customPotionEffects.add((Object)speed);
        customPotionEffects.add((Object)haste);
        customPotionEffects.add((Object)blindness);
        nbt.put("CustomPotionEffects", (Tag)customPotionEffects);
        nbt.putInt("CustomPotionColor", 65327);
        nbt.putInt("HideFlags", 32);
        display2 = new CompoundTag();
        lore2 = new ListTag();
        lore2.add((Object)StringTag.valueOf((String)Component.Serializer.toJson((Component)Component.literal((String)"An energetic beverage."))));
        display2.put("Lore", (Tag)lore2);
        display2.put("Name", (Tag)StringTag.valueOf((String)Component.Serializer.toJson((Component)Component.literal((String)"Velocitas"))));
        nbt.put("display", (Tag)display2);
        VELOCITAS = new ItemStack((ItemLike)Items.POTION);
        VELOCITAS.setTag(nbt);
        nbt = new CompoundTag();
        customPotionEffects = new ListTag();
        CompoundTag glowing = new CompoundTag();
        glowing.putInt("Id", 24);
        glowing.putInt("Duration", 12000);
        customPotionEffects.add((Object)glowing);
        nbt.put("CustomPotionEffects", (Tag)customPotionEffects);
        nbt.putInt("CustomPotionColor", 0xFAFA00);
        nbt.putInt("HideFlags", 32);
        CompoundTag display3 = new CompoundTag();
        ListTag lore3 = new ListTag();
        lore3.add((Object)StringTag.valueOf((String)Component.Serializer.toJson((Component)Component.literal((String)"A glowstone extract."))));
        display3.put("Lore", (Tag)lore3);
        display3.put("Name", (Tag)StringTag.valueOf((String)Component.Serializer.toJson((Component)Component.literal((String)"Luma"))));
        nbt.put("display", (Tag)display3);
        LUMA = new ItemStack((ItemLike)Items.POTION);
        LUMA.setTag(nbt);
        POTION_HEALING = TreasureItems.createItemWithNbt(Items.POTION, TreasureItems.createPotionTag("minecraft:healing"));
        POTION_HEALING_II = TreasureItems.createItemWithNbt(Items.POTION, TreasureItems.createPotionTag("minecraft:strong_healing"));
        POTION_REGENERATION = TreasureItems.createItemWithNbt(Items.POTION, TreasureItems.createPotionTag("minecraft:regeneration"));
        POTION_REGENERATION_LONG = TreasureItems.createItemWithNbt(Items.POTION, TreasureItems.createPotionTag("minecraft:long_regeneration"));
        POTION_REGENERATION_II = TreasureItems.createItemWithNbt(Items.POTION, TreasureItems.createPotionTag("minecraft:strong_regeneration"));
        SPLASH_POISON = TreasureItems.createItemWithNbt(Items.POTION, TreasureItems.createPotionTag("minecraft:poison"));
        SPLASH_POISON_LONG = TreasureItems.createItemWithNbt(Items.POTION, TreasureItems.createPotionTag("minecraft:long_poison"));
        SPLASH_HARMING = TreasureItems.createItemWithNbt(Items.POTION, TreasureItems.createPotionTag("minecraft:harming"));
        SPLASH_HARMING_II = TreasureItems.createItemWithNbt(Items.POTION, TreasureItems.createPotionTag("minecraft:strong_harming"));
        POTIONS = new ItemStack[]{POTION_HEALING, POTION_HEALING_II, POTION_REGENERATION, POTION_REGENERATION_LONG, POTION_REGENERATION_II, SPLASH_HARMING, SPLASH_HARMING_II, SPLASH_POISON, SPLASH_POISON_LONG};
        SPECIAL_POTIONS = new ItemStack[]{LAUDANUM, ANIMUS, NECTAR, LUMA, VELOCITAS};
    }
}

