/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.dungeon.treasure.function;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import xiroc.dungeoncrawl.dungeon.treasure.Loot;

public class EnchantedBook
extends LootItemConditionalFunction {
    public static final Codec<EnchantedBook> CODEC = RecordCodecBuilder.create(builder -> EnchantedBook.commonFields((RecordCodecBuilder.Instance)builder).and((App)Codec.INT.fieldOf("loot_level").forGetter(enchantedBook -> enchantedBook.lootLevel)).apply((Applicative)builder, EnchantedBook::new));
    public int lootLevel;

    public EnchantedBook(List<LootItemCondition> conditions, int stage) {
        super(conditions);
        this.lootLevel = stage;
    }

    public ItemStack run(ItemStack stack, LootContext context) {
        return EnchantmentHelper.enchantItem((RandomSource)context.getRandom(), (ItemStack)new ItemStack((ItemLike)Items.BOOK), (int)(10 + this.lootLevel * 3), (this.lootLevel > 2 ? 1 : 0) != 0);
    }

    public static LootItemConditionalFunction.Builder<?> enchantedBook(int lootLevel) {
        return EnchantedBook.simpleBuilder(conditions -> new EnchantedBook((List<LootItemCondition>)conditions, lootLevel));
    }

    public LootItemFunctionType getType() {
        return (LootItemFunctionType)Loot.ENCHANTED_BOOK.get();
    }
}

