/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.dungeon.treasure.function;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import xiroc.dungeoncrawl.dungeon.treasure.Loot;
import xiroc.dungeoncrawl.dungeon.treasure.RandomItems;

public class RandomItem
extends LootItemConditionalFunction {
    public static final Codec<RandomItem> CODEC = RecordCodecBuilder.create(builder -> RandomItem.commonFields((RecordCodecBuilder.Instance)builder).and((App)Codec.INT.fieldOf("loot_level").forGetter(randomItem -> randomItem.lootLevel)).apply((Applicative)builder, RandomItem::new));
    public int lootLevel;

    public RandomItem(List<LootItemCondition> conditions, int lootLevel) {
        super(conditions);
        this.lootLevel = Math.max(0, lootLevel);
    }

    public ItemStack run(ItemStack stack, LootContext context) {
        if (context.hasParam(LootContextParams.ORIGIN)) {
            return RandomItems.generate(context.getRandom(), this.lootLevel);
        }
        return ItemStack.EMPTY;
    }

    public static LootItemConditionalFunction.Builder<?> randomItem(int lootLevel) {
        return RandomItem.simpleBuilder(conditions -> new RandomItem((List<LootItemCondition>)conditions, lootLevel));
    }

    public LootItemFunctionType getType() {
        return (LootItemFunctionType)Loot.RANDOM_ITEM.get();
    }
}

