/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.dungeon.treasure.function;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import xiroc.dungeoncrawl.dungeon.treasure.Loot;
import xiroc.dungeoncrawl.dungeon.treasure.TreasureItems;

public class RandomPotion
extends LootItemConditionalFunction {
    public static final Codec<RandomPotion> CODEC = RecordCodecBuilder.create(builder -> RandomPotion.commonFields((RecordCodecBuilder.Instance)builder).and((App)Codec.INT.fieldOf("loot_level").forGetter(randomPotion -> randomPotion.lootLevel)).apply((Applicative)builder, RandomPotion::new));
    public int lootLevel;

    public RandomPotion(List<LootItemCondition> conditions, int lootLevel) {
        super(conditions);
        this.lootLevel = Math.max(0, lootLevel);
    }

    public ItemStack run(ItemStack stack, LootContext context) {
        return TreasureItems.getRandomSpecialPotion(context.getRandom(), this.lootLevel);
    }

    public static LootItemConditionalFunction.Builder<?> randomPotion(int lootLevel) {
        return RandomPotion.simpleBuilder(conditions -> new RandomPotion((List<LootItemCondition>)conditions, lootLevel));
    }

    public LootItemFunctionType getType() {
        return (LootItemFunctionType)Loot.RANDOM_POTION.get();
    }
}

