/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.dungeon.treasure.function;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import xiroc.dungeoncrawl.dungeon.treasure.Loot;

public class SuspiciousStew
extends LootItemConditionalFunction {
    public static final Codec<SuspiciousStew> CODEC = RecordCodecBuilder.create(builder -> SuspiciousStew.commonFields((RecordCodecBuilder.Instance)builder).apply((Applicative)builder, SuspiciousStew::new));
    public static CompoundTag[] EFFECTS;

    public SuspiciousStew(List<LootItemCondition> conditions) {
        super(conditions);
    }

    public ItemStack run(ItemStack stack, LootContext context) {
        stack.getOrCreateTag().put("Effects", (Tag)SuspiciousStew.createEffectList(context.getRandom()));
        return stack;
    }

    public static LootItemConditionalFunction.Builder<?> suspiciousStew() {
        return SuspiciousStew.simpleBuilder(SuspiciousStew::new);
    }

    public LootItemFunctionType getType() {
        return (LootItemFunctionType)Loot.SUSPICIOUS_STEW.get();
    }

    public static ListTag createEffectList(RandomSource rand) {
        int max = EFFECTS.length;
        ListTag effects = new ListTag();
        for (int counter = rand.nextInt(2); counter < max; counter += 1 + rand.nextInt(3)) {
            effects.add((Object)EFFECTS[counter].copy());
        }
        return effects;
    }

    static {
        CompoundTag regeneration = new CompoundTag();
        regeneration.putInt("EffectId", 10);
        regeneration.putInt("EffectDuration", 160);
        CompoundTag weakness = new CompoundTag();
        weakness.putInt("EffectId", 18);
        weakness.putInt("EffectDuration", 320);
        CompoundTag poison = new CompoundTag();
        poison.putInt("EffectId", 19);
        poison.putInt("EffectDuration", 160);
        CompoundTag healthBoost = new CompoundTag();
        healthBoost.putInt("EffectId", 21);
        healthBoost.putInt("EffectDuration", 320);
        CompoundTag blindness = new CompoundTag();
        blindness.putInt("EffectId", 15);
        blindness.putInt("EffectDuration", 120);
        CompoundTag resistance = new CompoundTag();
        resistance.putInt("EffectId", 11);
        resistance.putInt("EffectDuration", 320);
        CompoundTag nausea = new CompoundTag();
        nausea.putInt("EffectId", 9);
        nausea.putInt("EffectDuration", 120);
        CompoundTag absorption = new CompoundTag();
        absorption.putInt("EffectId", 22);
        absorption.putInt("EffectDuration", 320);
        CompoundTag hunger = new CompoundTag();
        hunger.putInt("EffectId", 17);
        hunger.putInt("EffectDuration", 200);
        CompoundTag saturation = new CompoundTag();
        saturation.putInt("EffectId", 23);
        saturation.putInt("EffectDuration", 80);
        CompoundTag fireResistance = new CompoundTag();
        fireResistance.putInt("EffectId", 12);
        fireResistance.putInt("EffectDuration", 320);
        CompoundTag strength = new CompoundTag();
        strength.putInt("EffectId", 5);
        strength.putInt("EffectDuration", 320);
        CompoundTag speed = new CompoundTag();
        speed.putInt("EffectId", 1);
        speed.putInt("EffectDuration", 220);
        CompoundTag slowness = new CompoundTag();
        slowness.putInt("EffectId", 2);
        slowness.putInt("EffectDuration", 160);
        CompoundTag miningFatique = new CompoundTag();
        miningFatique.putInt("EffectId", 4);
        miningFatique.putInt("EffectDuration", 160);
        CompoundTag haste = new CompoundTag();
        haste.putInt("EffectId", 3);
        haste.putInt("EffectDuration", 320);
        CompoundTag jumpBoost = new CompoundTag();
        jumpBoost.putInt("EffectId", 8);
        jumpBoost.putInt("EffectDuration", 160);
        CompoundTag wither = new CompoundTag();
        wither.putInt("EffectId", 20);
        wither.putInt("EffectDuration", 80);
        EFFECTS = new CompoundTag[]{regeneration, weakness, poison, healthBoost, blindness, resistance, nausea, hunger, saturation, fireResistance, strength, speed, slowness, miningFatique, haste, wither};
    }
}

