/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedterminals.api.terminalstorage.crafting;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import org.cyclops.commoncapabilities.api.ingredient.IPrototypedIngredient;
import org.cyclops.commoncapabilities.api.ingredient.PrototypedIngredient;
import org.cyclops.integratedterminals.api.terminalstorage.crafting.ITerminalCraftingPlan;
import org.cyclops.integratedterminals.api.terminalstorage.crafting.ITerminalStorageTabIngredientCraftingHandler;
import org.cyclops.integratedterminals.api.terminalstorage.crafting.TerminalCraftingJobStatus;

public class TerminalCraftingPlanStatic<I>
implements ITerminalCraftingPlan<I> {
    private final I id;
    private final List<ITerminalCraftingPlan<I>> dependencies;
    private final List<IPrototypedIngredient<?, ?>> outputs;
    private TerminalCraftingJobStatus status;
    private final long craftingQuantity;
    private final List<IPrototypedIngredient<?, ?>> storageIngredients;
    private final List<List<IPrototypedIngredient<?, ?>>> lastMissingIngredients;
    private Label label;
    @Nullable
    private String unlocalizedLabelOverride;
    private final long tickDuration;
    private final int channel;
    @Nullable
    private final String initiatorName;

    public TerminalCraftingPlanStatic(I id, List<ITerminalCraftingPlan<I>> dependencies, List<IPrototypedIngredient<?, ?>> outputs, TerminalCraftingJobStatus status, long craftingQuantity, List<IPrototypedIngredient<?, ?>> storageIngredients, List<List<IPrototypedIngredient<?, ?>>> lastMissingIngredients, Label label, long tickDuration, int channel, @Nullable String initiatorName) {
        this.id = id;
        this.dependencies = dependencies;
        this.outputs = outputs;
        this.status = status;
        this.craftingQuantity = craftingQuantity;
        this.storageIngredients = storageIngredients;
        this.lastMissingIngredients = lastMissingIngredients;
        this.label = label;
        this.unlocalizedLabelOverride = null;
        this.tickDuration = tickDuration;
        this.channel = channel;
        this.initiatorName = initiatorName;
    }

    @Override
    public I getId() {
        return this.id;
    }

    @Override
    public List<ITerminalCraftingPlan<I>> getDependencies() {
        return this.dependencies;
    }

    @Override
    public List<IPrototypedIngredient<?, ?>> getOutputs() {
        return this.outputs;
    }

    @Override
    public TerminalCraftingJobStatus getStatus() {
        return this.status;
    }

    @Override
    public long getCraftingQuantity() {
        return this.craftingQuantity;
    }

    @Override
    public List<IPrototypedIngredient<?, ?>> getStorageIngredients() {
        return this.storageIngredients;
    }

    @Override
    public List<List<IPrototypedIngredient<?, ?>>> getLastMissingIngredients() {
        return this.lastMissingIngredients;
    }

    public Label getLabel() {
        return this.label;
    }

    @Nullable
    public String getUnlocalizedLabelOverride() {
        return this.unlocalizedLabelOverride;
    }

    public void setUnlocalizedLabelOverride(@Nullable String unlocalizedLabelOverride) {
        this.unlocalizedLabelOverride = unlocalizedLabelOverride;
    }

    @Override
    public String getUnlocalizedLabel() {
        if (this.unlocalizedLabelOverride == null) {
            return this.label.getUnlocalizedMessage();
        }
        return this.unlocalizedLabelOverride;
    }

    @Override
    public long getTickDuration() {
        return this.tickDuration;
    }

    @Override
    public int getChannel() {
        return this.channel;
    }

    @Override
    @Nullable
    public String getInitiatorName() {
        return this.initiatorName;
    }

    @Override
    public void setError(String unlocalizedError) {
        this.status = TerminalCraftingJobStatus.ERROR;
        this.unlocalizedLabelOverride = unlocalizedError;
    }

    public static <I> CompoundTag serialize(TerminalCraftingPlanStatic<I> plan, ITerminalStorageTabIngredientCraftingHandler<?, I> handler) {
        CompoundTag tag = new CompoundTag();
        tag.put("id", handler.serializeCraftingJobId(plan.getId()));
        ListTag dependencies = new ListTag();
        for (ITerminalCraftingPlan<I> iTerminalCraftingPlan : plan.getDependencies()) {
            dependencies.add((Object)TerminalCraftingPlanStatic.serialize((TerminalCraftingPlanStatic)iTerminalCraftingPlan, handler));
        }
        tag.put("dependencies", (Tag)dependencies);
        ListTag outputs = new ListTag();
        for (IPrototypedIngredient<?, ?> iPrototypedIngredient : plan.getOutputs()) {
            outputs.add((Object)IPrototypedIngredient.serialize((IPrototypedIngredient)((PrototypedIngredient)iPrototypedIngredient)));
        }
        tag.put("outputs", (Tag)outputs);
        tag.putInt("status", plan.getStatus().ordinal());
        tag.putLong("craftingQuantity", plan.getCraftingQuantity());
        ListTag listTag = new ListTag();
        for (IPrototypedIngredient<?, ?> iPrototypedIngredient : plan.getStorageIngredients()) {
            listTag.add((Object)IPrototypedIngredient.serialize((IPrototypedIngredient)((PrototypedIngredient)iPrototypedIngredient)));
        }
        tag.put("storageIngredients", (Tag)listTag);
        ListTag listTag2 = new ListTag();
        for (List<IPrototypedIngredient<?, ?>> lastMissingIngredient : plan.getLastMissingIngredients()) {
            ListTag lastMissingIngredientTag = new ListTag();
            for (IPrototypedIngredient<?, ?> prototypedIngredient : lastMissingIngredient) {
                lastMissingIngredientTag.add((Object)IPrototypedIngredient.serialize((IPrototypedIngredient)((PrototypedIngredient)prototypedIngredient)));
            }
            listTag2.add((Object)lastMissingIngredientTag);
        }
        tag.put("lastMissingIngredients", (Tag)listTag2);
        tag.putInt("label", plan.label.ordinal());
        if (plan.unlocalizedLabelOverride != null) {
            tag.putString("unlocalizedLabelOverride", plan.unlocalizedLabelOverride);
        }
        tag.putLong("tickDuration", plan.getTickDuration());
        tag.putInt("channel", plan.getChannel());
        if (plan.getInitiatorName() != null) {
            tag.putString("initiatorName", plan.getInitiatorName());
        }
        return tag;
    }

    public static <I> TerminalCraftingPlanStatic<I> deserialize(CompoundTag tag, ITerminalStorageTabIngredientCraftingHandler<?, I> handler) {
        if (!tag.contains("id")) {
            throw new IllegalArgumentException("Could not find an id entry in the given tag");
        }
        if (!tag.contains("dependencies", 9)) {
            throw new IllegalArgumentException("Could not find a dependencies entry in the given tag");
        }
        if (!tag.contains("outputs", 9)) {
            throw new IllegalArgumentException("Could not find a outputs entry in the given tag");
        }
        if (!tag.contains("status", 3)) {
            throw new IllegalArgumentException("Could not find a status entry in the given tag");
        }
        if (!tag.contains("craftingQuantity", 4)) {
            throw new IllegalArgumentException("Could not find a craftingQuantity entry in the given tag");
        }
        if (!tag.contains("storageIngredients", 9)) {
            throw new IllegalArgumentException("Could not find a storageIngredients entry in the given tag");
        }
        if (!tag.contains("lastMissingIngredients", 9)) {
            throw new IllegalArgumentException("Could not find a lastMissingIngredients entry in the given tag");
        }
        if (!tag.contains("label", 3)) {
            throw new IllegalArgumentException("Could not find a label entry in the given tag");
        }
        if (!tag.contains("tickDuration", 4)) {
            throw new IllegalArgumentException("Could not find a tickDuration entry in the given tag");
        }
        if (!tag.contains("channel", 3)) {
            throw new IllegalArgumentException("Could not find a channel entry in the given tag");
        }
        I id = handler.deserializeCraftingJobId(tag.get("id"));
        ListTag dependenciesTag = tag.getList("dependencies", 10);
        ArrayList dependencies = Lists.newArrayListWithExpectedSize((int)dependenciesTag.size());
        for (Tag nbtBase : dependenciesTag) {
            dependencies.add(TerminalCraftingPlanStatic.deserialize((CompoundTag)nbtBase, handler));
        }
        ListTag outputsTag = tag.getList("outputs", 10);
        ArrayList outputs = Lists.newArrayListWithExpectedSize((int)outputsTag.size());
        for (Tag nbtBase : outputsTag) {
            outputs.add(IPrototypedIngredient.deserialize((CompoundTag)((CompoundTag)nbtBase)));
        }
        TerminalCraftingJobStatus status = TerminalCraftingJobStatus.values()[tag.getInt("status")];
        long craftingQuantity = tag.getLong("craftingQuantity");
        ListTag storageIngredientsTag = tag.getList("storageIngredients", 10);
        ArrayList storageIngredients = Lists.newArrayListWithExpectedSize((int)storageIngredientsTag.size());
        for (Tag nbtBase : storageIngredientsTag) {
            storageIngredients.add(IPrototypedIngredient.deserialize((CompoundTag)((CompoundTag)nbtBase)));
        }
        ListTag lastMissingIngredientsTag = tag.getList("lastMissingIngredients", 9);
        ArrayList lastMissingIngredients = Lists.newArrayListWithExpectedSize((int)lastMissingIngredientsTag.size());
        for (Tag nbtBase : lastMissingIngredientsTag) {
            ListTag list = (ListTag)nbtBase;
            ArrayList lastMissingIngredient = Lists.newArrayListWithExpectedSize((int)list.size());
            for (Tag base : list) {
                lastMissingIngredient.add(IPrototypedIngredient.deserialize((CompoundTag)((CompoundTag)base)));
            }
            lastMissingIngredients.add(lastMissingIngredient);
        }
        Label label = Label.values()[tag.getInt("label")];
        String unlocalizedLabelOverride = null;
        if (tag.contains("unlocalizedLabelOverride")) {
            unlocalizedLabelOverride = tag.getString("unlocalizedLabelOverride");
        }
        long tickDuration = tag.getLong("tickDuration");
        int channel = tag.getInt("channel");
        String initiatorName = null;
        if (tag.contains("initiatorName", 8)) {
            initiatorName = tag.getString("initiatorName");
        }
        TerminalCraftingPlanStatic<I> plan = new TerminalCraftingPlanStatic<I>(id, dependencies, outputs, status, craftingQuantity, storageIngredients, lastMissingIngredients, label, tickDuration, channel, initiatorName);
        if (unlocalizedLabelOverride != null) {
            plan.unlocalizedLabelOverride = unlocalizedLabelOverride;
        }
        return plan;
    }

    public static enum Label {
        RUNNING("gui.integratedterminals.terminal_storage.craftingplan.label.running"),
        VALID("gui.integratedterminals.terminal_storage.craftingplan.label.valid"),
        INCOMPLETE("gui.integratedterminals.terminal_storage.craftingplan.label.failed.incomplete"),
        RECURSION("gui.integratedterminals.terminal_storage.craftingplan.label.failed.recursion"),
        ERROR("ERROR");

        private final String unlocalizedMessage;

        private Label(String unlocalizedMessage) {
            this.unlocalizedMessage = unlocalizedMessage;
        }

        public String getUnlocalizedMessage() {
            return this.unlocalizedMessage;
        }
    }
}

