/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedterminals.client.gui.container;

import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import org.cyclops.cyclopscore.client.gui.component.button.ButtonText;
import org.cyclops.cyclopscore.client.gui.container.ContainerScreenExtended;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.cyclopscore.inventory.container.ContainerExtended;
import org.cyclops.cyclopscore.network.PacketBase;
import org.cyclops.integrateddynamics.api.part.PartPos;
import org.cyclops.integrateddynamics.api.part.PartTarget;
import org.cyclops.integratedterminals.IntegratedTerminals;
import org.cyclops.integratedterminals.api.terminalstorage.crafting.ITerminalCraftingPlan;
import org.cyclops.integratedterminals.client.gui.container.component.GuiCraftingPlan;
import org.cyclops.integratedterminals.inventory.container.ContainerTerminalCraftingJobsPlan;
import org.cyclops.integratedterminals.network.packet.CancelCraftingJobPacket;
import org.cyclops.integratedterminals.network.packet.OpenCraftingJobsGuiPacket;

public class ContainerScreenTerminalCraftingJobsPlan
extends ContainerScreenExtended<ContainerTerminalCraftingJobsPlan> {
    private final Player player;
    @Nullable
    private GuiCraftingPlan guiCraftingPlan;

    public ContainerScreenTerminalCraftingJobsPlan(ContainerTerminalCraftingJobsPlan container, Inventory inventory, Component title) {
        super((ContainerExtended)container, inventory, title);
        this.player = inventory.player;
    }

    protected ResourceLocation constructGuiTexture() {
        return new ResourceLocation("integratedterminals", "textures/gui/crafting_plan.png");
    }

    public int getBaseXSize() {
        return 256;
    }

    public int getBaseYSize() {
        return 222;
    }

    public void init() {
        super.init();
        this.renderables.clear();
        this.children().clear();
        ITerminalCraftingPlan craftingPlan = ((ContainerTerminalCraftingJobsPlan)this.getMenu()).getCraftingPlan().orElse(null);
        if (craftingPlan != null) {
            GuiCraftingPlan previousGuiCraftingPlan = this.guiCraftingPlan;
            this.guiCraftingPlan = new GuiCraftingPlan((AbstractContainerScreen)this, craftingPlan, this.leftPos, this.topPos, 9, 18, 10);
            if (previousGuiCraftingPlan != null) {
                this.guiCraftingPlan.inheritVisualizationState(previousGuiCraftingPlan);
            }
            this.addRenderableWidget((GuiEventListener)this.guiCraftingPlan);
            this.addRenderableWidget((GuiEventListener)new ButtonText(this.leftPos + 70, this.topPos + 198, 100, 20, (Component)Component.translatable((String)"gui.integratedterminals.terminal_crafting_job.craftingplan.cancel"), (Component)Component.translatable((String)"gui.integratedterminals.terminal_crafting_job.craftingplan.cancel"), b -> this.cancelCraftingJob(), true));
        } else {
            this.guiCraftingPlan = null;
        }
    }

    public boolean keyPressed(int typedChar, int keyCode, int modifiers) {
        if (typedChar == 256) {
            this.returnToOverview();
            return true;
        }
        return super.keyPressed(typedChar, keyCode, modifiers);
    }

    private void returnToOverview() {
        PartPos center = ((PartTarget)((ContainerTerminalCraftingJobsPlan)this.getMenu()).getTarget().get()).getCenter();
        OpenCraftingJobsGuiPacket.send(center.getPos().getBlockPos(), center.getSide());
    }

    private void cancelCraftingJob() {
        IntegratedTerminals._instance.getPacketHandler().sendToServer((PacketBase)new CancelCraftingJobPacket(((ContainerTerminalCraftingJobsPlan)this.getMenu()).getCraftingJobGuiData()));
        this.returnToOverview();
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        super.renderBg(guiGraphics, partialTicks, mouseX, mouseY);
        if (this.guiCraftingPlan != null) {
            this.guiCraftingPlan.drawGuiContainerBackgroundLayer(guiGraphics, partialTicks, mouseX, mouseY);
        } else {
            guiGraphics.drawCenteredString(this.font, L10NHelpers.localize((String)"gui.integratedterminals.terminal_crafting_job.craftingplan.empty", (Object[])new Object[0]), this.leftPos + this.getBaseXSize() / 2, this.topPos + 23, 0xFFFFFF);
        }
    }

    protected void drawCurrentScreen(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.drawCurrentScreen(guiGraphics, mouseX, mouseY, partialTicks);
        if (this.guiCraftingPlan != null) {
            this.guiCraftingPlan.render(guiGraphics, mouseX, mouseY, partialTicks);
        }
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        if (this.guiCraftingPlan != null) {
            this.guiCraftingPlan.drawGuiContainerForegroundLayer(guiGraphics, mouseX, mouseY);
        }
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double mouseZ, double delta) {
        if (this.guiCraftingPlan != null) {
            return this.guiCraftingPlan.mouseScrolled(mouseX, mouseY, mouseZ, delta);
        }
        return super.mouseScrolled(mouseX, mouseY, mouseZ, delta);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int mouseButton, double mouseXPrev, double mouseYPrev) {
        if (this.guiCraftingPlan != null) {
            return this.guiCraftingPlan.mouseDragged(mouseX, mouseY, mouseButton, mouseXPrev, mouseYPrev);
        }
        return super.mouseDragged(mouseX, mouseY, mouseButton, mouseXPrev, mouseYPrev);
    }

    public void onUpdate(int valueId, CompoundTag value) {
        super.onUpdate(valueId, value);
        if (((ContainerTerminalCraftingJobsPlan)this.getMenu()).getCraftingPlanNotifierId() == valueId) {
            this.init();
        }
    }
}

