/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedterminals.client.gui.container;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import org.cyclops.commoncapabilities.api.ingredient.IPrototypedIngredient;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.commoncapabilities.api.ingredient.PrototypedIngredient;
import org.cyclops.cyclopscore.client.gui.component.WidgetScrollBar;
import org.cyclops.cyclopscore.client.gui.component.button.ButtonExtended;
import org.cyclops.cyclopscore.client.gui.component.button.ButtonText;
import org.cyclops.cyclopscore.client.gui.component.input.WidgetNumberField;
import org.cyclops.cyclopscore.client.gui.container.ContainerScreenExtended;
import org.cyclops.cyclopscore.helper.GuiHelpers;
import org.cyclops.cyclopscore.helper.RenderHelpers;
import org.cyclops.integratedterminals.Capabilities;
import org.cyclops.integratedterminals.IntegratedTerminals;
import org.cyclops.integratedterminals.api.ingredient.IIngredientComponentTerminalStorageHandler;
import org.cyclops.integratedterminals.api.terminalstorage.crafting.ITerminalCraftingOption;
import org.cyclops.integratedterminals.client.gui.container.ContainerScreenTerminalStorage;
import org.cyclops.integratedterminals.core.client.gui.CraftingOptionGuiData;
import org.cyclops.integratedterminals.inventory.container.ContainerTerminalStorageCraftingOptionAmountBase;
import org.cyclops.integratedterminals.network.packet.TerminalStorageIngredientOpenCraftingPlanGuiPacket;

public class ContainerScreenTerminalStorageCraftingOptionAmount<L, C extends ContainerTerminalStorageCraftingOptionAmountBase<L>>
extends ContainerScreenExtended<C> {
    public static int OUTPUT_SLOT_X = 135;
    public static int OUTPUT_SLOT_Y = 15;
    private final List<IPrototypedIngredient<?, ?>> outputs = Lists.newArrayList();
    private WidgetNumberField numberField = null;
    private WidgetScrollBar scrollBar;
    private int firstRow;
    private ButtonText nextButton;

    public ContainerScreenTerminalStorageCraftingOptionAmount(C container, Inventory inventory, Component title) {
        super(container, inventory, title);
        ITerminalCraftingOption<?> option = ((ContainerTerminalStorageCraftingOptionAmountBase)this.getMenu()).getCraftingOptionGuiData().getCraftingOption().getCraftingOption();
        for (IngredientComponent<?, ?> outputComponent : option.getOutputComponents()) {
            for (Object output : option.getOutputs(outputComponent)) {
                this.outputs.add((IPrototypedIngredient<?, ?>)new PrototypedIngredient(outputComponent, output, null));
            }
        }
    }

    protected ResourceLocation constructGuiTexture() {
        return new ResourceLocation("integratedterminals", "textures/gui/crafting_option_amount.png");
    }

    public int getBaseXSize() {
        return 178;
    }

    public int getBaseYSize() {
        return 162;
    }

    public void init() {
        super.init();
        this.numberField = new WidgetNumberField(Minecraft.getInstance().font, this.leftPos + 25, this.topPos + 36, 53, 14, true, (Component)Component.translatable((String)"gui.integratedterminals.amount"), true);
        this.numberField.setPositiveOnly(true);
        this.numberField.setMaxLength(5);
        this.numberField.setMaxValue(10000);
        this.numberField.setMinValue(1);
        this.numberField.setVisible(true);
        this.numberField.setTextColor(0xFFFFFF);
        this.numberField.setCanLoseFocus(true);
        this.numberField.setValue("1");
        this.addRenderableWidget((GuiEventListener)this.numberField);
        this.scrollBar = new WidgetScrollBar(this.leftPos + 153, this.topPos + 15, 54, (Component)Component.translatable((String)"gui.cyclopscore.scrollbar"), this::setFirstRow, 3);
        this.scrollBar.setTotalRows(this.outputs.size() - 1);
        this.addWidget((GuiEventListener)this.scrollBar);
        this.addRenderableWidget((GuiEventListener)new ButtonChangeQuantity(this.leftPos + 5, this.topPos + 10, 10, this::buttonChangeQuantity));
        this.addRenderableWidget((GuiEventListener)new ButtonChangeQuantity(this.leftPos + 5, this.topPos + 55, -10, this::buttonChangeQuantity));
        this.addRenderableWidget((GuiEventListener)new ButtonChangeQuantity(this.leftPos + 48, this.topPos + 10, 100, this::buttonChangeQuantity));
        this.addRenderableWidget((GuiEventListener)new ButtonChangeQuantity(this.leftPos + 48, this.topPos + 55, -100, this::buttonChangeQuantity));
        this.addRenderableWidget((GuiEventListener)new ButtonChangeQuantity(this.leftPos + 91, this.topPos + 10, 1000, this::buttonChangeQuantity));
        this.addRenderableWidget((GuiEventListener)new ButtonChangeQuantity(this.leftPos + 91, this.topPos + 55, -1000, this::buttonChangeQuantity));
        this.nextButton = new ButtonText(this.leftPos + 81, this.topPos + 33, 50, 20, (Component)Component.translatable((String)"gui.integratedterminals.terminal_storage.step.next"), (Component)Component.translatable((String)"gui.integratedterminals.terminal_storage.step.next").withStyle(ChatFormatting.YELLOW), bb -> this.calculateCraftingJob(), true);
        this.addRenderableWidget((GuiEventListener)this.nextButton);
    }

    public boolean charTyped(char typedChar, int keyCode) {
        return this.numberField.charTyped(typedChar, keyCode) || super.charTyped(typedChar, keyCode);
    }

    public boolean keyPressed(int typedChar, int keyCode, int modifiers) {
        if (typedChar == 256) {
            this.returnToTerminalStorage();
            return true;
        }
        if (typedChar == 257 || typedChar == 335) {
            this.calculateCraftingJob();
            return true;
        }
        return this.numberField.keyPressed(typedChar, keyCode, modifiers) || super.keyPressed(typedChar, keyCode, modifiers);
    }

    private void returnToTerminalStorage() {
        CraftingOptionGuiData data = ((ContainerTerminalStorageCraftingOptionAmountBase)this.getMenu()).getCraftingOptionGuiData();
        data.getLocation().openContainerFromClient(data);
    }

    public void buttonChangeQuantity(Button button) {
        if (button instanceof ButtonChangeQuantity) {
            int diff = ((ButtonChangeQuantity)button).getDiff();
            this.setAmount(this.getAmount() + diff);
        }
    }

    private void calculateCraftingJob() {
        CraftingOptionGuiData craftingOptionData = ((ContainerTerminalStorageCraftingOptionAmountBase)this.getMenu()).getCraftingOptionGuiData().copyWithAmount(this.getAmount());
        IntegratedTerminals._instance.getPacketHandler().sendToServer(new TerminalStorageIngredientOpenCraftingPlanGuiPacket(craftingOptionData));
    }

    protected <T, M> void drawInstance(GuiGraphics guiGraphics, IngredientComponent<T, M> ingredientComponent, T instance, int x, int y, ContainerScreenTerminalStorage.DrawLayer layer, float partialTick, int mouseX, int mouseY) {
        long quantity = ingredientComponent.getMatcher().getQuantity(instance) * (long)this.getAmount();
        ((IIngredientComponentTerminalStorageHandler)ingredientComponent.getCapability(Capabilities.IngredientComponentTerminalStorageHandler.INGREDIENT).orElseThrow(() -> new IllegalStateException("Could not find ingredient terminal storage handler"))).drawInstance(guiGraphics, ingredientComponent.getMatcher().withQuantity(instance, quantity), quantity, GuiHelpers.quantityToScaledString((long)quantity), (AbstractContainerScreen)this, layer, partialTick, x, y, mouseX, mouseY, null);
    }

    private int getAmount() {
        try {
            return this.numberField.getInt();
        }
        catch (NumberFormatException e) {
            return 1;
        }
    }

    private void setAmount(int amount) {
        this.numberField.setValue(Integer.toString(this.numberField.validateNumber(amount)));
    }

    protected void drawOutputSlots(GuiGraphics guiGraphics, int x, int y, float partialTicks, int mouseX, int mouseY, ContainerScreenTerminalStorage.DrawLayer layer) {
        int offsetY = OUTPUT_SLOT_Y;
        for (IPrototypedIngredient<?, ?> output : this.outputs.subList(this.firstRow, Math.min(this.outputs.size(), this.firstRow + this.scrollBar.getVisibleRows()))) {
            this.drawInstance(guiGraphics, output.getComponent(), output.getPrototype(), x + OUTPUT_SLOT_X, y + offsetY, layer, partialTicks, mouseX, mouseY);
            offsetY += GuiHelpers.SLOT_SIZE;
        }
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        super.renderBg(guiGraphics, partialTicks, mouseX, mouseY);
        this.numberField.render(guiGraphics, mouseX - this.leftPos, mouseY - this.topPos, partialTicks);
        this.scrollBar.render(guiGraphics, mouseX, mouseY, partialTicks);
        RenderHelpers.bindTexture((ResourceLocation)this.texture);
        this.drawOutputSlots(guiGraphics, this.leftPos, this.topPos, partialTicks, mouseX - this.leftPos, mouseY - this.topPos, ContainerScreenTerminalStorage.DrawLayer.BACKGROUND);
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        this.drawOutputSlots(guiGraphics, 0, 0, 0.0f, mouseX, mouseY, ContainerScreenTerminalStorage.DrawLayer.FOREGROUND);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int mouseButton, double mouseXPrev, double mouseYPrev) {
        return this.getFocused() != null && this.isDragging() && mouseButton == 0 && this.getFocused().mouseDragged(mouseX, mouseY, mouseButton, mouseXPrev, mouseYPrev) ? true : super.mouseDragged(mouseX, mouseY, mouseButton, mouseXPrev, mouseYPrev);
    }

    public void setFirstRow(int firstRow) {
        this.firstRow = firstRow;
    }

    public class ButtonChangeQuantity
    extends ButtonExtended {
        private final int diff;

        public ButtonChangeQuantity(int x, int y, int diff, Button.OnPress pressCallback) {
            super(x, y, 40, 20, (Component)Component.literal((String)((diff < 0 ? "- " : "+ ") + Integer.toString(Math.abs(diff)))), pressCallback, true);
            this.diff = diff;
        }

        protected void drawButtonInner(GuiGraphics guiGraphics, int i, int j) {
            int color = 0xE0E0E0;
            if (!this.active) {
                color = 0xA0A0A0;
            } else if (this.isHovered) {
                color = 0xFFFFA0;
            }
            guiGraphics.drawCenteredString(((ContainerScreenTerminalStorageCraftingOptionAmount)ContainerScreenTerminalStorageCraftingOptionAmount.this).minecraft.font, this.getMessage(), this.getX() + this.width / 2, this.getY() + (this.height - 8) / 2, color);
        }

        public int getDiff() {
            return this.diff;
        }
    }
}

