/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedterminals.client.gui.container;

import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import org.cyclops.cyclopscore.client.gui.component.button.ButtonText;
import org.cyclops.cyclopscore.client.gui.container.ContainerScreenExtended;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.integratedterminals.api.terminalstorage.crafting.ITerminalCraftingPlan;
import org.cyclops.integratedterminals.client.gui.container.component.GuiCraftingPlan;
import org.cyclops.integratedterminals.core.client.gui.CraftingOptionGuiData;
import org.cyclops.integratedterminals.inventory.container.ContainerTerminalStorageCraftingPlanBase;

public class ContainerScreenTerminalStorageCraftingPlan<L, C extends ContainerTerminalStorageCraftingPlanBase<L>>
extends ContainerScreenExtended<C> {
    @Nullable
    private GuiCraftingPlan guiCraftingPlan;
    private ITerminalCraftingPlan craftingPlan;
    private ButtonText buttonConfirm;

    public ContainerScreenTerminalStorageCraftingPlan(C container, Inventory inventory, Component title) {
        super(container, inventory, title);
    }

    protected ResourceLocation constructGuiTexture() {
        return new ResourceLocation("integratedterminals", "textures/gui/crafting_plan.png");
    }

    public int getBaseXSize() {
        return 256;
    }

    public int getBaseYSize() {
        return 222;
    }

    public void init() {
        super.init();
        this.renderables.clear();
        this.children().clear();
        if (this.craftingPlan != null) {
            this.guiCraftingPlan = new GuiCraftingPlan((AbstractContainerScreen)this, this.craftingPlan, this.leftPos, this.topPos, 9, 18, 10);
            this.addRenderableWidget((GuiEventListener)this.guiCraftingPlan);
        } else {
            this.guiCraftingPlan = null;
        }
        this.buttonConfirm = new ButtonText(this.leftPos + 95, this.topPos + 198, 50, 20, (Component)Component.translatable((String)"gui.integratedterminals.terminal_storage.step.craft"), (Component)Component.translatable((String)"gui.integratedterminals.terminal_storage.step.craft").withStyle(ChatFormatting.YELLOW), this.createServerPressable("start", b -> {}), true);
        this.addRenderableWidget((GuiEventListener)this.buttonConfirm);
        this.buttonConfirm.active = this.guiCraftingPlan != null && this.guiCraftingPlan.isValid();
    }

    public boolean keyPressed(int typedChar, int keyCode, int modifiers) {
        if (this.guiCraftingPlan != null && this.guiCraftingPlan.isValid() && (typedChar == 257 || typedChar == 335)) {
            this.buttonConfirm.onPress();
            return true;
        }
        return super.keyPressed(typedChar, keyCode, modifiers);
    }

    private void returnToTerminalStorage() {
        CraftingOptionGuiData data = ((ContainerTerminalStorageCraftingPlanBase)this.getMenu()).getCraftingOptionGuiData();
        data.getLocation().openContainerFromClient(data);
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        super.renderBg(guiGraphics, partialTicks, mouseX, mouseY);
        if (this.guiCraftingPlan != null) {
            this.guiCraftingPlan.drawGuiContainerBackgroundLayer(guiGraphics, partialTicks, mouseX, mouseY);
        } else {
            guiGraphics.drawCenteredString(this.font, L10NHelpers.localize((String)"gui.integratedterminals.terminal_storage.step.crafting_plan_calculating", (Object[])new Object[0]), this.leftPos + this.getBaseXSize() / 2, this.topPos + 23, 0xFFFFFF);
        }
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        if (this.guiCraftingPlan != null) {
            this.guiCraftingPlan.drawGuiContainerForegroundLayer(guiGraphics, mouseX, mouseY);
        }
    }

    protected void drawCurrentScreen(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.drawCurrentScreen(guiGraphics, mouseX, mouseY, partialTicks);
        if (this.guiCraftingPlan != null) {
            this.guiCraftingPlan.render(guiGraphics, mouseX, mouseY, partialTicks);
        }
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double mouseZ, double delta) {
        if (this.guiCraftingPlan != null) {
            return this.guiCraftingPlan.mouseScrolled(mouseX, mouseY, mouseZ, delta);
        }
        return super.mouseScrolled(mouseX, mouseY, mouseZ, delta);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int mouseButton, double mouseXPrev, double mouseYPrev) {
        if (this.guiCraftingPlan != null) {
            return this.guiCraftingPlan.mouseDragged(mouseX, mouseY, mouseButton, mouseXPrev, mouseYPrev);
        }
        return super.mouseDragged(mouseX, mouseY, mouseButton, mouseXPrev, mouseYPrev);
    }

    public void onUpdate(int valueId, CompoundTag value) {
        super.onUpdate(valueId, value);
        if (((ContainerTerminalStorageCraftingPlanBase)this.getMenu()).getCraftingPlanNotifierId() == valueId) {
            this.craftingPlan = ((ContainerTerminalStorageCraftingPlanBase)this.getMenu()).getCraftingOptionGuiData().getCraftingOption().getHandler().deserializeCraftingPlan(value);
            this.init();
        }
    }
}

