/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedterminals.core.client.gui;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import org.cyclops.integratedterminals.api.terminalstorage.crafting.ITerminalStorageTabIngredientCraftingHandler;
import org.cyclops.integratedterminals.core.terminalstorage.crafting.TerminalStorageTabIngredientCraftingHandlers;

public class CraftingJobGuiData {
    private final BlockPos pos;
    private final Direction side;
    private final int channel;
    private final ITerminalStorageTabIngredientCraftingHandler handler;
    private final Object craftingJob;

    public CraftingJobGuiData(BlockPos pos, Direction side, int channel, ITerminalStorageTabIngredientCraftingHandler handler, Object craftingJob) {
        this.pos = pos;
        this.side = side;
        this.channel = channel;
        this.handler = handler;
        this.craftingJob = craftingJob;
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public Direction getSide() {
        return this.side;
    }

    public int getChannel() {
        return this.channel;
    }

    public ITerminalStorageTabIngredientCraftingHandler getHandler() {
        return this.handler;
    }

    public Object getCraftingJob() {
        return this.craftingJob;
    }

    public void writeToPacketBuffer(FriendlyByteBuf packetBuffer) {
        packetBuffer.writeBlockPos(this.pos);
        packetBuffer.writeInt(this.side.ordinal());
        packetBuffer.writeInt(this.channel);
        packetBuffer.writeUtf(this.handler.getId().toString());
        CompoundTag tag = new CompoundTag();
        tag.put("id", this.handler.serializeCraftingJobId(this.craftingJob));
        packetBuffer.writeNbt((Tag)tag);
    }

    public static CraftingJobGuiData readFromPacketBuffer(FriendlyByteBuf packetBuffer) {
        BlockPos pos = packetBuffer.readBlockPos();
        Direction side = Direction.values()[packetBuffer.readInt()];
        int channel = packetBuffer.readInt();
        ITerminalStorageTabIngredientCraftingHandler handler = TerminalStorageTabIngredientCraftingHandlers.REGISTRY.getHandler(new ResourceLocation(packetBuffer.readUtf(Short.MAX_VALUE)));
        Object craftingJob = handler.deserializeCraftingJobId(packetBuffer.readNbt().get("id"));
        return new CraftingJobGuiData(pos, side, channel, handler, craftingJob);
    }
}

