/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedterminals.core.terminalstorage.location;

import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import org.cyclops.cyclopscore.inventory.ItemLocation;
import org.cyclops.integratedterminals.api.terminalstorage.location.ITerminalStorageLocation;
import org.cyclops.integratedterminals.core.client.gui.CraftingOptionGuiData;
import org.cyclops.integratedterminals.inventory.container.ContainerTerminalStorageCraftingOptionAmountItem;
import org.cyclops.integratedterminals.inventory.container.ContainerTerminalStorageCraftingPlanItem;
import org.cyclops.integratedterminals.network.packet.TerminalStorageIngredientItemOpenPacket;

public class TerminalStorageLocationItem
implements ITerminalStorageLocation<ItemLocation> {
    @Override
    public ResourceLocation getName() {
        return new ResourceLocation("integratedterminals", "item");
    }

    @Override
    public <T, M> void openContainerFromClient(CraftingOptionGuiData<T, M, ItemLocation> craftingOptionGuiData) {
        ItemLocation slot = craftingOptionGuiData.getLocationInstance();
        TerminalStorageIngredientItemOpenPacket.send(slot, craftingOptionGuiData.getTabName(), craftingOptionGuiData.getChannel());
    }

    @Override
    public <T, M> void openContainerFromServer(CraftingOptionGuiData<T, M, ItemLocation> craftingOptionGuiData, Level world, ServerPlayer player) {
        ItemLocation slot = craftingOptionGuiData.getLocationInstance();
        TerminalStorageIngredientItemOpenPacket.openServer(world, slot, player, craftingOptionGuiData.getTabName(), craftingOptionGuiData.getChannel());
    }

    @Override
    public <T, M> void openContainerCraftingPlan(final CraftingOptionGuiData<T, M, ItemLocation> craftingOptionGuiData, Level world, ServerPlayer player) {
        final ItemLocation location = craftingOptionGuiData.getLocationInstance();
        MenuProvider containerProvider = new MenuProvider(){

            public Component getDisplayName() {
                return Component.literal((String)"");
            }

            public AbstractContainerMenu createMenu(int id, Inventory playerInventory, Player playerEntity) {
                return new ContainerTerminalStorageCraftingPlanItem(id, playerInventory, location, craftingOptionGuiData);
            }
        };
        player.openMenu(containerProvider, packetBuffer -> {
            ItemLocation.writeToPacketBuffer((FriendlyByteBuf)packetBuffer, (ItemLocation)location);
            craftingOptionGuiData.writeToPacketBuffer((FriendlyByteBuf)packetBuffer);
        });
    }

    @Override
    public <T, M> void openContainerCraftingOptionAmount(final CraftingOptionGuiData<T, M, ItemLocation> craftingOptionGuiData, Level world, ServerPlayer player) {
        final ItemLocation location = craftingOptionGuiData.getLocationInstance();
        MenuProvider containerProvider = new MenuProvider(){

            public Component getDisplayName() {
                return Component.literal((String)"");
            }

            public AbstractContainerMenu createMenu(int id, Inventory playerInventory, Player playerEntity) {
                return new ContainerTerminalStorageCraftingOptionAmountItem(id, playerInventory, location, craftingOptionGuiData);
            }
        };
        player.openMenu(containerProvider, packetBuffer -> {
            ItemLocation.writeToPacketBuffer((FriendlyByteBuf)packetBuffer, (ItemLocation)location);
            craftingOptionGuiData.writeToPacketBuffer((FriendlyByteBuf)packetBuffer);
        });
    }

    @Override
    public void writeToPacketBuffer(FriendlyByteBuf packetBuffer, ItemLocation location) {
        ItemLocation.writeToPacketBuffer((FriendlyByteBuf)packetBuffer, (ItemLocation)location);
    }

    @Override
    public ItemLocation readFromPacketBuffer(FriendlyByteBuf packetBuffer) {
        return ItemLocation.readFromPacketBuffer((FriendlyByteBuf)packetBuffer);
    }
}

