/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedterminals.item;

import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import org.cyclops.cyclopscore.datastructure.Wrapper;
import org.cyclops.cyclopscore.inventory.ItemLocation;
import org.cyclops.cyclopscore.inventory.container.NamedContainerProviderItem;
import org.cyclops.cyclopscore.item.ItemGui;
import org.cyclops.cyclopscore.persist.IDirtyMarkListener;
import org.cyclops.integrateddynamics.RegistryEntries;
import org.cyclops.integrateddynamics.api.network.INetwork;
import org.cyclops.integrateddynamics.api.part.PartPos;
import org.cyclops.integrateddynamics.block.BlockCable;
import org.cyclops.integrateddynamics.core.block.BlockRayTraceResultComponent;
import org.cyclops.integrateddynamics.core.helper.PartHelpers;
import org.cyclops.integrateddynamics.core.part.PartTypes;
import org.cyclops.integrateddynamics.part.PartTypeConnectorOmniDirectional;
import org.cyclops.integratedterminals.api.terminalstorage.ITerminalStorageTabCommon;
import org.cyclops.integratedterminals.inventory.container.ContainerTerminalStorageItem;
import org.cyclops.integratedterminals.inventory.container.TerminalStorageState;

public class ItemTerminalStoragePortable
extends ItemGui {
    public static String NBT_KEY_GROUP = "integratedterminals:groupKey";
    public static String NBT_KEY_NAMED_INVENTORIES = "integratedterminals:namedInventories";
    public static String NBT_KEY_STATES = "integratedterminals:terminalStorageStates";

    public ItemTerminalStoragePortable(Item.Properties properties) {
        super(properties);
    }

    public void openGuiForItemIndex(Level world, ServerPlayer player, ItemLocation itemLocation) {
        if (world.isClientSide()) {
            super.openGuiForItemIndex(world, player, itemLocation);
        } else {
            ItemStack itemStack = itemLocation.getItemStack((Player)player);
            int groupId = ItemTerminalStoragePortable.getGroupId(itemStack);
            if (groupId >= 0) {
                Optional<INetwork> network = ContainerTerminalStorageItem.getNetworkFromItem(itemStack);
                if (network.isPresent()) {
                    super.openGuiForItemIndex(world, player, itemLocation);
                } else {
                    player.displayClientMessage((Component)Component.translatable((String)"item.integratedterminals.terminal_storage_portable.status.invalid_network"), true);
                }
            } else {
                player.displayClientMessage((Component)Component.translatable((String)"item.integratedterminals.terminal_storage_portable.status.no_network"), true);
            }
        }
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        BlockRayTraceResultComponent rayTraceResult;
        BlockState blockState;
        if (!context.getLevel().isClientSide() && context.getPlayer() != null && (blockState = context.getLevel().getBlockState(context.getClickedPos())).getBlock() == RegistryEntries.BLOCK_CABLE.get() && (rayTraceResult = ((BlockCable)blockState.getBlock()).getSelectedShape(blockState, (BlockGetter)context.getLevel(), context.getClickedPos(), CollisionContext.of((Entity)context.getPlayer())).rayTrace(context.getClickedPos(), (Entity)context.getPlayer())) != null) {
            Direction partDirection = rayTraceResult.getComponent().getRaytraceDirection();
            PartPos partPos = PartPos.of((Level)context.getLevel(), (BlockPos)context.getClickedPos(), (Direction)partDirection);
            PartHelpers.PartStateHolder partStateHolder = PartHelpers.getPart((PartPos)partPos);
            if (partStateHolder != null && partStateHolder.getPart() == PartTypes.CONNECTOR_OMNI) {
                PartTypeConnectorOmniDirectional.State state = (PartTypeConnectorOmniDirectional.State)partStateHolder.getState();
                ItemTerminalStoragePortable.setGroupId(stack, state.getGroupId());
                context.getPlayer().displayClientMessage((Component)Component.translatable((String)"item.integratedterminals.terminal_storage_portable.status.linked"), true);
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    @Nullable
    public MenuProvider getContainer(Level world, Player playerEntity, ItemLocation itemLocation) {
        return new NamedContainerProviderItem(itemLocation, itemLocation.getItemStack(playerEntity).getHoverName(), (id, playerInventory, itemLocation1) -> new ContainerTerminalStorageItem(id, playerInventory, itemLocation1, Optional.empty(), ItemTerminalStoragePortable.getTerminalStorageState(itemLocation.getItemStack(playerEntity), playerEntity, itemLocation1)));
    }

    public Class<? extends AbstractContainerMenu> getContainerClass(Level world, Player playerEntity, ItemStack itemStack) {
        return ContainerTerminalStorageItem.class;
    }

    public void writeExtraGuiData(FriendlyByteBuf packetBuffer, Level world, ServerPlayer player, ItemLocation itemLocation) {
        super.writeExtraGuiData(packetBuffer, world, player, itemLocation);
        packetBuffer.writeBoolean(false);
        ItemTerminalStoragePortable.getTerminalStorageState(itemLocation.getItemStack((Player)player), (Player)player, itemLocation).writeToPacketBuffer(packetBuffer);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return oldStack == null || newStack == null || oldStack.getItem() != newStack.getItem();
    }

    public void appendHoverText(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        super.appendHoverText(stack, worldIn, tooltip, flagIn);
        int groupId = ItemTerminalStoragePortable.getGroupId(stack);
        if (groupId >= 0) {
            tooltip.add((Component)Component.translatable((String)"parttype.integrateddynamics.tooltip.monodirectionalconnector.group", (Object[])new Object[]{groupId}));
        }
    }

    public static int getGroupId(ItemStack itemStack) {
        CompoundTag tag = itemStack.getTag();
        if (tag == null || !tag.contains(NBT_KEY_GROUP, 3)) {
            return -1;
        }
        return tag.getInt(NBT_KEY_GROUP);
    }

    public static void setGroupId(ItemStack itemStack, int groupId) {
        CompoundTag tag = itemStack.getOrCreateTag();
        tag.putInt(NBT_KEY_GROUP, groupId);
    }

    public static ITerminalStorageTabCommon.IVariableInventory getVariableInventory(ItemStack itemStack) {
        CompoundTag tagRoot = itemStack.getOrCreateTag();
        if (!tagRoot.contains(NBT_KEY_NAMED_INVENTORIES, 10)) {
            tagRoot.put(NBT_KEY_NAMED_INVENTORIES, (Tag)new CompoundTag());
        }
        final CompoundTag tagInventories = tagRoot.getCompound(NBT_KEY_NAMED_INVENTORIES);
        return new ITerminalStorageTabCommon.IVariableInventory(){

            @Override
            public NonNullList<ItemStack> getNamedInventory(String name) {
                CompoundTag tag = tagInventories.getCompound(name);
                NonNullList list = NonNullList.withSize((int)tag.getInt("itemCount"), (Object)ItemStack.EMPTY);
                ContainerHelper.loadAllItems((CompoundTag)tag, (NonNullList)list);
                return list;
            }

            @Override
            public void setNamedInventory(String name, NonNullList<ItemStack> inventory) {
                CompoundTag tag = new CompoundTag();
                tag.putString("tabName", name);
                tag.putInt("itemCount", inventory.size());
                ContainerHelper.saveAllItems((CompoundTag)tag, inventory);
                tagInventories.put(name, (Tag)tag);
            }
        };
    }

    public static TerminalStorageState getTerminalStorageState(ItemStack itemStack, Player player, ItemLocation itemLocation) {
        CompoundTag tagRoot = itemStack.getOrCreateTag();
        if (!tagRoot.contains(NBT_KEY_STATES, 10)) {
            tagRoot.put(NBT_KEY_STATES, (Tag)new CompoundTag());
        }
        CompoundTag tagStates = tagRoot.getCompound(NBT_KEY_STATES);
        String playerKey = player.getUUID().toString();
        Wrapper stateWrapped = new Wrapper();
        IDirtyMarkListener dirtyMarkListener = () -> tagStates.put(playerKey, (Tag)((TerminalStorageState)stateWrapped.get()).getTag());
        if (!tagStates.contains(playerKey, 10)) {
            TerminalStorageState state = TerminalStorageState.getPlayerDefault(player, dirtyMarkListener);
            stateWrapped.set((Object)state);
            tagStates.put(playerKey, (Tag)state.getTag());
            return state;
        }
        TerminalStorageState state = new TerminalStorageState(tagStates.getCompound(playerKey), dirtyMarkListener);
        stateWrapped.set((Object)state);
        return state;
    }
}

