/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedterminals.network.packet;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.cyclops.commoncapabilities.IngredientComponents;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.cyclopscore.network.CodecField;
import org.cyclops.cyclopscore.network.PacketCodec;
import org.cyclops.integratedterminals.core.terminalstorage.TerminalStorageTabIngredientComponentClient;
import org.cyclops.integratedterminals.core.terminalstorage.TerminalStorageTabIngredientComponentItemStackCrafting;
import org.cyclops.integratedterminals.core.terminalstorage.crafting.HandlerWrappedTerminalCraftingOption;
import org.cyclops.integratedterminals.inventory.container.ContainerTerminalStorageBase;

public class TerminalStorageIngredientCraftingOptionsPacket
extends PacketCodec {
    public static final ResourceLocation ID = new ResourceLocation("integratedterminals", "terminal_storage_ingredient_crafting_options");
    @CodecField
    private String tabId;
    @CodecField
    private int channel;
    @CodecField
    private CompoundTag data;
    @CodecField
    private boolean reset;
    @CodecField
    private boolean firstChannel;

    public TerminalStorageIngredientCraftingOptionsPacket() {
        super(ID);
    }

    public <T> TerminalStorageIngredientCraftingOptionsPacket(String tabId, int channel, List<HandlerWrappedTerminalCraftingOption<T>> craftingOptions, boolean reset, boolean firstChannel) {
        super(ID);
        this.tabId = tabId;
        this.channel = channel;
        this.data = new CompoundTag();
        ListTag list = new ListTag();
        for (HandlerWrappedTerminalCraftingOption<T> option : craftingOptions) {
            list.add((Object)HandlerWrappedTerminalCraftingOption.serialize(option));
        }
        this.data.put("craftingOptions", (Tag)list);
        this.reset = reset;
        this.firstChannel = firstChannel;
    }

    public boolean isAsync() {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void actionClient(Level world, Player player) {
        if (player.containerMenu instanceof ContainerTerminalStorageBase) {
            ContainerTerminalStorageBase container = (ContainerTerminalStorageBase)player.containerMenu;
            TerminalStorageTabIngredientComponentClient tab = (TerminalStorageTabIngredientComponentClient)container.getTabClient(this.tabId);
            IngredientComponent ingredientComponent = tab.getIngredientComponent();
            ListTag list = this.data.getList("craftingOptions", 10);
            ArrayList craftingOptions = Lists.newArrayListWithExpectedSize((int)list.size());
            for (int i = 0; i < list.size(); ++i) {
                HandlerWrappedTerminalCraftingOption option = HandlerWrappedTerminalCraftingOption.deserialize(ingredientComponent, list.getCompound(i));
                craftingOptions.add(option);
            }
            tab.addCraftingOptions(this.channel, craftingOptions, this.reset, this.firstChannel);
            if (this.tabId.equals(IngredientComponents.ITEMSTACK.getName().toString())) {
                TerminalStorageTabIngredientComponentClient tabCrafting = (TerminalStorageTabIngredientComponentClient)container.getTabClient(TerminalStorageTabIngredientComponentItemStackCrafting.NAME.toString());
                tabCrafting.addCraftingOptions(this.channel, craftingOptions, this.reset, this.firstChannel);
            }
            container.refreshChannelStrings();
        }
    }

    public void actionServer(Level world, ServerPlayer player) {
    }
}

