/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedterminals.network.packet;

import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.cyclops.cyclopscore.network.CodecField;
import org.cyclops.cyclopscore.network.PacketCodec;
import org.cyclops.integratedterminals.core.terminalstorage.TerminalStorageTabIngredientComponentItemStackCraftingCommon;
import org.cyclops.integratedterminals.core.terminalstorage.TerminalStorageTabIngredientComponentServer;
import org.cyclops.integratedterminals.inventory.container.ContainerTerminalStorageBase;

public class TerminalStorageIngredientItemStackCraftingGridClear
extends PacketCodec {
    public static final ResourceLocation ID = new ResourceLocation("integratedterminals", "terminal_storage_ingredient_itemstack_crafting_grid_clear");
    @CodecField
    private String tabId;
    @CodecField
    private int channel;
    @CodecField
    private boolean toStorage;

    public TerminalStorageIngredientItemStackCraftingGridClear() {
        super(ID);
    }

    public TerminalStorageIngredientItemStackCraftingGridClear(String tabId, int channel, boolean toStorage) {
        super(ID);
        this.tabId = tabId;
        this.channel = channel;
        this.toStorage = toStorage;
    }

    public boolean isAsync() {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void actionClient(Level world, Player player) {
    }

    public void actionServer(Level world, ServerPlayer player) {
        ContainerTerminalStorageBase container;
        if (player.containerMenu instanceof ContainerTerminalStorageBase && (container = (ContainerTerminalStorageBase)player.containerMenu).getTabServer(this.tabId) instanceof TerminalStorageTabIngredientComponentServer) {
            TerminalStorageTabIngredientComponentServer tabServer = (TerminalStorageTabIngredientComponentServer)container.getTabServer(this.tabId);
            TerminalStorageTabIngredientComponentItemStackCraftingCommon tabCommon = (TerminalStorageTabIngredientComponentItemStackCraftingCommon)container.getTabCommon(this.tabId);
            TerminalStorageIngredientItemStackCraftingGridClear.clearGrid(tabCommon, tabServer, this.channel, this.toStorage, (Player)player);
        }
    }

    public static void clearGrid(TerminalStorageTabIngredientComponentItemStackCraftingCommon tabCommon, TerminalStorageTabIngredientComponentServer<ItemStack, Integer> tabServer, int channel, boolean toStorage, Player player) {
        tabCommon.getInventoryCraftResult().setItem(0, ItemStack.EMPTY);
        CraftingContainer inventoryCrafting = tabCommon.getInventoryCrafting();
        for (int i = 0; i < inventoryCrafting.getContainerSize(); ++i) {
            ItemStack itemStack = inventoryCrafting.removeItemNoUpdate(i);
            if (itemStack.isEmpty()) continue;
            if (toStorage) {
                ItemStack remainder = (ItemStack)tabServer.getIngredientNetwork().getChannel(channel).insert((Object)itemStack, false);
                inventoryCrafting.setItem(i, remainder);
                continue;
            }
            player.getInventory().placeItemBackInInventory(itemStack, true);
            inventoryCrafting.setItem(i, ItemStack.EMPTY);
        }
    }
}

