/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.variantsandventures.common.client.animation.animator;

import com.faboslav.variantsandventures.common.client.animation.KeyframeAnimation;
import com.faboslav.variantsandventures.common.client.animation.animator.context.AnimationContextTracker;
import com.faboslav.variantsandventures.common.client.animation.animator.context.KeyframeAnimationContext;
import com.faboslav.variantsandventures.common.client.model.AnimatedEntityModel;
import com.faboslav.variantsandventures.common.entity.animation.AnimatedEntity;
import com.faboslav.variantsandventures.common.entity.animation.Animation;
import com.faboslav.variantsandventures.common.entity.animation.AnimationState;
import com.faboslav.variantsandventures.common.entity.animation.Keyframe;
import com.faboslav.variantsandventures.common.entity.animation.Transformation;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import org.joml.Vector3f;

public final class ModelAnimator {
    private static final Vector3f TEMP = new Vector3f();

    public static void updateKeyframeAnimations(AnimatedEntity animatedEntity, AnimatedEntityModel animatedEntityModel, KeyframeAnimation keyframeAnimation, float animationProgress) {
        AnimationContextTracker animationContextTracker = animatedEntity.getAnimationContextTracker();
        Animation animation = keyframeAnimation.getAnimation();
        int currentTick = ((Entity)animatedEntity).tickCount;
        KeyframeAnimationContext keyframeAnimationContext = animationContextTracker.get(keyframeAnimation);
        keyframeAnimationContext.setCurrentTick(currentTick);
        AnimationState animationState = keyframeAnimationContext.getAnimationState();
        animationState.update(animationProgress, 1.0f);
        animationState.run(state -> ModelAnimator.animateKeyframe(animatedEntityModel, animation, state.getTimeRunning(), 1.0f, TEMP));
    }

    public static void updateMovementKeyframeAnimations(AnimatedEntity animatedEntity, AnimatedEntityModel animatedEntityModel, long runningTime, float f) {
        KeyframeAnimation keyframeAnimation = animatedEntity.getMovementAnimation();
        Animation animation = keyframeAnimation.getAnimation();
        ModelAnimator.animateKeyframe(animatedEntityModel, animation, runningTime, f, TEMP);
    }

    public static void animateKeyframe(AnimatedEntityModel model, Animation animation, long runningTime, float scale, Vector3f vec3f) {
        float f = ModelAnimator.getRunningSeconds(animation, runningTime);
        for (Map.Entry<String, List<Transformation>> entry : animation.boneAnimations().entrySet()) {
            Optional<ModelPart> optional = model.variantsandventures$getChild(entry.getKey());
            List<Transformation> list = entry.getValue();
            optional.ifPresent(part -> list.forEach(transformation -> {
                Keyframe[] keyframes = transformation.keyframes();
                int i = Math.max(0, Mth.binarySearch((int)0, (int)keyframes.length, index -> f <= keyframes[index].timestamp()) - 1);
                int j = Math.min(keyframes.length - 1, i + 1);
                Keyframe keyframe = keyframes[i];
                Keyframe keyframe2 = keyframes[j];
                float h = f - keyframe.timestamp();
                float k = j != i ? Mth.clamp((float)(h / (keyframe2.timestamp() - keyframe.timestamp())), (float)0.0f, (float)1.0f) : 0.0f;
                keyframe2.interpolation().apply(vec3f, k, keyframes, i, j, scale);
                Transformation.Type type = transformation.type();
                if (type == Transformation.Type.TRANSLATE) {
                    part.offsetPos(vec3f);
                } else if (type == Transformation.Type.ROTATE) {
                    part.offsetRotation(vec3f);
                } else if (type == Transformation.Type.SCALE) {
                    part.offsetScale(vec3f);
                }
            }));
        }
    }

    private static float getRunningSeconds(Animation animation, long runningTime) {
        float f = (float)runningTime / 1000.0f;
        return animation.looping() ? f % animation.lengthInSeconds() : f;
    }
}

