/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.variantsandventures.common.entity.animation;

import com.faboslav.variantsandventures.common.entity.animation.Keyframe;
import net.minecraft.util.Mth;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public record Transformation(Type type, Keyframe[] keyframes) {

    public static enum Type {
        TRANSLATE,
        ROTATE,
        SCALE;

    }

    public static interface Interpolation {
        public Vector3f apply(Vector3f var1, float var2, Keyframe[] var3, int var4, int var5, float var6);
    }

    public static class Interpolations {
        public static final Interpolation LINEAR = (vector3f, delta, keyframes, start, end, g) -> {
            Vector3f vector3f2 = keyframes[start].target();
            Vector3f vector3f3 = keyframes[end].target();
            return vector3f2.lerp((Vector3fc)vector3f3, delta, vector3f).mul(g);
        };
        public static final Interpolation CUBIC = (vector3f, delta, keyframes, start, end, g) -> {
            Vector3f vector3f2 = keyframes[Math.max(0, start - 1)].target();
            Vector3f vector3f3 = keyframes[start].target();
            Vector3f vector3f4 = keyframes[end].target();
            Vector3f vector3f5 = keyframes[Math.min(keyframes.length - 1, end + 1)].target();
            vector3f.set(Mth.catmullrom((float)delta, (float)vector3f2.x(), (float)vector3f3.x(), (float)vector3f4.x(), (float)vector3f5.x()) * g, Mth.catmullrom((float)delta, (float)vector3f2.y(), (float)vector3f3.y(), (float)vector3f4.y(), (float)vector3f5.y()) * g, Mth.catmullrom((float)delta, (float)vector3f2.z(), (float)vector3f3.z(), (float)vector3f4.z(), (float)vector3f5.z()) * g);
            return vector3f;
        };
    }
}

