/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.variantsandventures.common.entity.event;

import com.faboslav.variantsandventures.common.VariantsAndVentures;
import com.faboslav.variantsandventures.common.events.entity.EntitySpawnEvent;
import com.faboslav.variantsandventures.common.tag.VariantsAndVenturesTags;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.monster.Stray;
import net.minecraft.world.level.LevelAccessor;

public final class StrayOnEntitySpawn {
    public static boolean handleEntitySpawn(EntitySpawnEvent event) {
        Mob entity = event.entity();
        if (event.spawnReason() == MobSpawnType.NATURAL || event.spawnReason() == MobSpawnType.SPAWNER || event.spawnReason() == MobSpawnType.CHUNK_GENERATION || event.spawnReason() == MobSpawnType.STRUCTURE) {
            if (entity.getType() != EntityType.SKELETON) {
                return false;
            }
            if (!VariantsAndVentures.getConfig().enableBetterStraySpawns) {
                return false;
            }
            if ((float)event.entity().blockPosition().getY() < VariantsAndVentures.getConfig().strayMinimumYLevel) {
                return false;
            }
            if (event.entity().getRandom().nextFloat() >= VariantsAndVentures.getConfig().straySpawnChance) {
                return false;
            }
            LevelAccessor worldAccess = event.worldAccess();
            Holder biome = worldAccess.getBiome(entity.blockPosition());
            if (!biome.is(VariantsAndVenturesTags.HAS_STRAY)) {
                return false;
            }
            Stray stray = (Stray)EntityType.STRAY.create((ServerLevel)event.worldAccess(), null, null, event.entity().blockPosition(), event.spawnReason(), false, false);
            if (stray == null) {
                return false;
            }
            stray.copyPosition((Entity)entity);
            stray.yBodyRotO = entity.yBodyRotO;
            stray.yBodyRot = entity.yBodyRot;
            stray.yHeadRotO = entity.yHeadRotO;
            stray.yHeadRot = entity.yHeadRot;
            stray.setBaby(event.isBaby());
            worldAccess.addFreshEntity((Entity)stray);
            return true;
        }
        return false;
    }
}

