/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.variantsandventures.common.items;

import com.faboslav.variantsandventures.common.events.lifecycle.SetupEvent;
import com.faboslav.variantsandventures.common.mixin.SpawnEggItemAccessor;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.Direction;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DispenserAddedSpawnEgg
extends SpawnEggItem {
    private static final List<Pair<Supplier<? extends EntityType<? extends Mob>>, SpawnEggItem>> SPAWN_EGGS = new ArrayList<Pair<Supplier<? extends EntityType<? extends Mob>>, SpawnEggItem>>();
    private final Supplier<? extends EntityType<? extends Mob>> entityType;

    public DispenserAddedSpawnEgg(Supplier<? extends EntityType<? extends Mob>> typeIn, int primaryColorIn, int secondaryColorIn, Item.Properties builder) {
        super(null, primaryColorIn, secondaryColorIn, builder);
        this.entityType = typeIn;
        this.setupDispenserBehavior();
        SPAWN_EGGS.add((Pair<Supplier<? extends EntityType<? extends Mob>>, SpawnEggItem>)new Pair(typeIn, (Object)this));
    }

    protected void setupDispenserBehavior() {
        DispenserBlock.registerBehavior((ItemLike)this, (DispenseItemBehavior)new DefaultDispenseItemBehavior(){

            public ItemStack execute(@NotNull BlockSource source, @NotNull ItemStack stack) {
                Direction direction = (Direction)source.state().getValue((Property)DispenserBlock.FACING);
                EntityType entitytype = ((SpawnEggItem)stack.getItem()).getType(stack.getTag());
                entitytype.spawn(source.level(), stack.getTag(), null, source.pos().relative(direction), MobSpawnType.DISPENSER, direction != Direction.UP, false);
                stack.shrink(1);
                return stack;
            }
        });
    }

    public EntityType<?> getType(@Nullable CompoundTag nbt) {
        CompoundTag nbtCompound;
        if (nbt != null && nbt.contains("EntityTag", 10) && (nbtCompound = nbt.getCompound("EntityTag")).contains("id", 8)) {
            return EntityType.byString((String)nbtCompound.getString("id")).orElse(this.entityType.get());
        }
        return this.entityType.get();
    }

    public FeatureFlagSet requiredFeatures() {
        return this.getType(null).requiredFeatures();
    }

    protected EntityType<?> getDefaultType() {
        return this.entityType.get();
    }

    public static void onSetup(SetupEvent event) {
        Map<EntityType<? extends Mob>, SpawnEggItem> spawnEggMap = SpawnEggItemAccessor.variantsandventures$getSpawnEggs();
        for (Pair<Supplier<? extends EntityType<? extends Mob>>, SpawnEggItem> entry : SPAWN_EGGS) {
            spawnEggMap.put((EntityType<? extends Mob>)((EntityType)((Supplier)entry.getFirst()).get()), (SpawnEggItem)entry.getSecond());
        }
    }
}

