/*
 * Decompiled with CFR 0.152.
 */
package icyllis.arc3d.compiler.tree;

import icyllis.arc3d.compiler.Context;
import icyllis.arc3d.compiler.tree.Node;
import icyllis.arc3d.compiler.tree.TopLevelElement;
import icyllis.arc3d.compiler.tree.TreeVisitor;
import icyllis.arc3d.compiler.tree.Type;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class StructDefinition
extends TopLevelElement {
    @Nonnull
    private final Type mType;

    public StructDefinition(int position, @Nonnull Type type) {
        super(position);
        this.mType = type;
    }

    @Nullable
    public static StructDefinition convert(@Nonnull Context context, int pos, @Nonnull String structName, @Nonnull List<Type.Field> fields) {
        Type type = Type.makeStructType(context, pos, structName, fields, false);
        return StructDefinition.make(pos, context.getSymbolTable().insert(context, type));
    }

    @Nullable
    public static StructDefinition make(int pos, Type type) {
        if (type == null) {
            return null;
        }
        return new StructDefinition(pos, type);
    }

    @Override
    public Node.ElementKind getKind() {
        return Node.ElementKind.STRUCT_DEFINITION;
    }

    @Override
    public boolean accept(@Nonnull TreeVisitor visitor) {
        return visitor.visitStructDefinition(this);
    }

    @Nonnull
    public Type getType() {
        return this.mType;
    }

    @Override
    @Nonnull
    public String toString() {
        StringBuilder result = new StringBuilder("struct " + this.mType.getName() + " {\n");
        for (Type.Field field : this.mType.getFields()) {
            result.append(field.toString()).append("\n");
        }
        result.append("}");
        return result.toString();
    }
}

