/*
 * Decompiled with CFR 0.152.
 */
package icyllis.arc3d.core.shaders;

import icyllis.arc3d.core.ColorSpace;
import icyllis.arc3d.core.Matrix;
import icyllis.arc3d.core.Matrixc;
import icyllis.arc3d.core.SharedPtr;
import icyllis.arc3d.core.shaders.Color4fShader;
import icyllis.arc3d.core.shaders.Gradient1DShader;
import icyllis.arc3d.core.shaders.LocalMatrixShader;
import icyllis.arc3d.core.shaders.Shader;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

public final class AngularGradient
extends Gradient1DShader {
    private final float mCenterX;
    private final float mCenterY;
    private final float mTBias;
    private final float mTScale;

    @VisibleForTesting
    public AngularGradient(float centerX, float centerY, float tStart, float tEnd, @Nonnull float[] colors, @Nullable ColorSpace colorSpace, @Nullable float[] positions, int colorCount, int tileMode, int interpolation) {
        super(colors, colorSpace, positions, colorCount, tileMode, interpolation, Matrix.makeTranslate(-centerX, -centerY));
        assert (tStart < tEnd);
        this.mCenterX = centerX;
        this.mCenterY = centerY;
        this.mTBias = -tStart;
        this.mTScale = 1.0f / (tEnd - tStart);
    }

    @CheckReturnValue
    @Nullable
    @SharedPtr
    public static Shader make(float centerX, float centerY, float startAngle, float endAngle, @Nonnull float[] colors, @Nullable ColorSpace colorSpace, @Nullable float[] positions, int colorCount, int tileMode, int interpolation, @Nullable Matrixc localMatrix) {
        if (!Float.isFinite(startAngle) || !Float.isFinite(endAngle)) {
            return null;
        }
        if (startAngle > endAngle) {
            return null;
        }
        if (!Float.isFinite(centerX) || !Float.isFinite(centerY)) {
            return null;
        }
        if (!AngularGradient.checkGradient1D(colors, positions, colorCount, tileMode)) {
            return null;
        }
        if (colorCount == 1) {
            return new Color4fShader(colors[0], colors[1], colors[2], colors[3], colorSpace);
        }
        if (localMatrix != null && !localMatrix.invert(null)) {
            return null;
        }
        if (Math.abs(endAngle - startAngle) <= 1.5258789E-5f) {
            if (tileMode == 2 && endAngle > 1.5258789E-5f) {
                float[] newPos = new float[]{0.0f, 1.0f, 1.0f};
                int i = (colorCount - 1) * 4;
                float[] newColor = new float[]{colors[0], colors[1], colors[2], colors[3], colors[0], colors[1], colors[2], colors[3], colors[i], colors[i + 1], colors[i + 2], colors[i + 3]};
                return AngularGradient.make(centerX, centerY, 0.0f, endAngle, newColor, colorSpace, newPos, 3, tileMode, interpolation, localMatrix);
            }
            return AngularGradient.makeDegenerateGradient(colors, colorSpace, positions, colorCount, tileMode);
        }
        if (startAngle <= 0.0f && endAngle >= 360.0f) {
            tileMode = 2;
        }
        float tStart = startAngle / 360.0f;
        float tEnd = endAngle / 360.0f;
        @SharedPtr AngularGradient s = new AngularGradient(centerX, centerY, tStart, tEnd, colors, colorSpace, positions, colorCount, tileMode, interpolation);
        Matrix lm = localMatrix != null ? new Matrix(localMatrix) : new Matrix();
        return new LocalMatrixShader(s, lm);
    }

    @Override
    public int asGradient() {
        return 3;
    }

    public float getCenterX() {
        return this.mCenterX;
    }

    public float getCenterY() {
        return this.mCenterY;
    }

    public float getTBias() {
        return this.mTBias;
    }

    public float getTScale() {
        return this.mTScale;
    }
}

