/*
 * Decompiled with CFR 0.152.
 */
package icyllis.arc3d.engine;

import icyllis.arc3d.core.RefCnt;
import icyllis.arc3d.core.SharedPtr;
import icyllis.arc3d.engine.Context;
import icyllis.arc3d.engine.DataUtils;
import icyllis.arc3d.engine.Image;
import icyllis.arc3d.engine.ImageDesc;
import icyllis.arc3d.engine.ResourceProvider;
import icyllis.arc3d.engine.Swizzle;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class ImageViewProxy
extends RefCnt {
    ImageDesc mDesc;
    @SharedPtr
    Image mImage;
    int mOrigin;
    short mSwizzle;
    String mLabel;
    boolean mBudgeted;
    boolean mVolatile;
    boolean mLazyDimensions;
    LazyInstantiateCallback mLazyInstantiateCallback;

    ImageViewProxy(ImageDesc desc, int origin, short swizzle, boolean budgeted, String label) {
        this.mDesc = Objects.requireNonNull(desc);
        this.mOrigin = origin;
        this.mSwizzle = swizzle;
        this.mLabel = label;
        this.mBudgeted = budgeted;
        this.mVolatile = false;
        this.mLazyDimensions = false;
    }

    ImageViewProxy(ImageDesc desc, int origin, short swizzle, boolean budgeted, boolean isVolatile, boolean lazyDimensions, LazyInstantiateCallback callback) {
        this.mDesc = Objects.requireNonNull(desc);
        this.mOrigin = origin;
        this.mSwizzle = swizzle;
        this.mLabel = "";
        this.mBudgeted = budgeted;
        this.mVolatile = isVolatile;
        this.mLazyDimensions = lazyDimensions;
        this.mLazyInstantiateCallback = Objects.requireNonNull(callback);
    }

    ImageViewProxy(@SharedPtr Image image, int origin, short swizzle) {
        assert (image != null);
        this.mDesc = image.getDesc();
        this.mOrigin = origin;
        this.mSwizzle = swizzle;
        this.mLabel = image.getLabel();
        this.mBudgeted = image.isBudgeted();
        this.mVolatile = false;
        this.mLazyDimensions = false;
        this.mImage = image;
    }

    @Nullable
    @SharedPtr
    public static ImageViewProxy make(@Nonnull Context context, @Nullable ImageDesc desc, int origin, short swizzle, boolean budgeted, @Nullable String label) {
        if (desc == null) {
            return null;
        }
        ImageViewProxy proxy = new ImageViewProxy(desc, origin, swizzle, budgeted, label);
        if (!budgeted && !proxy.instantiate(context.getResourceProvider())) {
            proxy.unref();
            return null;
        }
        return proxy;
    }

    @Nullable
    @SharedPtr
    public static ImageViewProxy make(@Nonnull Context context, int imageType, int colorType, int width, int height, int depthOrArraySize, int imageFlags, int origin, short swizzle) {
        ImageDesc desc = context.getCaps().getDefaultColorImageDesc(imageType, colorType, width, height, depthOrArraySize, imageFlags);
        if (desc == null) {
            return null;
        }
        return ImageViewProxy.make(context, desc, origin, swizzle, true, "");
    }

    @SharedPtr
    public static ImageViewProxy makeLazy(@Nonnull ImageDesc desc, int origin, short swizzle, boolean budgeted, boolean isVolatile, boolean lazyDimensions, @Nonnull LazyInstantiateCallback callback) {
        return new ImageViewProxy(desc, origin, swizzle, budgeted, isVolatile, lazyDimensions, callback);
    }

    @SharedPtr
    public static ImageViewProxy wrap(@SharedPtr Image image, int origin, short swizzle) {
        return new ImageViewProxy(image, origin, swizzle);
    }

    @Override
    protected void deallocate() {
        this.mImage = RefCnt.move(this.mImage);
        if (this.mLazyInstantiateCallback != null) {
            this.mLazyInstantiateCallback.close();
            this.mLazyInstantiateCallback = null;
        }
    }

    public boolean isLazy() {
        return this.mLazyInstantiateCallback != null;
    }

    public boolean isLazyMost() {
        boolean result = this.mLazyDimensions;
        assert (!result || this.isLazy());
        return result;
    }

    public int getWidth() {
        assert (!this.isLazyMost() || this.isInstantiated());
        return this.isInstantiated() ? this.mImage.getWidth() : this.mDesc.getWidth();
    }

    public int getHeight() {
        assert (!this.isLazyMost() || this.isInstantiated());
        return this.isInstantiated() ? this.mImage.getHeight() : this.mDesc.getHeight();
    }

    public int getOrigin() {
        return this.mOrigin;
    }

    public short getSwizzle() {
        return this.mSwizzle;
    }

    public void concatSwizzle(short swizzle) {
        this.mSwizzle = Swizzle.concat(this.mSwizzle, swizzle);
    }

    public void setSwizzle(short swizzle) {
        this.mSwizzle = swizzle;
    }

    public boolean isVolatile() {
        assert (!this.mVolatile || this.mLazyInstantiateCallback != null);
        return this.mVolatile;
    }

    public int getSampleCount() {
        return this.mDesc.getSampleCount();
    }

    @Nonnull
    public ImageDesc getDesc() {
        return this.mDesc;
    }

    public boolean isInstantiated() {
        return this.mImage != null;
    }

    public boolean instantiate(ResourceProvider resourceProvider) {
        if (this.isLazy()) {
            return false;
        }
        if (this.mImage != null) {
            return true;
        }
        @SharedPtr Image image = resourceProvider.findOrCreateImage(this.mDesc, this.mBudgeted, this.mLabel);
        if (image == null) {
            return false;
        }
        assert (this.mImage == null);
        this.mImage = image;
        return true;
    }

    public boolean instantiateIfNonLazy(ResourceProvider resourceProvider) {
        if (this.isLazy()) {
            return true;
        }
        return this.instantiate(resourceProvider);
    }

    public boolean doLazyInstantiation(ResourceProvider resourceProvider) {
        assert (this.isLazy());
        if (this.mImage != null) {
            return true;
        }
        @SharedPtr Image image = null;
        boolean releaseCallback = false;
        LazyCallbackResult result = this.mLazyInstantiateCallback.onLazyInstantiate(resourceProvider, this.mDesc, this.mBudgeted, this.mLabel);
        if (result != null) {
            image = result.mImage;
            releaseCallback = result.mReleaseCallback;
        }
        if (image == null) {
            return false;
        }
        assert (this.mImage == null);
        this.mImage = image;
        if (releaseCallback) {
            this.mLazyInstantiateCallback.close();
            this.mLazyInstantiateCallback = null;
        }
        return true;
    }

    public void clear() {
        assert (this.mVolatile && this.mLazyInstantiateCallback != null);
        assert (this.mImage != null);
        this.mImage.unref();
        this.mImage = null;
    }

    public boolean isBudgeted() {
        return this.mBudgeted;
    }

    public boolean isProtected() {
        return this.mDesc.isProtected();
    }

    public long getMemorySize() {
        return DataUtils.computeSize(this.mDesc);
    }

    public boolean isBackingWrapped() {
        return this.mImage != null && this.mImage.isWrapped();
    }

    public Image getImage() {
        return this.mImage;
    }

    @SharedPtr
    public Image refImage() {
        return RefCnt.create(this.mImage);
    }

    public boolean isMipmapped() {
        if (this.mImage != null) {
            return this.mImage.isMipmapped();
        }
        return this.mDesc.isMipmapped();
    }

    public String getLabel() {
        return this.mLabel;
    }

    public String toString() {
        return "ImageViewProxy{mDesc=" + this.mDesc + ", mImage=" + this.mImage + ", mOrigin=" + this.mOrigin + ", mSwizzle=" + Swizzle.toString(this.mSwizzle) + ", mLabel='" + this.mLabel + "', mBudgeted=" + this.mBudgeted + ", mVolatile=" + this.mVolatile + ", mLazyDimensions=" + this.mLazyDimensions + ", mLazyInstantiateCallback=" + this.mLazyInstantiateCallback + "}";
    }

    @FunctionalInterface
    public static interface LazyInstantiateCallback
    extends AutoCloseable {
        public LazyCallbackResult onLazyInstantiate(ResourceProvider var1, ImageDesc var2, boolean var3, String var4);

        @Override
        default public void close() {
        }
    }

    public static class LazyCallbackResult {
        @SharedPtr
        public Image mImage;
        public boolean mReleaseCallback = true;

        public LazyCallbackResult() {
        }

        public LazyCallbackResult(@SharedPtr Image image) {
            this.mImage = image;
        }

        public LazyCallbackResult(@SharedPtr Image image, boolean releaseCallback) {
            this.mImage = image;
            this.mReleaseCallback = releaseCallback;
        }
    }
}

