/*
 * Decompiled with CFR 0.152.
 */
package icyllis.arc3d.granite;

import icyllis.arc3d.core.Matrixc;
import icyllis.arc3d.core.Rect2fc;
import icyllis.arc3d.core.Rect2ic;
import icyllis.arc3d.granite.DrawOrder;
import icyllis.arc3d.granite.GeometryRenderer;
import icyllis.arc3d.granite.PaintParams;
import javax.annotation.Nullable;

public final class Draw
implements AutoCloseable {
    public GeometryRenderer mRenderer;
    public Matrixc mTransform;
    public Object mGeometry;
    public Rect2fc mDrawBounds;
    public Rect2fc mTransformedShapeBounds;
    public Rect2ic mScissorRect;
    public float mAARadius;
    public long mDrawOrder;
    public float mHalfWidth = -1.0f;
    public float mJoinLimit = -1.0f;
    public byte mStrokeCap;
    public byte mStrokeAlign;
    @Nullable
    public PaintParams mPaintParams;

    @Override
    public void close() {
        if (this.mPaintParams != null) {
            this.mPaintParams.close();
        }
        this.mPaintParams = null;
    }

    public boolean isClippedOut() {
        return this.mDrawBounds.isEmpty();
    }

    public boolean isStroke() {
        return this.mHalfWidth >= 0.0f;
    }

    public boolean isMiterJoin() {
        return this.mJoinLimit > 0.0f;
    }

    public boolean isBevelJoin() {
        return this.mJoinLimit == 0.0f;
    }

    public boolean isRoundJoin() {
        return this.mJoinLimit < 0.0f;
    }

    public float getMiterLimit() {
        return Math.max(0.0f, this.mJoinLimit);
    }

    public float getInflationRadius() {
        if (this.mHalfWidth < 0.0f) {
            return 0.0f;
        }
        if (this.mHalfWidth == 0.0f) {
            return 1.0f;
        }
        float multiplier = 1.0f;
        if (this.mJoinLimit > 0.0f) {
            multiplier = Math.max(multiplier, this.mJoinLimit);
        }
        if (this.mStrokeAlign == 0) {
            if (this.mStrokeCap == 2) {
                multiplier = Math.max(multiplier, 1.4142135f);
            }
        } else {
            multiplier *= 2.0f;
        }
        return this.mHalfWidth * multiplier;
    }

    public int getDepth() {
        return DrawOrder.getDepth(this.mDrawOrder);
    }

    public float getDepthAsFloat() {
        return DrawOrder.getDepthAsFloat(this.mDrawOrder);
    }
}

