/*
 * Decompiled with CFR 0.152.
 */
package icyllis.modernui.core;

import java.nio.Buffer;
import java.nio.IntBuffer;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.Library;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.SharedLibrary;

public class Kernel32 {
    private static final SharedLibrary KERNEL32 = Library.loadNative(Kernel32.class, (String)"org.lwjgl", (String)"kernel32");
    public static final int HANDLE_FLAG_INHERIT = 1;
    public static final int HANDLE_FLAG_PROTECT_FROM_CLOSE = 2;

    public static SharedLibrary getLibrary() {
        return KERNEL32;
    }

    @NativeType(value="BOOL")
    public static boolean CloseHandle(@NativeType(value="HANDLE") long hObject) {
        long __functionAddress = Functions.CloseHandle;
        return JNI.callPI((long)hObject, (long)__functionAddress) != 0;
    }

    @NativeType(value="BOOL")
    public static boolean GetHandleInformation(@NativeType(value="HANDLE") long hObject, @NativeType(value="LPDWORD") IntBuffer lpdwFlags) {
        long __functionAddress = Functions.GetHandleInformation;
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)lpdwFlags, (int)1);
        }
        return JNI.callPPI((long)hObject, (long)MemoryUtil.memAddressSafe((IntBuffer)lpdwFlags), (long)__functionAddress) != 0;
    }

    @NativeType(value="DWORD")
    public static int GetLastError() {
        long __functionAddress = Functions.GetLastError;
        return JNI.callI((long)__functionAddress);
    }

    @NativeType(value="DLL_DIRECTORY_COOKIE")
    public static long AddDllDirectory(@NativeType(value="PCWSTR") String NewDirectory) {
        long __functionAddress = Functions.AddDllDirectory;
        try (MemoryStack stack = MemoryStack.stackPush();){
            stack.nUTF16Safe((CharSequence)NewDirectory, true);
            long l = JNI.callPP((long)(NewDirectory == null ? 0L : stack.getPointerAddress()), (long)__functionAddress);
            return l;
        }
    }

    public static final class Functions {
        public static final long CloseHandle = APIUtil.apiGetFunctionAddress((FunctionProvider)KERNEL32, (String)"CloseHandle");
        public static final long GetHandleInformation = APIUtil.apiGetFunctionAddress((FunctionProvider)KERNEL32, (String)"GetHandleInformation");
        public static final long GetLastError = APIUtil.apiGetFunctionAddress((FunctionProvider)KERNEL32, (String)"GetLastError");
        public static final long AddDllDirectory = APIUtil.apiGetFunctionAddress((FunctionProvider)KERNEL32, (String)"AddDllDirectory");

        private Functions() {
        }
    }
}

