/*
 * Decompiled with CFR 0.152.
 */
package icyllis.modernui.mc;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import icyllis.modernui.ModernUI;
import icyllis.modernui.graphics.text.Emoji;
import icyllis.modernui.graphics.text.EmojiFont;
import icyllis.modernui.graphics.text.FontFamily;
import icyllis.modernui.graphics.text.LayoutCache;
import icyllis.modernui.mc.ModernUIClient;
import icyllis.modernui.mc.ModernUIMod;
import icyllis.modernui.mc.text.GlyphManager;
import icyllis.modernui.mc.text.TextLayoutEngine;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.io.BufferedReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.profiling.ProfilerFiller;
import org.jetbrains.annotations.Unmodifiable;

public class FontResourceManager
implements PreparableReloadListener {
    private static volatile FontResourceManager sInstance;
    public static final int BITMAP_SCALE = 8;
    protected EmojiFont mEmojiFont;
    protected final HashMap<String, String> mEmojiShortcodes = new HashMap();
    protected final HashMap<Character, List<String>> mPrefixedEmojiShortcodes = new HashMap();

    protected FontResourceManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static FontResourceManager getInstance() {
        if (sInstance != null) return sInstance;
        Class<FontResourceManager> clazz = FontResourceManager.class;
        synchronized (FontResourceManager.class) {
            if (sInstance != null) return sInstance;
            if (ModernUIMod.isTextEngineEnabled()) {
                sInstance = new TextLayoutEngine();
            } else {
                sInstance = new FontResourceManager();
                ModernUI.LOGGER.info(ModernUI.MARKER, "Created FontResourceManager");
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return sInstance;
        }
    }

    public void reloadAll() {
        LayoutCache.clear();
    }

    @Nonnull
    public CompletableFuture<Void> reload(@Nonnull PreparableReloadListener.PreparationBarrier preparationBarrier, @Nonnull ResourceManager resourceManager, @Nonnull ProfilerFiller preparationProfiler, @Nonnull ProfilerFiller reloadProfiler, @Nonnull Executor preparationExecutor, @Nonnull Executor reloadExecutor) {
        preparationProfiler.startTick();
        LoadResults results2 = new LoadResults();
        CompletableFuture<Void> loadEmojis = CompletableFuture.runAsync(() -> FontResourceManager.loadEmojis(resourceManager, results2), preparationExecutor);
        CompletableFuture<Void> loadShortcodes = CompletableFuture.runAsync(() -> FontResourceManager.loadShortcodes(resourceManager, results2), preparationExecutor);
        CompletionStage preparation = CompletableFuture.allOf(loadEmojis, loadShortcodes).thenApply(__ -> results2);
        preparationProfiler.endTick();
        return ((CompletableFuture)((CompletableFuture)preparation).thenCompose(arg_0 -> ((PreparableReloadListener.PreparationBarrier)preparationBarrier).wait(arg_0))).thenAcceptAsync(results -> {
            reloadProfiler.startTick();
            reloadProfiler.push("reload");
            this.applyResources((LoadResults)results);
            reloadProfiler.pop();
            reloadProfiler.endTick();
        }, reloadExecutor);
    }

    protected void applyResources(@Nonnull LoadResults results) {
        this.mEmojiFont = results.mEmojiFont;
        this.mEmojiShortcodes.clear();
        this.mEmojiShortcodes.putAll(results.mEmojiShortcodes);
        this.mPrefixedEmojiShortcodes.clear();
        this.mPrefixedEmojiShortcodes.putAll(results.mPrefixedEmojiShortcodes);
        try {
            ModernUIClient.getInstance().reloadTypeface();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        this.reloadAll();
    }

    public void close() {
    }

    protected static void loadEmojis(@Nonnull ResourceManager resources, @Nonnull LoadResults results) {
        Object2IntOpenHashMap map = new Object2IntOpenHashMap();
        ArrayList<String> files = new ArrayList<String>();
        block2: for (ResourceLocation image : resources.listResources("emoji", res -> res.getPath().endsWith(".png")).keySet()) {
            String fileName;
            String[] codes;
            int length;
            String[] path = image.getPath().split("/");
            if (path.length == 0 || (length = (codes = (fileName = path[path.length - 1]).substring(0, fileName.length() - 4).split("_")).length) == 0) continue;
            int[] cps = new int[length << 1];
            int n = 0;
            for (int i = 0; i < length; ++i) {
                try {
                    int c = Integer.parseInt(codes[i], 16);
                    if (!Character.isValidCodePoint(c)) continue block2;
                    boolean ec = Emoji.isEmoji(c);
                    boolean ecc = FontResourceManager.isEmoji_Unicode16_workaround(c);
                    if (i == 0 && !ec && !ecc) continue block2;
                    cps[n++] = c;
                    if (!ec || Emoji.isEmojiPresentation(c)) continue;
                    cps[n++] = 65039;
                    continue;
                }
                catch (NumberFormatException e) {
                    continue block2;
                }
            }
            String sequence = new String(cps, 0, n);
            if (map.containsKey((Object)sequence)) continue;
            map.put((Object)sequence, map.size() + 1);
            files.add(fileName);
        }
        ModernUI.LOGGER.info(GlyphManager.MARKER, "Scanned emoji map size: {}", (Object)map.size());
        if (!files.isEmpty()) {
            IntOpenHashSet coverage = new IntOpenHashSet(1478);
            EmojiData._populateEmojiFontCoverage_((IntSet)coverage);
            results.mEmojiFont = new EmojiFont("Google Noto Color Emoji", (IntSet)coverage, 72, 56, 4, 64, (Object2IntMap<CharSequence>)map, files);
        } else {
            ModernUI.LOGGER.info(GlyphManager.MARKER, "No Emoji font was found");
        }
    }

    static boolean isEmoji_Unicode16_workaround(int codePoint) {
        return codePoint == 129769 || codePoint == 129734 || codePoint == 129726 || codePoint == 129756 || codePoint == 129673 || codePoint == 129679 || codePoint == 129759;
    }

    protected static void loadShortcodes(@Nonnull ResourceManager resources, @Nonnull LoadResults results) {
        HashMap<String, String> map = new HashMap<String, String>();
        HashMap<Character, HashSet> prefixedMap = new HashMap<Character, HashSet>();
        try (BufferedReader reader = resources.openAsReader(ModernUIMod.location("emoji_data.json"));){
            for (JsonElement entry : (JsonArray)new Gson().fromJson((Reader)reader, JsonArray.class)) {
                JsonArray row = entry.getAsJsonArray();
                String sequence = row.get(0).getAsString();
                JsonArray shortcodes = row.get(2).getAsJsonArray();
                for (int i = 0; i < shortcodes.size(); ++i) {
                    String sc = shortcodes.get(i).getAsString();
                    String key = ":" + sc + ":";
                    char prefix = Character.toLowerCase(sc.charAt(0));
                    prefixedMap.computeIfAbsent(Character.valueOf(prefix), $ -> new HashSet()).add(key);
                    if (i == 0) {
                        map.put(key, sequence);
                        continue;
                    }
                    map.putIfAbsent(key, sequence);
                }
            }
        }
        catch (Exception e) {
            ModernUI.LOGGER.info(GlyphManager.MARKER, "Failed to load emoji data", (Throwable)e);
        }
        ModernUI.LOGGER.info(GlyphManager.MARKER, "Scanned emoji shortcodes: {}", (Object)map.size());
        results.mEmojiShortcodes = map;
        HashMap<Character, List<String>> finalPrefixedMap = new HashMap<Character, List<String>>();
        for (Map.Entry e : prefixedMap.entrySet()) {
            ArrayList list = new ArrayList((Collection)e.getValue());
            list.sort(null);
            finalPrefixedMap.put((Character)e.getKey(), Collections.unmodifiableList(list));
        }
        results.mPrefixedEmojiShortcodes = finalPrefixedMap;
    }

    public void onFontRegistered(@Nonnull FontFamily f) {
    }

    @Nullable
    public EmojiFont getEmojiFont() {
        return this.mEmojiFont;
    }

    @Nullable
    public String lookupEmojiShortcode(@Nonnull String shortcode) {
        return this.mEmojiShortcodes.get(shortcode);
    }

    @Nonnull
    public @Unmodifiable List<String> getEmojiShortcodes(char prefix) {
        return this.mPrefixedEmojiShortcodes.getOrDefault(Character.valueOf(Character.toLowerCase(prefix)), Collections.emptyList());
    }

    public static class LoadResults {
        public volatile EmojiFont mEmojiFont;
        public volatile Map<String, String> mEmojiShortcodes;
        public volatile Map<Character, List<String>> mPrefixedEmojiShortcodes;
    }

    static class EmojiData {
        EmojiData() {
        }

        static void _populateEmojiFontCoverage_(IntSet c) {
            c.add(9);
            c.add(10);
            c.add(13);
            c.add(32);
            c.add(35);
            c.add(42);
            c.add(48);
            c.add(49);
            c.add(50);
            c.add(51);
            c.add(52);
            c.add(53);
            c.add(54);
            c.add(55);
            c.add(56);
            c.add(57);
            c.add(169);
            c.add(174);
            c.add(8204);
            c.add(8205);
            c.add(8206);
            c.add(8207);
            c.add(8232);
            c.add(8233);
            c.add(8234);
            c.add(8235);
            c.add(8236);
            c.add(8237);
            c.add(8238);
            c.add(8252);
            c.add(8265);
            c.add(8298);
            c.add(8299);
            c.add(8300);
            c.add(8301);
            c.add(8302);
            c.add(8303);
            c.add(8419);
            c.add(8482);
            c.add(8505);
            c.add(8596);
            c.add(8597);
            c.add(8598);
            c.add(8599);
            c.add(8600);
            c.add(8601);
            c.add(8617);
            c.add(8618);
            c.add(8986);
            c.add(8987);
            c.add(9000);
            c.add(9167);
            c.add(9193);
            c.add(9194);
            c.add(9195);
            c.add(9196);
            c.add(9197);
            c.add(9198);
            c.add(9199);
            c.add(9200);
            c.add(9201);
            c.add(9202);
            c.add(9203);
            c.add(9208);
            c.add(9209);
            c.add(9210);
            c.add(9410);
            c.add(9642);
            c.add(9643);
            c.add(9654);
            c.add(9664);
            c.add(9723);
            c.add(9724);
            c.add(9725);
            c.add(9726);
            c.add(9728);
            c.add(9729);
            c.add(9730);
            c.add(9731);
            c.add(9732);
            c.add(9742);
            c.add(9745);
            c.add(9748);
            c.add(9749);
            c.add(9752);
            c.add(9757);
            c.add(9760);
            c.add(9762);
            c.add(9763);
            c.add(9766);
            c.add(9770);
            c.add(9774);
            c.add(9775);
            c.add(9784);
            c.add(9785);
            c.add(9786);
            c.add(9792);
            c.add(9794);
            c.add(9800);
            c.add(9801);
            c.add(9802);
            c.add(9803);
            c.add(9804);
            c.add(9805);
            c.add(9806);
            c.add(9807);
            c.add(9808);
            c.add(9809);
            c.add(9810);
            c.add(9811);
            c.add(9823);
            c.add(9824);
            c.add(9827);
            c.add(9829);
            c.add(9830);
            c.add(9832);
            c.add(9851);
            c.add(9854);
            c.add(9855);
            c.add(9874);
            c.add(9875);
            c.add(9876);
            c.add(9877);
            c.add(9878);
            c.add(9879);
            c.add(9881);
            c.add(9883);
            c.add(9884);
            c.add(9888);
            c.add(9889);
            c.add(9895);
            c.add(9898);
            c.add(9899);
            c.add(9904);
            c.add(9905);
            c.add(9917);
            c.add(9918);
            c.add(9924);
            c.add(9925);
            c.add(9928);
            c.add(9934);
            c.add(9935);
            c.add(9937);
            c.add(9939);
            c.add(9940);
            c.add(9961);
            c.add(9962);
            c.add(9968);
            c.add(9969);
            c.add(9970);
            c.add(9971);
            c.add(9972);
            c.add(9973);
            c.add(9975);
            c.add(9976);
            c.add(9977);
            c.add(9978);
            c.add(9981);
            c.add(9986);
            c.add(9989);
            c.add(9992);
            c.add(9993);
            c.add(9994);
            c.add(9995);
            c.add(9996);
            c.add(9997);
            c.add(9999);
            c.add(10002);
            c.add(10004);
            c.add(10006);
            c.add(10013);
            c.add(10017);
            c.add(10024);
            c.add(10035);
            c.add(10036);
            c.add(10052);
            c.add(10055);
            c.add(10060);
            c.add(10062);
            c.add(10067);
            c.add(10068);
            c.add(10069);
            c.add(10071);
            c.add(10083);
            c.add(10084);
            c.add(10133);
            c.add(10134);
            c.add(10135);
            c.add(10145);
            c.add(10160);
            c.add(10175);
            c.add(10548);
            c.add(10549);
            c.add(11013);
            c.add(11014);
            c.add(11015);
            c.add(11035);
            c.add(11036);
            c.add(11088);
            c.add(11093);
            c.add(12336);
            c.add(12349);
            c.add(12951);
            c.add(12953);
            c.add(126980);
            c.add(127183);
            c.add(127344);
            c.add(127345);
            c.add(127358);
            c.add(127359);
            c.add(127374);
            c.add(127377);
            c.add(127378);
            c.add(127379);
            c.add(127380);
            c.add(127381);
            c.add(127382);
            c.add(127383);
            c.add(127384);
            c.add(127385);
            c.add(127386);
            c.add(127489);
            c.add(127490);
            c.add(127514);
            c.add(127535);
            c.add(127538);
            c.add(127539);
            c.add(127540);
            c.add(127541);
            c.add(127542);
            c.add(127543);
            c.add(127544);
            c.add(127545);
            c.add(127546);
            c.add(127568);
            c.add(127569);
            c.add(127744);
            c.add(127745);
            c.add(127746);
            c.add(127747);
            c.add(127748);
            c.add(127749);
            c.add(127750);
            c.add(127751);
            c.add(127752);
            c.add(127753);
            c.add(127754);
            c.add(127755);
            c.add(127756);
            c.add(127757);
            c.add(127758);
            c.add(127759);
            c.add(127760);
            c.add(127761);
            c.add(127762);
            c.add(127763);
            c.add(127764);
            c.add(127765);
            c.add(127766);
            c.add(127767);
            c.add(127768);
            c.add(127769);
            c.add(127770);
            c.add(127771);
            c.add(127772);
            c.add(127773);
            c.add(127774);
            c.add(127775);
            c.add(127776);
            c.add(127777);
            c.add(127780);
            c.add(127781);
            c.add(127782);
            c.add(127783);
            c.add(127784);
            c.add(127785);
            c.add(127786);
            c.add(127787);
            c.add(127788);
            c.add(127789);
            c.add(127790);
            c.add(127791);
            c.add(127792);
            c.add(127793);
            c.add(127794);
            c.add(127795);
            c.add(127796);
            c.add(127797);
            c.add(127798);
            c.add(127799);
            c.add(127800);
            c.add(127801);
            c.add(127802);
            c.add(127803);
            c.add(127804);
            c.add(127805);
            c.add(127806);
            c.add(127807);
            c.add(127808);
            c.add(127809);
            c.add(127810);
            c.add(127811);
            c.add(127812);
            c.add(127813);
            c.add(127814);
            c.add(127815);
            c.add(127816);
            c.add(127817);
            c.add(127818);
            c.add(127819);
            c.add(127820);
            c.add(127821);
            c.add(127822);
            c.add(127823);
            c.add(127824);
            c.add(127825);
            c.add(127826);
            c.add(127827);
            c.add(127828);
            c.add(127829);
            c.add(127830);
            c.add(127831);
            c.add(127832);
            c.add(127833);
            c.add(127834);
            c.add(127835);
            c.add(127836);
            c.add(127837);
            c.add(127838);
            c.add(127839);
            c.add(127840);
            c.add(127841);
            c.add(127842);
            c.add(127843);
            c.add(127844);
            c.add(127845);
            c.add(127846);
            c.add(127847);
            c.add(127848);
            c.add(127849);
            c.add(127850);
            c.add(127851);
            c.add(127852);
            c.add(127853);
            c.add(127854);
            c.add(127855);
            c.add(127856);
            c.add(127857);
            c.add(127858);
            c.add(127859);
            c.add(127860);
            c.add(127861);
            c.add(127862);
            c.add(127863);
            c.add(127864);
            c.add(127865);
            c.add(127866);
            c.add(127867);
            c.add(127868);
            c.add(127869);
            c.add(127870);
            c.add(127871);
            c.add(127872);
            c.add(127873);
            c.add(127874);
            c.add(127875);
            c.add(127876);
            c.add(127877);
            c.add(127878);
            c.add(127879);
            c.add(127880);
            c.add(127881);
            c.add(127882);
            c.add(127883);
            c.add(127884);
            c.add(127885);
            c.add(127886);
            c.add(127887);
            c.add(127888);
            c.add(127889);
            c.add(127890);
            c.add(127891);
            c.add(127894);
            c.add(127895);
            c.add(127897);
            c.add(127898);
            c.add(127899);
            c.add(127902);
            c.add(127903);
            c.add(127904);
            c.add(127905);
            c.add(127906);
            c.add(127907);
            c.add(127908);
            c.add(127909);
            c.add(127910);
            c.add(127911);
            c.add(127912);
            c.add(127913);
            c.add(127914);
            c.add(127915);
            c.add(127916);
            c.add(127917);
            c.add(127918);
            c.add(127919);
            c.add(127920);
            c.add(127921);
            c.add(127922);
            c.add(127923);
            c.add(127924);
            c.add(127925);
            c.add(127926);
            c.add(127927);
            c.add(127928);
            c.add(127929);
            c.add(127930);
            c.add(127931);
            c.add(127932);
            c.add(127933);
            c.add(127934);
            c.add(127935);
            c.add(127936);
            c.add(127937);
            c.add(127938);
            c.add(127939);
            c.add(127940);
            c.add(127941);
            c.add(127942);
            c.add(127943);
            c.add(127944);
            c.add(127945);
            c.add(127946);
            c.add(127947);
            c.add(127948);
            c.add(127949);
            c.add(127950);
            c.add(127951);
            c.add(127952);
            c.add(127953);
            c.add(127954);
            c.add(127955);
            c.add(127956);
            c.add(127957);
            c.add(127958);
            c.add(127959);
            c.add(127960);
            c.add(127961);
            c.add(127962);
            c.add(127963);
            c.add(127964);
            c.add(127965);
            c.add(127966);
            c.add(127967);
            c.add(127968);
            c.add(127969);
            c.add(127970);
            c.add(127971);
            c.add(127972);
            c.add(127973);
            c.add(127974);
            c.add(127975);
            c.add(127976);
            c.add(127977);
            c.add(127978);
            c.add(127979);
            c.add(127980);
            c.add(127981);
            c.add(127982);
            c.add(127983);
            c.add(127984);
            c.add(127987);
            c.add(127988);
            c.add(127989);
            c.add(127991);
            c.add(127992);
            c.add(127993);
            c.add(127994);
            c.add(127995);
            c.add(127996);
            c.add(127997);
            c.add(127998);
            c.add(127999);
            c.add(128000);
            c.add(128001);
            c.add(128002);
            c.add(128003);
            c.add(128004);
            c.add(128005);
            c.add(128006);
            c.add(128007);
            c.add(128008);
            c.add(128009);
            c.add(128010);
            c.add(128011);
            c.add(128012);
            c.add(128013);
            c.add(128014);
            c.add(128015);
            c.add(128016);
            c.add(128017);
            c.add(128018);
            c.add(128019);
            c.add(128020);
            c.add(128021);
            c.add(128022);
            c.add(128023);
            c.add(128024);
            c.add(128025);
            c.add(128026);
            c.add(128027);
            c.add(128028);
            c.add(128029);
            c.add(128030);
            c.add(128031);
            c.add(128032);
            c.add(128033);
            c.add(128034);
            c.add(128035);
            c.add(128036);
            c.add(128037);
            c.add(128038);
            c.add(128039);
            c.add(128040);
            c.add(128041);
            c.add(128042);
            c.add(128043);
            c.add(128044);
            c.add(128045);
            c.add(128046);
            c.add(128047);
            c.add(128048);
            c.add(128049);
            c.add(128050);
            c.add(128051);
            c.add(128052);
            c.add(128053);
            c.add(128054);
            c.add(128055);
            c.add(128056);
            c.add(128057);
            c.add(128058);
            c.add(128059);
            c.add(128060);
            c.add(128061);
            c.add(128062);
            c.add(128063);
            c.add(128064);
            c.add(128065);
            c.add(128066);
            c.add(128067);
            c.add(128068);
            c.add(128069);
            c.add(128070);
            c.add(128071);
            c.add(128072);
            c.add(128073);
            c.add(128074);
            c.add(128075);
            c.add(128076);
            c.add(128077);
            c.add(128078);
            c.add(128079);
            c.add(128080);
            c.add(128081);
            c.add(128082);
            c.add(128083);
            c.add(128084);
            c.add(128085);
            c.add(128086);
            c.add(128087);
            c.add(128088);
            c.add(128089);
            c.add(128090);
            c.add(128091);
            c.add(128092);
            c.add(128093);
            c.add(128094);
            c.add(128095);
            c.add(128096);
            c.add(128097);
            c.add(128098);
            c.add(128099);
            c.add(128100);
            c.add(128101);
            c.add(128102);
            c.add(128103);
            c.add(128104);
            c.add(128105);
            c.add(128106);
            c.add(128107);
            c.add(128108);
            c.add(128109);
            c.add(128110);
            c.add(128111);
            c.add(128112);
            c.add(128113);
            c.add(128114);
            c.add(128115);
            c.add(128116);
            c.add(128117);
            c.add(128118);
            c.add(128119);
            c.add(128120);
            c.add(128121);
            c.add(128122);
            c.add(128123);
            c.add(128124);
            c.add(128125);
            c.add(128126);
            c.add(128127);
            c.add(128128);
            c.add(128129);
            c.add(128130);
            c.add(128131);
            c.add(128132);
            c.add(128133);
            c.add(128134);
            c.add(128135);
            c.add(128136);
            c.add(128137);
            c.add(128138);
            c.add(128139);
            c.add(128140);
            c.add(128141);
            c.add(128142);
            c.add(128143);
            c.add(128144);
            c.add(128145);
            c.add(128146);
            c.add(128147);
            c.add(128148);
            c.add(128149);
            c.add(128150);
            c.add(128151);
            c.add(128152);
            c.add(128153);
            c.add(128154);
            c.add(128155);
            c.add(128156);
            c.add(128157);
            c.add(128158);
            c.add(128159);
            c.add(128160);
            c.add(128161);
            c.add(128162);
            c.add(128163);
            c.add(128164);
            c.add(128165);
            c.add(128166);
            c.add(128167);
            c.add(128168);
            c.add(128169);
            c.add(128170);
            c.add(128171);
            c.add(128172);
            c.add(128173);
            c.add(128174);
            c.add(128175);
            c.add(128176);
            c.add(128177);
            c.add(128178);
            c.add(128179);
            c.add(128180);
            c.add(128181);
            c.add(128182);
            c.add(128183);
            c.add(128184);
            c.add(128185);
            c.add(128186);
            c.add(128187);
            c.add(128188);
            c.add(128189);
            c.add(128190);
            c.add(128191);
            c.add(128192);
            c.add(128193);
            c.add(128194);
            c.add(128195);
            c.add(128196);
            c.add(128197);
            c.add(128198);
            c.add(128199);
            c.add(128200);
            c.add(128201);
            c.add(128202);
            c.add(128203);
            c.add(128204);
            c.add(128205);
            c.add(128206);
            c.add(128207);
            c.add(128208);
            c.add(128209);
            c.add(128210);
            c.add(128211);
            c.add(128212);
            c.add(128213);
            c.add(128214);
            c.add(128215);
            c.add(128216);
            c.add(128217);
            c.add(128218);
            c.add(128219);
            c.add(128220);
            c.add(128221);
            c.add(128222);
            c.add(128223);
            c.add(128224);
            c.add(128225);
            c.add(128226);
            c.add(128227);
            c.add(128228);
            c.add(128229);
            c.add(128230);
            c.add(128231);
            c.add(128232);
            c.add(128233);
            c.add(128234);
            c.add(128235);
            c.add(128236);
            c.add(128237);
            c.add(128238);
            c.add(128239);
            c.add(128240);
            c.add(128241);
            c.add(128242);
            c.add(128243);
            c.add(128244);
            c.add(128245);
            c.add(128246);
            c.add(128247);
            c.add(128248);
            c.add(128249);
            c.add(128250);
            c.add(128251);
            c.add(128252);
            c.add(128253);
            c.add(128255);
            c.add(128256);
            c.add(128257);
            c.add(128258);
            c.add(128259);
            c.add(128260);
            c.add(128261);
            c.add(128262);
            c.add(128263);
            c.add(128264);
            c.add(128265);
            c.add(128266);
            c.add(128267);
            c.add(128268);
            c.add(128269);
            c.add(128270);
            c.add(128271);
            c.add(128272);
            c.add(128273);
            c.add(128274);
            c.add(128275);
            c.add(128276);
            c.add(128277);
            c.add(128278);
            c.add(128279);
            c.add(128280);
            c.add(128281);
            c.add(128282);
            c.add(128283);
            c.add(128284);
            c.add(128285);
            c.add(128286);
            c.add(128287);
            c.add(128288);
            c.add(128289);
            c.add(128290);
            c.add(128291);
            c.add(128292);
            c.add(128293);
            c.add(128294);
            c.add(128295);
            c.add(128296);
            c.add(128297);
            c.add(128298);
            c.add(128299);
            c.add(128300);
            c.add(128301);
            c.add(128302);
            c.add(128303);
            c.add(128304);
            c.add(128305);
            c.add(128306);
            c.add(128307);
            c.add(128308);
            c.add(128309);
            c.add(128310);
            c.add(128311);
            c.add(128312);
            c.add(128313);
            c.add(128314);
            c.add(128315);
            c.add(128316);
            c.add(128317);
            c.add(128329);
            c.add(128330);
            c.add(128331);
            c.add(128332);
            c.add(128333);
            c.add(128334);
            c.add(128336);
            c.add(128337);
            c.add(128338);
            c.add(128339);
            c.add(128340);
            c.add(128341);
            c.add(128342);
            c.add(128343);
            c.add(128344);
            c.add(128345);
            c.add(128346);
            c.add(128347);
            c.add(128348);
            c.add(128349);
            c.add(128350);
            c.add(128351);
            c.add(128352);
            c.add(128353);
            c.add(128354);
            c.add(128355);
            c.add(128356);
            c.add(128357);
            c.add(128358);
            c.add(128359);
            c.add(128367);
            c.add(128368);
            c.add(128371);
            c.add(128372);
            c.add(128373);
            c.add(128374);
            c.add(128375);
            c.add(128376);
            c.add(128377);
            c.add(128378);
            c.add(128391);
            c.add(128394);
            c.add(128395);
            c.add(128396);
            c.add(128397);
            c.add(128400);
            c.add(128405);
            c.add(128406);
            c.add(128420);
            c.add(128421);
            c.add(128424);
            c.add(128433);
            c.add(128434);
            c.add(128444);
            c.add(128450);
            c.add(128451);
            c.add(128452);
            c.add(128465);
            c.add(128466);
            c.add(128467);
            c.add(128476);
            c.add(128477);
            c.add(128478);
            c.add(128481);
            c.add(128483);
            c.add(128488);
            c.add(128495);
            c.add(128499);
            c.add(128506);
            c.add(128507);
            c.add(128508);
            c.add(128509);
            c.add(128510);
            c.add(128511);
            c.add(128512);
            c.add(128513);
            c.add(128514);
            c.add(128515);
            c.add(128516);
            c.add(128517);
            c.add(128518);
            c.add(128519);
            c.add(128520);
            c.add(128521);
            c.add(128522);
            c.add(128523);
            c.add(128524);
            c.add(128525);
            c.add(128526);
            c.add(128527);
            c.add(128528);
            c.add(128529);
            c.add(128530);
            c.add(128531);
            c.add(128532);
            c.add(128533);
            c.add(128534);
            c.add(128535);
            c.add(128536);
            c.add(128537);
            c.add(128538);
            c.add(128539);
            c.add(128540);
            c.add(128541);
            c.add(128542);
            c.add(128543);
            c.add(128544);
            c.add(128545);
            c.add(128546);
            c.add(128547);
            c.add(128548);
            c.add(128549);
            c.add(128550);
            c.add(128551);
            c.add(128552);
            c.add(128553);
            c.add(128554);
            c.add(128555);
            c.add(128556);
            c.add(128557);
            c.add(128558);
            c.add(128559);
            c.add(128560);
            c.add(128561);
            c.add(128562);
            c.add(128563);
            c.add(128564);
            c.add(128565);
            c.add(128566);
            c.add(128567);
            c.add(128568);
            c.add(128569);
            c.add(128570);
            c.add(128571);
            c.add(128572);
            c.add(128573);
            c.add(128574);
            c.add(128575);
            c.add(128576);
            c.add(128577);
            c.add(128578);
            c.add(128579);
            c.add(128580);
            c.add(128581);
            c.add(128582);
            c.add(128583);
            c.add(128584);
            c.add(128585);
            c.add(128586);
            c.add(128587);
            c.add(128588);
            c.add(128589);
            c.add(128590);
            c.add(128591);
            c.add(128640);
            c.add(128641);
            c.add(128642);
            c.add(128643);
            c.add(128644);
            c.add(128645);
            c.add(128646);
            c.add(128647);
            c.add(128648);
            c.add(128649);
            c.add(128650);
            c.add(128651);
            c.add(128652);
            c.add(128653);
            c.add(128654);
            c.add(128655);
            c.add(128656);
            c.add(128657);
            c.add(128658);
            c.add(128659);
            c.add(128660);
            c.add(128661);
            c.add(128662);
            c.add(128663);
            c.add(128664);
            c.add(128665);
            c.add(128666);
            c.add(128667);
            c.add(128668);
            c.add(128669);
            c.add(128670);
            c.add(128671);
            c.add(128672);
            c.add(128673);
            c.add(128674);
            c.add(128675);
            c.add(128676);
            c.add(128677);
            c.add(128678);
            c.add(128679);
            c.add(128680);
            c.add(128681);
            c.add(128682);
            c.add(128683);
            c.add(128684);
            c.add(128685);
            c.add(128686);
            c.add(128687);
            c.add(128688);
            c.add(128689);
            c.add(128690);
            c.add(128691);
            c.add(128692);
            c.add(128693);
            c.add(128694);
            c.add(128695);
            c.add(128696);
            c.add(128697);
            c.add(128698);
            c.add(128699);
            c.add(128700);
            c.add(128701);
            c.add(128702);
            c.add(128703);
            c.add(128704);
            c.add(128705);
            c.add(128706);
            c.add(128707);
            c.add(128708);
            c.add(128709);
            c.add(128715);
            c.add(128716);
            c.add(128717);
            c.add(128718);
            c.add(128719);
            c.add(128720);
            c.add(128721);
            c.add(128722);
            c.add(128725);
            c.add(128726);
            c.add(128727);
            c.add(128732);
            c.add(128733);
            c.add(128734);
            c.add(128735);
            c.add(128736);
            c.add(128737);
            c.add(128738);
            c.add(128739);
            c.add(128740);
            c.add(128741);
            c.add(128745);
            c.add(128747);
            c.add(128748);
            c.add(128752);
            c.add(128755);
            c.add(128756);
            c.add(128757);
            c.add(128758);
            c.add(128759);
            c.add(128760);
            c.add(128761);
            c.add(128762);
            c.add(128763);
            c.add(128764);
            c.add(128992);
            c.add(128993);
            c.add(128994);
            c.add(128995);
            c.add(128996);
            c.add(128997);
            c.add(128998);
            c.add(128999);
            c.add(129000);
            c.add(129001);
            c.add(129002);
            c.add(129003);
            c.add(129008);
            c.add(129292);
            c.add(129293);
            c.add(129294);
            c.add(129295);
            c.add(129296);
            c.add(129297);
            c.add(129298);
            c.add(129299);
            c.add(129300);
            c.add(129301);
            c.add(129302);
            c.add(129303);
            c.add(129304);
            c.add(129305);
            c.add(129306);
            c.add(129307);
            c.add(129308);
            c.add(129309);
            c.add(129310);
            c.add(129311);
            c.add(129312);
            c.add(129313);
            c.add(129314);
            c.add(129315);
            c.add(129316);
            c.add(129317);
            c.add(129318);
            c.add(129319);
            c.add(129320);
            c.add(129321);
            c.add(129322);
            c.add(129323);
            c.add(129324);
            c.add(129325);
            c.add(129326);
            c.add(129327);
            c.add(129328);
            c.add(129329);
            c.add(129330);
            c.add(129331);
            c.add(129332);
            c.add(129333);
            c.add(129334);
            c.add(129335);
            c.add(129336);
            c.add(129337);
            c.add(129338);
            c.add(129340);
            c.add(129341);
            c.add(129342);
            c.add(129343);
            c.add(129344);
            c.add(129345);
            c.add(129346);
            c.add(129347);
            c.add(129348);
            c.add(129349);
            c.add(129351);
            c.add(129352);
            c.add(129353);
            c.add(129354);
            c.add(129355);
            c.add(129356);
            c.add(129357);
            c.add(129358);
            c.add(129359);
            c.add(129360);
            c.add(129361);
            c.add(129362);
            c.add(129363);
            c.add(129364);
            c.add(129365);
            c.add(129366);
            c.add(129367);
            c.add(129368);
            c.add(129369);
            c.add(129370);
            c.add(129371);
            c.add(129372);
            c.add(129373);
            c.add(129374);
            c.add(129375);
            c.add(129376);
            c.add(129377);
            c.add(129378);
            c.add(129379);
            c.add(129380);
            c.add(129381);
            c.add(129382);
            c.add(129383);
            c.add(129384);
            c.add(129385);
            c.add(129386);
            c.add(129387);
            c.add(129388);
            c.add(129389);
            c.add(129390);
            c.add(129391);
            c.add(129392);
            c.add(129393);
            c.add(129394);
            c.add(129395);
            c.add(129396);
            c.add(129397);
            c.add(129398);
            c.add(129399);
            c.add(129400);
            c.add(129401);
            c.add(129402);
            c.add(129403);
            c.add(129404);
            c.add(129405);
            c.add(129406);
            c.add(129407);
            c.add(129408);
            c.add(129409);
            c.add(129410);
            c.add(129411);
            c.add(129412);
            c.add(129413);
            c.add(129414);
            c.add(129415);
            c.add(129416);
            c.add(129417);
            c.add(129418);
            c.add(129419);
            c.add(129420);
            c.add(129421);
            c.add(129422);
            c.add(129423);
            c.add(129424);
            c.add(129425);
            c.add(129426);
            c.add(129427);
            c.add(129428);
            c.add(129429);
            c.add(129430);
            c.add(129431);
            c.add(129432);
            c.add(129433);
            c.add(129434);
            c.add(129435);
            c.add(129436);
            c.add(129437);
            c.add(129438);
            c.add(129439);
            c.add(129440);
            c.add(129441);
            c.add(129442);
            c.add(129443);
            c.add(129444);
            c.add(129445);
            c.add(129446);
            c.add(129447);
            c.add(129448);
            c.add(129449);
            c.add(129450);
            c.add(129451);
            c.add(129452);
            c.add(129453);
            c.add(129454);
            c.add(129455);
            c.add(129456);
            c.add(129457);
            c.add(129458);
            c.add(129459);
            c.add(129460);
            c.add(129461);
            c.add(129462);
            c.add(129463);
            c.add(129464);
            c.add(129465);
            c.add(129466);
            c.add(129467);
            c.add(129468);
            c.add(129469);
            c.add(129470);
            c.add(129471);
            c.add(129472);
            c.add(129473);
            c.add(129474);
            c.add(129475);
            c.add(129476);
            c.add(129477);
            c.add(129478);
            c.add(129479);
            c.add(129480);
            c.add(129481);
            c.add(129482);
            c.add(129483);
            c.add(129484);
            c.add(129485);
            c.add(129486);
            c.add(129487);
            c.add(129488);
            c.add(129489);
            c.add(129490);
            c.add(129491);
            c.add(129492);
            c.add(129493);
            c.add(129494);
            c.add(129495);
            c.add(129496);
            c.add(129497);
            c.add(129498);
            c.add(129499);
            c.add(129500);
            c.add(129501);
            c.add(129502);
            c.add(129503);
            c.add(129504);
            c.add(129505);
            c.add(129506);
            c.add(129507);
            c.add(129508);
            c.add(129509);
            c.add(129510);
            c.add(129511);
            c.add(129512);
            c.add(129513);
            c.add(129514);
            c.add(129515);
            c.add(129516);
            c.add(129517);
            c.add(129518);
            c.add(129519);
            c.add(129520);
            c.add(129521);
            c.add(129522);
            c.add(129523);
            c.add(129524);
            c.add(129525);
            c.add(129526);
            c.add(129527);
            c.add(129528);
            c.add(129529);
            c.add(129530);
            c.add(129531);
            c.add(129532);
            c.add(129533);
            c.add(129534);
            c.add(129535);
            c.add(129648);
            c.add(129649);
            c.add(129650);
            c.add(129651);
            c.add(129652);
            c.add(129653);
            c.add(129654);
            c.add(129655);
            c.add(129656);
            c.add(129657);
            c.add(129658);
            c.add(129659);
            c.add(129660);
            c.add(129664);
            c.add(129665);
            c.add(129666);
            c.add(129667);
            c.add(129668);
            c.add(129669);
            c.add(129670);
            c.add(129671);
            c.add(129672);
            c.add(129680);
            c.add(129681);
            c.add(129682);
            c.add(129683);
            c.add(129684);
            c.add(129685);
            c.add(129686);
            c.add(129687);
            c.add(129688);
            c.add(129689);
            c.add(129690);
            c.add(129691);
            c.add(129692);
            c.add(129693);
            c.add(129694);
            c.add(129695);
            c.add(129696);
            c.add(129697);
            c.add(129698);
            c.add(129699);
            c.add(129700);
            c.add(129701);
            c.add(129702);
            c.add(129703);
            c.add(129704);
            c.add(129705);
            c.add(129706);
            c.add(129707);
            c.add(129708);
            c.add(129709);
            c.add(129710);
            c.add(129711);
            c.add(129712);
            c.add(129713);
            c.add(129714);
            c.add(129715);
            c.add(129716);
            c.add(129717);
            c.add(129718);
            c.add(129719);
            c.add(129720);
            c.add(129721);
            c.add(129722);
            c.add(129723);
            c.add(129724);
            c.add(129725);
            c.add(129727);
            c.add(129728);
            c.add(129729);
            c.add(129730);
            c.add(129731);
            c.add(129732);
            c.add(129733);
            c.add(129742);
            c.add(129743);
            c.add(129744);
            c.add(129745);
            c.add(129746);
            c.add(129747);
            c.add(129748);
            c.add(129749);
            c.add(129750);
            c.add(129751);
            c.add(129752);
            c.add(129753);
            c.add(129754);
            c.add(129755);
            c.add(129760);
            c.add(129761);
            c.add(129762);
            c.add(129763);
            c.add(129764);
            c.add(129765);
            c.add(129766);
            c.add(129767);
            c.add(129768);
            c.add(129776);
            c.add(129777);
            c.add(129778);
            c.add(129779);
            c.add(129780);
            c.add(129781);
            c.add(129782);
            c.add(129783);
            c.add(129784);
            c.add(917552);
            c.add(917553);
            c.add(917554);
            c.add(917555);
            c.add(917556);
            c.add(917557);
            c.add(917558);
            c.add(917559);
            c.add(917560);
            c.add(917561);
            c.add(917601);
            c.add(917602);
            c.add(917603);
            c.add(917604);
            c.add(917605);
            c.add(917606);
            c.add(917607);
            c.add(917608);
            c.add(917609);
            c.add(917610);
            c.add(917611);
            c.add(917612);
            c.add(917613);
            c.add(917614);
            c.add(917615);
            c.add(917616);
            c.add(917617);
            c.add(917618);
            c.add(917619);
            c.add(917620);
            c.add(917621);
            c.add(917622);
            c.add(917623);
            c.add(917624);
            c.add(917625);
            c.add(917626);
            c.add(917631);
            c.add(1041637);
            c.add(1041638);
            c.add(1041639);
            c.add(1041640);
            c.add(1041641);
            c.add(1041642);
            c.add(1041643);
            c.add(1041644);
            c.add(1041645);
            c.add(1041646);
            c.add(1042476);
            c.add(1042478);
            c.add(1042479);
            c.add(1042480);
            c.add(1042481);
            c.add(1042482);
            c.add(1042483);
            c.add(1042484);
            c.add(1042485);
            c.add(1042486);
            c.add(1042487);
        }
    }
}

