/*
 * Decompiled with CFR 0.152.
 */
package icyllis.modernui.mc;

import icyllis.modernui.mc.ModernUIClient;
import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

public abstract class ModernUIMod {
    public static final Logger LOGGER = LogManager.getLogger((String)"ModernUI-MC");
    public static final Marker MARKER = MarkerManager.getMarker((String)"Init");
    public static final String BOOTSTRAP_DISABLE_TEXT_ENGINE = "modernui_mc_disableTextEngine";
    public static final String BOOTSTRAP_DISABLE_SMOOTH_SCROLLING = "modernui_mc_disableSmoothScrolling";
    public static final String BOOTSTRAP_DISABLE_ENHANCED_TEXT_FIELD = "modernui_mc_disableEnhancedTextField";
    public static volatile boolean sDevelopment;
    public static volatile boolean sDeveloperMode;
    protected static boolean sOptiFineLoaded;
    protected static boolean sIrisApiLoaded;
    protected static volatile boolean sLegendaryTooltipsLoaded;
    protected static volatile boolean sUntranslatedItemsLoaded;
    private static volatile Boolean sTextEngineEnabled;

    @Nonnull
    public static ResourceLocation location(String path) {
        return new ResourceLocation("modernui", path);
    }

    public static boolean isOptiFineLoaded() {
        return sOptiFineLoaded;
    }

    public static boolean isIrisApiLoaded() {
        return sIrisApiLoaded;
    }

    public static boolean isLegendaryTooltipsLoaded() {
        return sLegendaryTooltipsLoaded;
    }

    public static boolean isUntranslatedItemsLoaded() {
        return sUntranslatedItemsLoaded;
    }

    public static boolean isDeveloperMode() {
        return sDeveloperMode || sDevelopment;
    }

    public static String getBootstrapProperty(String key) {
        return ModernUIClient.getBootstrapProperty(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isTextEngineEnabled() {
        if (sTextEngineEnabled != null) return sTextEngineEnabled;
        Class<ModernUIMod> clazz = ModernUIMod.class;
        synchronized (ModernUIMod.class) {
            if (sTextEngineEnabled != null) return sTextEngineEnabled;
            sTextEngineEnabled = !Boolean.parseBoolean(ModernUIMod.getBootstrapProperty(BOOTSTRAP_DISABLE_TEXT_ENGINE));
            // ** MonitorExit[var0] (shouldn't be in output)
            return sTextEngineEnabled;
        }
    }

    static {
        try {
            Class<?> clazz = Class.forName("optifine.Installer");
            sOptiFineLoaded = true;
            try {
                String version = (String)clazz.getMethod("getOptiFineVersion", new Class[0]).invoke(null, new Object[0]);
                LOGGER.info(MARKER, "OptiFine installed: {}", (Object)version);
            }
            catch (Exception e) {
                LOGGER.info(MARKER, "OptiFine installed...");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            Class.forName("net.irisshaders.iris.api.v0.IrisApi");
            sIrisApiLoaded = true;
            LOGGER.info(MARKER, "Iris API installed...");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

