/*
 * Decompiled with CFR 0.152.
 */
package icyllis.modernui.mc;

import com.mojang.blaze3d.shaders.AbstractUniform;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.VertexConsumer;
import icyllis.arc3d.core.MathUtil;
import icyllis.modernui.graphics.Color;
import icyllis.modernui.mc.GuiRenderType;
import icyllis.modernui.mc.MuiModApi;
import icyllis.modernui.mc.ScrollController;
import icyllis.modernui.mc.mixin.AccessClientTextTooltip;
import icyllis.modernui.mc.text.CharacterStyle;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTextTooltip;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipPositioner;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.FormattedCharSink;
import net.minecraft.util.StringDecomposer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Rarity;
import org.jetbrains.annotations.ApiStatus;
import org.joml.Matrix4f;
import org.joml.Vector2ic;

@ApiStatus.Internal
public final class TooltipRenderer
implements ScrollController.IListener {
    public static volatile boolean sTooltip = true;
    public static final int[] sFillColor = new int[4];
    public static final int[] sStrokeColor = new int[4];
    public static volatile float sBorderWidth = 1.3333334f;
    public static volatile float sCornerRadius = 4.0f;
    public static volatile float sShadowRadius = 10.0f;
    public static volatile float sShadowAlpha = 0.3f;
    public static volatile boolean sAdaptiveColors = true;
    public static volatile boolean sLineWrapping_FabricOnly = true;
    public static final int TOOLTIP_SPACE = 12;
    public static final int H_BORDER = 4;
    public static final int V_BORDER = 4;
    private static final int TITLE_GAP = 2;
    private final int[] mWorkStrokeColor = new int[4];
    private final int[] mActiveStrokeColor = new int[4];
    public static volatile int sBorderColorCycle = 1000;
    public static volatile boolean sExactPositioning = true;
    public static volatile boolean sRoundedShapes = true;
    public static volatile boolean sCenterTitle = true;
    public static volatile boolean sTitleBreak = true;
    public static volatile int sArrowScrollFactor = 60;
    public volatile boolean mLayoutRTL;
    private boolean mDraw;
    private float mScroll;
    private int mMarqueeDir;
    private long mMarqueeEndMillis;
    private int mPendingArrowMove;
    private final ScrollController mScroller = new ScrollController(this);
    private static final long MARQUEE_DELAY_MILLIS = 1200L;
    private boolean mFrameGap;
    private long mCurrTimeMillis;
    private long mCurrDeltaMillis;
    private ItemStack mLastSeenItem;
    private boolean mUseSpectrum;

    public void update(long deltaMillis, long timeMillis) {
        if (this.mDraw) {
            this.mDraw = false;
            if (this.mFrameGap) {
                this.mScroller.scrollTo(0.0f);
                this.mScroller.abortAnimation();
                this.mMarqueeEndMillis = timeMillis;
                this.mMarqueeDir = 1;
            }
            this.mFrameGap = false;
        } else {
            this.mFrameGap = true;
            this.mLastSeenItem = null;
            this.mPendingArrowMove = 0;
        }
        this.mCurrTimeMillis = timeMillis;
        this.mCurrDeltaMillis = deltaMillis;
    }

    public void updateArrowMovement(int move) {
        if (sArrowScrollFactor > 0) {
            this.mPendingArrowMove += move;
        }
    }

    @Override
    public void onScrollAmountUpdated(ScrollController controller, float amount) {
        this.mMarqueeDir = 0;
        this.mScroll = amount;
    }

    void computeWorkingColor(@Nonnull ItemStack item) {
        if (sAdaptiveColors && !item.isEmpty()) {
            if (sRoundedShapes && (item.is(Items.DRAGON_EGG) || item.is(Items.MOJANG_BANNER_PATTERN))) {
                this.mUseSpectrum = true;
                return;
            }
            Style baseStyle = Style.EMPTY;
            Rarity rarity = item.getRarity();
            if (rarity != Rarity.COMMON) {
                baseStyle = MuiModApi.get().applyRarityTo(rarity, baseStyle);
            }
            IntOpenHashSet colors = new IntOpenHashSet(16);
            StringDecomposer.iterateFormatted((FormattedText)item.getHoverName(), (Style)baseStyle, (i, style, ch) -> {
                TextColor textColor = style.getColor();
                if (textColor != null) {
                    return !colors.add(textColor.getValue() & 0xFFFFFF) || colors.size() < 16;
                }
                return true;
            });
            if (!colors.isEmpty()) {
                ArrayList<float[]> hsvColors = new ArrayList<float[]>(16);
                IntIterator it = colors.iterator();
                while (it.hasNext()) {
                    int c = it.nextInt();
                    float[] hsv = new float[3];
                    Color.RGBToHSV(c, hsv);
                    hsv[1] = Math.min(hsv[1], 0.9f);
                    hsv[2] = MathUtil.clamp(hsv[2], 0.2f, 0.85f);
                    hsvColors.add(hsv);
                }
                if (!hsvColors.isEmpty()) {
                    int c4;
                    int c3;
                    int c2;
                    int size = hsvColors.size();
                    if (size > 4) {
                        if (sRoundedShapes) {
                            this.mUseSpectrum = true;
                            return;
                        }
                        Collections.shuffle(hsvColors);
                    }
                    int c1 = Color.HSVToColor((float[])hsvColors.get(0));
                    if (size > 2) {
                        c2 = Color.HSVToColor((float[])hsvColors.get(1));
                        c3 = Color.HSVToColor((float[])hsvColors.get(2));
                        if (size == 4) {
                            c4 = Color.HSVToColor((float[])hsvColors.get(3));
                        } else {
                            float[] hsv = (float[])hsvColors.get(1);
                            hsv[0] = (hsv[0] + 180.0f) % 360.0f;
                            c4 = Color.HSVToColor(hsv);
                        }
                    } else if (size == 2) {
                        c3 = Color.HSVToColor((float[])hsvColors.get(1));
                        c2 = TooltipRenderer.lerpInLinearSpace(0.5f, c1, c3);
                        float[] hsv = new float[3];
                        Color.RGBToHSV(c2, hsv);
                        c4 = TooltipRenderer.adjustColor(hsv, false, true, false, item.isEnchanted());
                    } else {
                        float[] hsv = (float[])hsvColors.get(0);
                        boolean mag = item.isEnchanted();
                        c2 = TooltipRenderer.adjustColor(hsv, false, true, false, mag);
                        c3 = TooltipRenderer.adjustColor(hsv, true, true, true, mag);
                        c4 = TooltipRenderer.adjustColor(hsv, true, false, true, mag);
                    }
                    this.mWorkStrokeColor[0] = sStrokeColor[0] & 0xFF000000 | c1;
                    this.mWorkStrokeColor[1] = sStrokeColor[1] & 0xFF000000 | c2;
                    this.mWorkStrokeColor[2] = sStrokeColor[2] & 0xFF000000 | c3;
                    this.mWorkStrokeColor[3] = sStrokeColor[3] & 0xFF000000 | c4;
                    this.mUseSpectrum = false;
                    return;
                }
            }
        }
        System.arraycopy(sStrokeColor, 0, this.mWorkStrokeColor, 0, 4);
        this.mUseSpectrum = false;
    }

    static int adjustColor(float[] hsv, boolean hue, boolean sat, boolean val, boolean magnified) {
        float h = hsv[0];
        float s = hsv[1];
        float v = hsv[2];
        if (hue) {
            h = h >= 60.0f && h <= 240.0f ? (h += magnified ? 27.0f : 15.0f) : (h -= magnified ? 18.0f : 10.0f);
            h = (h + 360.0f) % 360.0f;
        }
        if (sat) {
            s = s < 0.6f ? (s += magnified ? 0.18f : 0.12f) : (s -= magnified ? 0.12f : 0.06f);
        }
        if (val) {
            v = v < 0.6f ? (v += magnified ? 0.12f : 0.08f) : (v -= magnified ? 0.08f : 0.04f);
        }
        return Color.HSVToColor(h, s, v);
    }

    void updateBorderColor() {
        float p = (float)(this.mCurrTimeMillis % (long)sBorderColorCycle) / (float)sBorderColorCycle;
        if (this.mLayoutRTL) {
            int pos = (int)(this.mCurrTimeMillis / (long)sBorderColorCycle & 3L);
            for (int i = 0; i < 4; ++i) {
                this.mActiveStrokeColor[i] = TooltipRenderer.lerpInLinearSpace(p, this.mWorkStrokeColor[i + pos & 3], this.mWorkStrokeColor[i + pos + 1 & 3]);
            }
        } else {
            int pos = 3 - (int)(this.mCurrTimeMillis / (long)sBorderColorCycle & 3L);
            for (int i = 0; i < 4; ++i) {
                this.mActiveStrokeColor[i] = TooltipRenderer.lerpInLinearSpace(p, this.mWorkStrokeColor[i + pos & 3], this.mWorkStrokeColor[i + pos + 3 & 3]);
            }
        }
    }

    static int lerpInLinearSpace(float fraction, int startValue, int endValue) {
        int result = 0;
        for (int i = 0; i < 4; ++i) {
            float s = (float)(startValue >> (i << 3) & 0xFF) / 255.0f;
            float t = (float)(endValue >> (i << 3) & 0xFF) / 255.0f;
            float v = MathUtil.lerp(s, t, fraction);
            result |= Math.round(v * 255.0f) << (i << 3);
        }
        return result;
    }

    @Nullable
    static Style findSingleStyle(@Nonnull ClientTextTooltip line) {
        FormattedCharSequence text = ((AccessClientTextTooltip)line).getText();
        class StyleFinder
        implements FormattedCharSink {
            Style style = null;
            int count = 0;

            StyleFinder() {
            }

            public boolean accept(int index, @Nonnull Style style, int codePoint) {
                if (this.style == null) {
                    this.style = style;
                } else if (!CharacterStyle.equalsForTextLayout(this.style, style)) {
                    this.style = null;
                    return false;
                }
                return ++this.count <= 50;
            }
        }
        StyleFinder finder = new StyleFinder();
        text.accept((FormattedCharSink)finder);
        return finder.style;
    }

    int chooseBorderColor(int corner) {
        if (sBorderColorCycle > 0) {
            return this.mActiveStrokeColor[corner];
        }
        return this.mWorkStrokeColor[corner];
    }

    void chooseBorderColor(int corner, AbstractUniform uniform) {
        int color = this.chooseBorderColor(corner);
        int a = color >>> 24;
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color & 0xFF;
        uniform.set((float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f, (float)a / 255.0f);
    }

    public void drawTooltip(@Nonnull ItemStack itemStack, @Nonnull GuiGraphics gr, @Nonnull List<ClientTooltipComponent> list, int mouseX, int mouseY, @Nonnull Font font, int screenWidth, int screenHeight, float partialX, float partialY, @Nullable ClientTooltipPositioner positioner) {
        ClientTooltipComponent component;
        int i;
        float maxScroll;
        float tooltipY;
        float tooltipX;
        int tooltipHeight;
        int tooltipWidth;
        this.mDraw = true;
        if (itemStack != this.mLastSeenItem) {
            this.mLastSeenItem = itemStack;
            this.computeWorkingColor(itemStack);
        }
        boolean titleGap = false;
        int titleBreakHeight = 0;
        if (list.size() == 1) {
            ClientTooltipComponent component2 = list.get(0);
            tooltipWidth = component2.getWidth(font);
            tooltipHeight = component2.getHeight() - 2;
        } else {
            tooltipWidth = 0;
            tooltipHeight = 0;
            Style singleStyle = null;
            for (int i2 = 0; i2 < list.size(); ++i2) {
                ClientTooltipComponent component3 = list.get(i2);
                tooltipWidth = Math.max(tooltipWidth, component3.getWidth(font));
                int componentHeight = component3.getHeight();
                tooltipHeight += componentHeight;
                if (i2 == 0) {
                    titleBreakHeight = componentHeight;
                    if (!(component3 instanceof ClientTextTooltip)) continue;
                    if (!itemStack.isEmpty()) {
                        titleGap = true;
                        continue;
                    }
                    singleStyle = TooltipRenderer.findSingleStyle((ClientTextTooltip)component3);
                    if (singleStyle != null) continue;
                    titleGap = true;
                    continue;
                }
                if (i2 > 2 || titleGap || !(component3 instanceof ClientTextTooltip)) continue;
                Style lineStyle = TooltipRenderer.findSingleStyle((ClientTextTooltip)component3);
                if (lineStyle == null) {
                    titleGap = true;
                    continue;
                }
                if (singleStyle == null) {
                    singleStyle = lineStyle;
                    continue;
                }
                if (CharacterStyle.equalsForTextLayout(singleStyle, lineStyle)) continue;
                titleGap = true;
            }
            if (!titleGap) {
                tooltipHeight -= 2;
            }
        }
        if (positioner != null) {
            Vector2ic pos = positioner.positionTooltip(screenWidth, screenHeight, mouseX, mouseY, tooltipWidth, tooltipHeight);
            tooltipX = pos.x();
            tooltipY = pos.y();
            maxScroll = 0.0f;
        } else {
            if (this.mLayoutRTL) {
                tooltipX = (float)(mouseX + 12) + partialX - 24.0f - (float)tooltipWidth;
                if (tooltipX - partialX < 4.0f) {
                    tooltipX += (float)(24 + tooltipWidth);
                }
            } else {
                tooltipX = (float)(mouseX + 12) + partialX;
                if (tooltipX - partialX + (float)tooltipWidth + 4.0f > (float)screenWidth) {
                    tooltipX -= (float)(28 + tooltipWidth);
                }
            }
            partialX = tooltipX - (float)((int)tooltipX);
            tooltipY = (float)(mouseY - 12) + partialY;
            if (tooltipY + (float)tooltipHeight + 6.0f > (float)screenHeight) {
                tooltipY = screenHeight - tooltipHeight - 6;
            }
            if (tooltipY < 6.0f) {
                tooltipY = 6.0f;
            }
            partialY = tooltipY - (float)((int)tooltipY);
            maxScroll = 6 + tooltipHeight + 6 - screenHeight;
        }
        if (maxScroll > 0.0f) {
            this.mScroller.setMaxScroll(maxScroll);
            if (this.mPendingArrowMove != 0) {
                if (this.mMarqueeDir != 0) {
                    this.mScroller.scrollTo(this.mScroll);
                    this.mScroller.abortAnimation();
                }
                this.mScroller.scrollBy(this.mPendingArrowMove * sArrowScrollFactor);
                this.mPendingArrowMove = 0;
            }
            this.mScroller.update(MuiModApi.getElapsedTime());
            this.mScroll = MathUtil.clamp(this.mScroll, 0.0f, maxScroll);
            if (this.mMarqueeDir != 0 && this.mCurrTimeMillis - this.mMarqueeEndMillis >= 1200L) {
                float t = MathUtil.clamp(0.5f * (float)tooltipWidth / (float)screenWidth, 0.0f, 0.5f);
                float baseMultiplier = (1.5f - t) * 0.01f;
                this.mScroll += (float)((long)this.mMarqueeDir * this.mCurrDeltaMillis) * (baseMultiplier + baseMultiplier * Math.min(maxScroll / (float)screenHeight, 1.5f));
                if (this.mMarqueeDir > 0) {
                    if (this.mScroll >= maxScroll) {
                        this.mMarqueeDir = -1;
                        this.mMarqueeEndMillis = this.mCurrTimeMillis;
                    }
                } else if (this.mScroll <= 0.0f) {
                    this.mMarqueeDir = 1;
                    this.mMarqueeEndMillis = this.mCurrTimeMillis;
                }
            }
        } else {
            this.mScroll = 0.0f;
            this.mPendingArrowMove = 0;
        }
        if (sBorderColorCycle > 0) {
            this.updateBorderColor();
        }
        gr.flush();
        gr.pose().pushPose();
        gr.pose().translate(0.0f, -this.mScroll, 400.0f);
        Matrix4f pose = gr.pose().last().pose();
        RenderSystem.enableDepthTest();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        if (sRoundedShapes) {
            this.drawRoundedBackground(gr, pose, tooltipX, tooltipY, tooltipWidth, tooltipHeight, titleGap, titleBreakHeight);
        } else {
            this.drawVanillaBackground(gr, pose, tooltipX, tooltipY, tooltipWidth, tooltipHeight, titleGap, titleBreakHeight);
        }
        int drawX = (int)tooltipX;
        int drawY = (int)tooltipY;
        RenderSystem.enableDepthTest();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        MultiBufferSource.BufferSource source = gr.bufferSource();
        gr.pose().translate(partialX, partialY, sRoundedShapes ? 0.1f : 0.0f);
        for (i = 0; i < list.size(); ++i) {
            component = list.get(i);
            if (titleGap && i == 0 && sCenterTitle) {
                component.renderText(font, drawX + (tooltipWidth - component.getWidth(font)) / 2, drawY, pose, source);
            } else if (this.mLayoutRTL) {
                component.renderText(font, drawX + tooltipWidth - component.getWidth(font), drawY, pose, source);
            } else {
                component.renderText(font, drawX, drawY, pose, source);
            }
            if (titleGap && i == 0) {
                drawY += 2;
            }
            drawY += component.getHeight();
        }
        gr.flush();
        drawY = (int)tooltipY;
        for (i = 0; i < list.size(); ++i) {
            component = list.get(i);
            if (this.mLayoutRTL) {
                component.renderImage(font, drawX + tooltipWidth - component.getWidth(font), drawY, gr);
            } else {
                component.renderImage(font, drawX, drawY, gr);
            }
            if (titleGap && i == 0) {
                drawY += 2;
            }
            drawY += component.getHeight();
        }
        gr.pose().popPose();
    }

    private void drawRoundedBackground(@Nonnull GuiGraphics gr, Matrix4f pose, float tooltipX, float tooltipY, int tooltipWidth, int tooltipHeight, boolean titleGap, int titleBreakHeight) {
        float halfWidth = (float)tooltipWidth / 2.0f;
        float halfHeight = (float)tooltipHeight / 2.0f;
        float centerX = tooltipX + halfWidth;
        float centerY = tooltipY + halfHeight;
        float sizeX = halfWidth + 4.0f;
        float sizeY = halfHeight + 4.0f;
        float shadowRadius = Math.max(sShadowRadius, 1.0E-5f);
        ShaderInstance shader = GuiRenderType.getShaderTooltip();
        if (shader == null) {
            return;
        }
        shader.safeGetUniform("u_PushData0").set(sizeX, sizeY, sCornerRadius, sBorderWidth / 2.0f);
        float rainbowOffset = 0.0f;
        if (this.mUseSpectrum) {
            rainbowOffset = 1.0f;
            if (sBorderColorCycle > 0) {
                long overallCycle = (long)sBorderColorCycle * 4L;
                rainbowOffset += (float)(this.mCurrTimeMillis % overallCycle) / (float)overallCycle;
            }
            if (!this.mLayoutRTL) {
                rainbowOffset = -rainbowOffset;
            }
        }
        shader.safeGetUniform("u_PushData1").set(sShadowAlpha, 1.25f / shadowRadius, (float)(sFillColor[0] >>> 24) / 255.0f, rainbowOffset);
        if (rainbowOffset == 0.0f) {
            this.chooseBorderColor(0, shader.safeGetUniform("u_PushData2"));
            this.chooseBorderColor(1, shader.safeGetUniform("u_PushData3"));
            this.chooseBorderColor(3, shader.safeGetUniform("u_PushData4"));
            this.chooseBorderColor(2, shader.safeGetUniform("u_PushData5"));
        }
        VertexConsumer buffer = gr.bufferSource().getBuffer(GuiRenderType.tooltip());
        RenderSystem.getModelViewStack().pushPose();
        RenderSystem.getModelViewStack().mulPoseMatrix(pose);
        RenderSystem.getModelViewStack().translate(centerX, centerY, 0.0f);
        RenderSystem.applyModelViewMatrix();
        float extent = sBorderWidth / 2.0f + 0.5f + shadowRadius * 1.2f;
        float extentX = sizeX + extent;
        float extentY = sizeY + extent;
        buffer.vertex((double)extentX, (double)extentY, 0.0).endVertex();
        buffer.vertex((double)extentX, (double)(-extentY), 0.0).endVertex();
        buffer.vertex((double)(-extentX), (double)(-extentY), 0.0).endVertex();
        buffer.vertex((double)(-extentX), (double)extentY, 0.0).endVertex();
        gr.flush();
        RenderSystem.getModelViewStack().popPose();
        RenderSystem.applyModelViewMatrix();
        if (titleGap && sTitleBreak) {
            TooltipRenderer.fillGrad(gr, pose, tooltipX, tooltipY + (float)titleBreakHeight - 0.5f, tooltipX + (float)tooltipWidth, tooltipY + (float)titleBreakHeight + 0.5f, 0.08f, -523712312, -523712312, -523712312, -523712312);
        }
    }

    private void drawVanillaBackground(@Nonnull GuiGraphics gr, Matrix4f pose, float tooltipX, float tooltipY, int tooltipWidth, int tooltipHeight, boolean titleGap, int titleBreakHeight) {
        float left = tooltipX - 4.0f;
        float top = tooltipY - 4.0f;
        float right = tooltipX + (float)tooltipWidth + 4.0f;
        float bottom = tooltipY + (float)tooltipHeight + 4.0f;
        TooltipRenderer.fillGrad(gr, pose, left, top - 1.0f, right, top, 0.0f, sFillColor[0], sFillColor[1], sFillColor[1], sFillColor[0]);
        TooltipRenderer.fillGrad(gr, pose, left, bottom, right, bottom + 1.0f, 0.0f, sFillColor[3], sFillColor[2], sFillColor[2], sFillColor[3]);
        TooltipRenderer.fillGrad(gr, pose, left, top, right, bottom, 0.0f, sFillColor[0], sFillColor[1], sFillColor[2], sFillColor[3]);
        TooltipRenderer.fillGrad(gr, pose, left - 1.0f, top, left, bottom, 0.0f, sFillColor[0], sFillColor[0], sFillColor[3], sFillColor[3]);
        TooltipRenderer.fillGrad(gr, pose, right, top, right + 1.0f, bottom, 0.0f, sFillColor[1], sFillColor[1], sFillColor[2], sFillColor[2]);
        if (titleGap && sTitleBreak) {
            TooltipRenderer.fillGrad(gr, pose, tooltipX, tooltipY + (float)titleBreakHeight - 0.5f, tooltipX + (float)tooltipWidth, tooltipY + (float)titleBreakHeight + 0.5f, 0.0f, -523712312, -523712312, -523712312, -523712312);
        }
        TooltipRenderer.fillGrad(gr, pose, left, top, right, top + 1.0f, 0.0f, this.chooseBorderColor(0), this.chooseBorderColor(1), this.chooseBorderColor(1), this.chooseBorderColor(0));
        TooltipRenderer.fillGrad(gr, pose, right - 1.0f, top, right, bottom, 0.0f, this.chooseBorderColor(1), this.chooseBorderColor(1), this.chooseBorderColor(2), this.chooseBorderColor(2));
        TooltipRenderer.fillGrad(gr, pose, left, bottom - 1.0f, right, bottom, 0.0f, this.chooseBorderColor(3), this.chooseBorderColor(2), this.chooseBorderColor(2), this.chooseBorderColor(3));
        TooltipRenderer.fillGrad(gr, pose, left, top, left + 1.0f, bottom, 0.0f, this.chooseBorderColor(0), this.chooseBorderColor(0), this.chooseBorderColor(3), this.chooseBorderColor(3));
    }

    private static void fillGrad(GuiGraphics gr, Matrix4f pose, float left, float top, float right, float bottom, float z, int colorUL, int colorUR, int colorLR, int colorLL) {
        VertexConsumer buffer = gr.bufferSource().getBuffer(RenderType.gui());
        int color = colorLR;
        buffer.vertex(pose, right, bottom, z).color(color).endVertex();
        color = colorUR;
        buffer.vertex(pose, right, top, z).color(color).endVertex();
        color = colorUL;
        buffer.vertex(pose, left, top, z).color(color).endVertex();
        color = colorLL;
        buffer.vertex(pose, left, bottom, z).color(color).endVertex();
        gr.flush();
    }
}

