/*
 * Decompiled with CFR 0.152.
 */
package icyllis.modernui.mc.neoforge;

import icyllis.modernui.ModernUI;
import icyllis.modernui.mc.FontResourceManager;
import icyllis.modernui.mc.ModernUIClient;
import icyllis.modernui.mc.ModernUIMod;
import icyllis.modernui.mc.neoforge.CenterFragment2;
import icyllis.modernui.mc.neoforge.Config;
import icyllis.modernui.mc.neoforge.LocalStorage;
import icyllis.modernui.mc.neoforge.ModernUIText;
import icyllis.modernui.mc.neoforge.MuiForgeApi;
import icyllis.modernui.mc.neoforge.Registration;
import icyllis.modernui.util.DataSet;
import java.util.Locale;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.LanguageManager;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModList;
import net.neoforged.fml.ModLoader;
import net.neoforged.fml.ModLoadingContext;
import net.neoforged.fml.ModLoadingStage;
import net.neoforged.fml.ModLoadingWarning;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.client.ConfigScreenHandler;

@Mod(value="modernui")
public final class ModernUIForge
extends ModernUIMod {
    public ModernUIForge(IEventBus modEventBus) {
        if (!FMLEnvironment.production) {
            ModernUIMod.sDevelopment = true;
            LOGGER.debug(MARKER, "Auto detected in FML development environment");
        } else if (ModernUI.class.getSigners() == null) {
            LOGGER.warn(MARKER, "Signature is missing");
        }
        if (ModList.get().isLoaded("tipthescales") && !ModernUIMod.sOptiFineLoaded) {
            LOGGER.fatal(MARKER, "Detected TipTheScales without OptiFine");
            ModernUIForge.warnSetup("You should remove TipTheScales, Modern UI already includes its features, and Modern UI is also compatible with OptiFine", new Object[0]);
        }
        if (ModList.get().isLoaded("reblured")) {
            LOGGER.fatal(MARKER, "Detected ReBlurred");
            ModernUIForge.warnSetup("You should remove ReBlurred, Modern UI already includes its features, and Modern UI has better performance than it", new Object[0]);
        }
        sLegendaryTooltipsLoaded = ModList.get().isLoaded("legendarytooltips");
        sUntranslatedItemsLoaded = ModList.get().isLoaded("untranslateditems");
        Config.initCommonConfig(spec -> ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)spec, "ModernUI/common.toml"));
        modEventBus.addListener(event -> Config.reloadCommon(event.getConfig()));
        LocalStorage.init();
        if (FMLEnvironment.dist.isClient()) {
            Loader.init(modEventBus);
        }
        LOGGER.info(MARKER, "Initialized Modern UI");
    }

    public static void warnSetup(String key, Object ... args) {
        ModLoader.get().addWarning(new ModLoadingWarning(null, ModLoadingStage.SIDED_SETUP, key, args));
    }

    private static class Loader {
        private Loader() {
        }

        public static void init(IEventBus modEventBus) {
            new Client(modEventBus);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Client
    extends ModernUIClient {
        static final /* synthetic */ boolean $assertionsDisabled;

        private Client(IEventBus modEventBus) {
            Config.initClientConfig(spec -> ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)spec, "ModernUI/client.toml"));
            Config.initTextConfig(spec -> ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)spec, "ModernUI/text.toml"));
            FontResourceManager.getInstance();
            if (ModernUIMod.isTextEngineEnabled()) {
                ModernUIText.init(modEventBus);
                LOGGER.info(MARKER, "Initialized Modern UI text engine");
            }
            modEventBus.addListener(event -> Config.reloadAnyClient(event.getConfig()));
            ModLoadingContext.get().registerExtensionPoint(ConfigScreenHandler.ConfigScreenFactory.class, () -> new ConfigScreenHandler.ConfigScreenFactory((mc, modsScreen) -> {
                DataSet args = new DataSet();
                args.putBoolean("navigateToPreferences", true);
                CenterFragment2 fragment = new CenterFragment2();
                fragment.setArguments(args);
                return MuiForgeApi.get().createScreen(fragment, null, (Screen)modsScreen);
            }));
            if (ModernUIMod.sDevelopment) {
                modEventBus.register(Registration.ModClientDev.class);
            }
            LOGGER.info(MARKER, "Initialized Modern UI client");
        }

        @Override
        @Nonnull
        protected Locale onGetSelectedLocale() {
            LanguageManager languageManager;
            Minecraft minecraft = Minecraft.getInstance();
            if (minecraft != null && (languageManager = minecraft.getLanguageManager()) != null) {
                return languageManager.getJavaLocale();
            }
            return super.onGetSelectedLocale();
        }

        static {
            boolean bl = $assertionsDisabled = !ModernUIForge.class.desiredAssertionStatus();
            if (!$assertionsDisabled && !FMLEnvironment.dist.isClient()) {
                throw new AssertionError();
            }
        }
    }
}

