/*
 * Decompiled with CFR 0.152.
 */
package icyllis.modernui.mc.neoforge;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.vertex.VertexFormat;
import icyllis.modernui.ModernUI;
import icyllis.modernui.fragment.Fragment;
import icyllis.modernui.mc.MuiModApi;
import icyllis.modernui.mc.MuiScreen;
import icyllis.modernui.mc.ScreenCallback;
import icyllis.modernui.mc.UIManager;
import icyllis.modernui.mc.neoforge.MenuScreen;
import icyllis.modernui.mc.neoforge.SimpleScreen;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Rarity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.fml.loading.ImmediateWindowHandler;

@OnlyIn(value=Dist.CLIENT)
public final class MuiForgeApi
extends MuiModApi {
    public MuiForgeApi() {
        ModernUI.LOGGER.info(ModernUI.MARKER, "Created MuiForgeAPI");
    }

    @Override
    @Nonnull
    public <T extends Screen> T createScreen(@Nonnull Fragment fragment, @Nullable ScreenCallback callback, @Nullable Screen previousScreen, @Nullable CharSequence title) {
        return (T)new SimpleScreen(UIManager.getInstance(), fragment, callback, previousScreen, title);
    }

    @Override
    @Nonnull
    public <T extends AbstractContainerMenu, U extends Screen & MuiScreen> U createMenuScreen(@Nonnull Fragment fragment, @Nullable ScreenCallback callback, @Nonnull T menu, @Nonnull Inventory inventory, @Nonnull Component title) {
        return (U)new MenuScreen<T>(UIManager.getInstance(), fragment, callback, menu, inventory, title);
    }

    @Override
    public boolean isGLVersionPromoted() {
        try {
            String version = ImmediateWindowHandler.getGLVersion();
            if (!"3.2".equals(version)) {
                ModernUI.LOGGER.info(ModernUI.MARKER, "Detected OpenGL {} Core Profile from FML Early Window", (Object)version);
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    @Override
    public void loadEffect(GameRenderer gr, ResourceLocation effect) {
        gr.loadEffect(effect);
    }

    @Override
    public ShaderInstance makeShaderInstance(ResourceProvider resourceProvider, ResourceLocation resourceLocation, VertexFormat vertexFormat) throws IOException {
        return new ShaderInstance(resourceProvider, resourceLocation, vertexFormat);
    }

    @Override
    public boolean isKeyBindingMatches(KeyMapping keyMapping, InputConstants.Key key) {
        return keyMapping.isActiveAndMatches(key);
    }

    @Override
    public Style applyRarityTo(Rarity rarity, Style baseStyle) {
        return (Style)rarity.getStyleModifier().apply(baseStyle);
    }
}

