/*
 * Decompiled with CFR 0.152.
 */
package icyllis.modernui.mc.neoforge;

import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import icyllis.modernui.core.Core;
import icyllis.modernui.core.Handler;
import icyllis.modernui.fragment.FragmentController;
import icyllis.modernui.graphics.ImageStore;
import icyllis.modernui.mc.BlurHandler;
import icyllis.modernui.mc.FontResourceManager;
import icyllis.modernui.mc.GuiRenderType;
import icyllis.modernui.mc.ModernUIMod;
import icyllis.modernui.mc.MuiModApi;
import icyllis.modernui.mc.OptiFineIntegration;
import icyllis.modernui.mc.UIManager;
import icyllis.modernui.mc.mixin.AccessOptions;
import icyllis.modernui.mc.neoforge.Config;
import icyllis.modernui.mc.neoforge.MenuScreenFactory;
import icyllis.modernui.mc.neoforge.MuiRegistries;
import icyllis.modernui.mc.neoforge.ProjectBuilderItem;
import icyllis.modernui.mc.neoforge.ProjectBuilderModel;
import icyllis.modernui.mc.neoforge.ServerHandler;
import icyllis.modernui.mc.neoforge.TestContainerMenu;
import icyllis.modernui.mc.neoforge.TestPauseFragment;
import icyllis.modernui.mc.neoforge.UIManagerForge;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.OptionInstance;
import net.minecraft.client.Options;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.Mth;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.CrashReportCallables;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.client.event.ModelEvent;
import net.neoforged.neoforge.client.event.RegisterClientReloadListenersEvent;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;
import net.neoforged.neoforge.client.event.RegisterParticleProvidersEvent;
import net.neoforged.neoforge.client.event.RegisterShadersEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.extensions.IMenuTypeExtension;
import net.neoforged.neoforge.registries.RegisterEvent;
import org.apache.commons.io.output.StringBuilderWriter;

@Mod.EventBusSubscriber(modid="modernui", bus=Mod.EventBusSubscriber.Bus.MOD)
final class Registration {
    private Registration() {
    }

    @SubscribeEvent
    static void register(@Nonnull RegisterEvent event) {
        if (ModernUIMod.sDevelopment) {
            event.register(Registries.MENU, Registration::registerMenus);
            event.register(Registries.ITEM, Registration::registerItems);
        }
    }

    static void registerMenus(@Nonnull RegisterEvent.RegisterHelper<MenuType<?>> helper) {
        helper.register(MuiRegistries.TEST_MENU_KEY, (Object)IMenuTypeExtension.create(TestContainerMenu::new));
    }

    static void registerItems(@Nonnull RegisterEvent.RegisterHelper<Item> helper) {
        Item.Properties properties = new Item.Properties().stacksTo(1);
        helper.register(MuiRegistries.PROJECT_BUILDER_ITEM_KEY, (Object)new ProjectBuilderItem(properties));
    }

    @SubscribeEvent
    static void setupCommon(@Nonnull FMLCommonSetupEvent event) {
        if (ModList.get().getModContainerById(new String(new byte[]{107, 73, 119, 105}, StandardCharsets.UTF_8).toLowerCase(Locale.ROOT)).isPresent()) {
            event.enqueueWork(() -> ModernUIMod.LOGGER.fatal("OK"));
        }
        NeoForge.EVENT_BUS.register((Object)ServerHandler.INSTANCE);
    }

    static class ModClientDev {
        static final /* synthetic */ boolean $assertionsDisabled;

        private ModClientDev() {
        }

        @SubscribeEvent
        static void onRegistryModel(@Nonnull ModelEvent.RegisterAdditional event) {
            event.register(ModernUIMod.location("item/project_builder_main"));
            event.register(ModernUIMod.location("item/project_builder_cube"));
        }

        @SubscribeEvent
        static void onBakeModel(@Nonnull ModelEvent.ModifyBakingResult event) {
            Map registry = event.getModels();
            ModClientDev.replaceModel(registry, new ModelResourceLocation("modernui", "project_builder", "inventory"), baseModel -> new ProjectBuilderModel((BakedModel)baseModel, event.getModels()));
        }

        private static void replaceModel(@Nonnull Map<ResourceLocation, BakedModel> modelRegistry, @Nonnull ModelResourceLocation location, @Nonnull Function<BakedModel, BakedModel> replacer) {
            modelRegistry.put((ResourceLocation)location, replacer.apply(modelRegistry.get(location)));
        }

        static {
            boolean bl = $assertionsDisabled = !Registration.class.desiredAssertionStatus();
            if (!$assertionsDisabled && !FMLEnvironment.dist.isClient()) {
                throw new AssertionError();
            }
        }
    }

    @Mod.EventBusSubscriber(modid="modernui", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    static class ModClient {
        static final /* synthetic */ boolean $assertionsDisabled;

        private ModClient() {
        }

        @SubscribeEvent
        static void loadingClient(RegisterParticleProvidersEvent event) {
            UIManagerForge.initialize();
        }

        @SubscribeEvent
        static void registerResourceListener(@Nonnull RegisterClientReloadListenersEvent event) {
            event.registerReloadListener((PreparableReloadListener)((ResourceManagerReloadListener)manager -> {
                ImageStore.getInstance().clear();
                Handler handler = Core.getUiHandlerAsync();
                if (handler != null) {
                    handler.post(() -> UIManager.getInstance().updateLayoutDir((Boolean)Config.CLIENT.mForceRtl.get()));
                }
                BlurHandler.INSTANCE.loadEffect();
            }));
            if (!ModernUIMod.isTextEngineEnabled()) {
                event.registerReloadListener((PreparableReloadListener)FontResourceManager.getInstance());
            }
            ModernUIMod.LOGGER.debug(ModernUIMod.MARKER, "Registered resource reload listener");
        }

        @SubscribeEvent
        static void registerKeyMapping(@Nonnull RegisterKeyMappingsEvent event) {
            event.register(UIManagerForge.OPEN_CENTER_KEY);
            event.register(UIManagerForge.ZOOM_KEY);
        }

        @SubscribeEvent
        static void setupClient(@Nonnull FMLClientSetupEvent event) {
            event.enqueueWork(() -> {
                UIManagerForge.initializeRenderer();
                Config.CLIENT.mLastWindowMode.apply();
            });
            CrashReportCallables.registerCrashCallable((String)"Fragments", () -> {
                FragmentController fragments = UIManager.getInstance().getFragmentController();
                StringBuilder builder = new StringBuilder();
                if (fragments != null) {
                    try (PrintWriter pw = new PrintWriter((Writer)new StringBuilderWriter(builder));){
                        fragments.getFragmentManager().dump("", null, pw, new String[0]);
                    }
                }
                return builder.toString();
            }, () -> UIManager.getInstance().getFragmentController() != null);
            if (((Boolean)Config.CLIENT.mUseNewGuiScale.get()).booleanValue()) {
                OptionInstance newGuiScale = new OptionInstance("options.guiScale", OptionInstance.noTooltip(), (caption, value) -> {
                    int r = MuiModApi.calcGuiScales();
                    if (value == 0) {
                        int auto = r >> 4 & 0xF;
                        return Options.genericValueLabel((Component)caption, (Component)Component.translatable((String)"options.guiScale.auto").append((Component)Component.literal((String)(" (" + auto + ")"))));
                    }
                    MutableComponent valueComponent = Component.literal((String)value.toString());
                    int min = r >> 8 & 0xF;
                    int max = r & 0xF;
                    if (value < min || value > max) {
                        MutableComponent hint = value < min ? Component.literal((String)(" (<" + min + ")")) : Component.literal((String)(" (>" + max + ")"));
                        valueComponent.append((Component)hint);
                        valueComponent.withStyle(ChatFormatting.RED);
                    }
                    return Options.genericValueLabel((Component)caption, (Component)valueComponent);
                }, (OptionInstance.ValueSet)new GuiScaleValueSet(), (Object)0, value -> Minecraft.getInstance().tell(() -> {
                    Minecraft minecraft = Minecraft.getInstance();
                    if ((int)minecraft.getWindow().getGuiScale() != minecraft.getWindow().calculateScale(value.intValue(), false)) {
                        minecraft.resizeDisplay();
                    }
                }));
                Options options = Minecraft.getInstance().options;
                newGuiScale.set((Object)((Integer)options.guiScale().get()));
                ((AccessOptions)options).setGuiScale((OptionInstance<Integer>)newGuiScale);
                if (ModernUIMod.isOptiFineLoaded()) {
                    OptiFineIntegration.setGuiScale((OptionInstance<Integer>)newGuiScale);
                    ModernUIMod.LOGGER.debug(ModernUIMod.MARKER, "Override OptiFine Gui Scale");
                }
            }
        }

        @SubscribeEvent
        static void onRegisterMenuScreens(@Nonnull RegisterMenuScreensEvent event) {
            if (ModernUIMod.sDevelopment) {
                event.register((MenuType)MuiRegistries.TEST_MENU.get(), MenuScreenFactory.create(menu -> new TestPauseFragment()));
            }
        }

        @SubscribeEvent
        static void onRegisterShaders(@Nonnull RegisterShadersEvent event) {
            try {
                event.registerShader(new ShaderInstance(event.getResourceProvider(), ModernUIMod.location("rendertype_modern_tooltip"), DefaultVertexFormat.POSITION), GuiRenderType::setShaderTooltip);
            }
            catch (IOException e) {
                ModernUIMod.LOGGER.error(ModernUIMod.MARKER, "Bad tooltip shader", (Throwable)e);
            }
            try {
                event.registerShader(new ShaderInstance(event.getResourceProvider(), ModernUIMod.location("rendertype_round_rect"), DefaultVertexFormat.POSITION_COLOR), GuiRenderType::setShaderRoundRect);
            }
            catch (IOException e) {
                ModernUIMod.LOGGER.error(ModernUIMod.MARKER, "Bad round rect shader", (Throwable)e);
            }
        }

        static {
            boolean bl = $assertionsDisabled = !Registration.class.desiredAssertionStatus();
            if (!$assertionsDisabled && !FMLEnvironment.dist.isClient()) {
                throw new AssertionError();
            }
        }

        static class GuiScaleValueSet
        implements OptionInstance.IntRangeBase,
        OptionInstance.SliderableOrCyclableValueSet<Integer> {
            GuiScaleValueSet() {
            }

            public int minInclusive() {
                return 0;
            }

            public int maxInclusive() {
                return 8;
            }

            @Nonnull
            public Integer fromSliderValue(double progress) {
                return Math.toIntExact(Math.round(Mth.map((double)progress, (double)0.0, (double)1.0, (double)this.minInclusive(), (double)this.maxInclusive())));
            }

            @Nonnull
            public Optional<Integer> validateValue(@Nonnull Integer value) {
                return Optional.of(Mth.clamp((int)value, (int)this.minInclusive(), (int)this.maxInclusive()));
            }

            @Nonnull
            public Codec<Integer> codec() {
                return ExtraCodecs.validate((Codec)Codec.INT, value -> {
                    int max = this.maxInclusive() + 1;
                    if (value.compareTo(this.minInclusive()) >= 0 && value.compareTo(max) <= 0) {
                        return DataResult.success((Object)value);
                    }
                    return DataResult.error(() -> "Value " + value + " outside of range [" + this.minInclusive() + ":" + max + "]", (Object)value);
                });
            }

            @Nonnull
            public CycleButton.ValueListSupplier<Integer> valueListSupplier() {
                return CycleButton.ValueListSupplier.create(IntStream.range(this.minInclusive(), this.maxInclusive() + 1).boxed().toList());
            }

            public boolean createCycleButton() {
                return false;
            }
        }
    }
}

