/*
 * Decompiled with CFR 0.152.
 */
package icyllis.modernui.mc.neoforge;

import com.ibm.icu.text.DateFormat;
import com.ibm.icu.text.SimpleDateFormat;
import icyllis.modernui.animation.Animator;
import icyllis.modernui.animation.AnimatorListener;
import icyllis.modernui.animation.LayoutTransition;
import icyllis.modernui.animation.ObjectAnimator;
import icyllis.modernui.animation.TimeInterpolator;
import icyllis.modernui.annotation.NonNull;
import icyllis.modernui.core.Context;
import icyllis.modernui.fragment.Fragment;
import icyllis.modernui.graphics.Canvas;
import icyllis.modernui.graphics.Color;
import icyllis.modernui.graphics.Image;
import icyllis.modernui.graphics.Paint;
import icyllis.modernui.graphics.Rect;
import icyllis.modernui.graphics.drawable.Drawable;
import icyllis.modernui.graphics.drawable.ShapeDrawable;
import icyllis.modernui.mc.ExtendedGuiGraphics;
import icyllis.modernui.mc.MinecraftSurfaceView;
import icyllis.modernui.text.SpannableString;
import icyllis.modernui.text.style.ForegroundColorSpan;
import icyllis.modernui.util.DataSet;
import icyllis.modernui.util.FloatProperty;
import icyllis.modernui.util.IntProperty;
import icyllis.modernui.view.LayoutInflater;
import icyllis.modernui.view.View;
import icyllis.modernui.view.ViewGroup;
import icyllis.modernui.widget.EditText;
import icyllis.modernui.widget.FrameLayout;
import icyllis.modernui.widget.LinearLayout;
import icyllis.modernui.widget.Toast;
import java.util.Date;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;

public class TestPauseFragment
extends Fragment {
    public static final int NETWORK_COLOR = -14066038;
    private Image mButtonIcon;

    @Override
    @Nullable
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable DataSet savedInstanceState) {
        LinearLayout content = new LinearLayout(this.getContext());
        content.setOrientation(1);
        LinearLayout navigation = new LinearLayout(this.getContext());
        navigation.setOrientation(0);
        navigation.setHorizontalGravity(1);
        navigation.setLayoutTransition(new LayoutTransition());
        if (this.mButtonIcon == null) {
            this.mButtonIcon = Image.create("modernui", "gui/gui_icon.png");
        }
        for (int i = 0; i < 8; ++i) {
            NavigationButton button = new NavigationButton(this.getContext(), this.mButtonIcon, i * 32);
            LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(navigation.dp(32.0f), navigation.dp(32.0f));
            button.setClickable(true);
            params.setMarginsRelative(i == 7 ? 26 : 2, 2, 2, 6);
            if (i == 0 || i == 7) {
                navigation.addView((View)button, params);
            } else {
                int index = i;
                content.postDelayed(() -> navigation.addView((View)button, index, params), i * 50);
            }
            if (i == 2) {
                button.setOnClickListener(__ -> {
                    DateFormat dateFormat = SimpleDateFormat.getDateInstance((int)0, (Locale)Locale.CHINA);
                    Toast.makeText(__.getContext(), "Hello, Toast! " + dateFormat.format(new Date()), 1).show();
                });
            }
            if (i != 3) continue;
            button.setOnClickListener(__ -> {
                String s = "Your request was rejected by the server.";
                SpannableString text = new SpannableString(s);
                text.setSpan(new ForegroundColorSpan(-3205867), 0, s.length(), 33);
                Toast.makeText(__.getContext(), text, 0).show();
            });
        }
        content.addView((View)navigation, new LinearLayout.LayoutParams(-1, -2));
        LinearLayout tab = new LinearLayout(this.getContext());
        tab.setOrientation(1);
        tab.setLayoutTransition(new LayoutTransition());
        ShapeDrawable tabBackground = new ShapeDrawable();
        tabBackground.setCornerRadius(tab.dp(16.0f));
        tabBackground.setColor(-1275068416);
        tabBackground.setStroke(tab.dp(4.0f), -14066038);
        tab.setBackground(tabBackground);
        for (int i = 0; i < 3; ++i) {
            EditText v = new EditText(this.getContext());
            v.setText(switch (i) {
                case 0 -> "Flux Point";
                case 1 -> "0";
                default -> "800000";
            });
            v.setHint(switch (i) {
                case 0 -> "Flux Point";
                case 1 -> "Priority";
                default -> "Transfer Limit";
            });
            v.setSingleLine();
            int dp3 = v.dp(3.0f);
            ShapeDrawable background = new ShapeDrawable();
            background.setCornerRadius(dp3);
            background.setStroke(dp3, -14066038);
            v.setBackground(background);
            v.setPadding(dp3, 1, dp3, 1);
            v.setTextSize(16.0f);
            v.setCompoundDrawablesRelativeWithIntrinsicBounds(new TextFieldStart(v, this.mButtonIcon, ((i + 1) % 3 + 1) * 64), null, null, null);
            v.setTextAlignment(5);
            LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(-1, -2);
            params.setMargins(navigation.dp(20.0f), navigation.dp(i == 0 ? 50.0f : 2.0f), navigation.dp(20.0f), navigation.dp(2.0f));
            content.postDelayed(() -> tab.addView((View)v, params), (i + 1) * 100);
        }
        ConnectorView v = new ConnectorView(this.getContext(), this.mButtonIcon);
        LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(-1, -1);
        params.setMargins(navigation.dp(8.0f), navigation.dp(2.0f), navigation.dp(8.0f), navigation.dp(8.0f));
        content.postDelayed(() -> tab.addView((View)v, params), 400L);
        int tabSize = navigation.dp(340.0f);
        content.addView((View)tab, new LinearLayout.LayoutParams(tabSize, tabSize));
        content.setLayoutParams(new FrameLayout.LayoutParams(-2, -2, 17));
        return content;
    }

    private static class NavigationButton
    extends View {
        private final Image mImage;
        private final int mSrcLeft;

        public NavigationButton(Context context, Image image, int srcLeft) {
            super(context);
            this.mImage = image;
            this.mSrcLeft = srcLeft;
        }

        @Override
        protected void onDraw(@Nonnull Canvas canvas) {
            Paint paint = Paint.obtain();
            if (!this.isHovered()) {
                paint.setRGBA(192, 192, 192, 255);
            }
            canvas.drawImage(this.mImage, this.mSrcLeft, 352.0f, this.mSrcLeft + 32, 384.0f, 0.0f, 0.0f, this.getWidth(), this.getHeight(), paint);
            paint.recycle();
        }

        @Override
        public void onHoverChanged(boolean hovered) {
            super.onHoverChanged(hovered);
            this.invalidate();
        }
    }

    private static class TextFieldStart
    extends Drawable {
        private final Image mImage;
        private final int mSrcLeft;
        private final int mSize;

        public TextFieldStart(View view, Image image, int srcLeft) {
            this.mImage = image;
            this.mSrcLeft = srcLeft;
            this.mSize = view.dp(24.0f);
        }

        @Override
        public void draw(@Nonnull Canvas canvas) {
            Rect b = this.getBounds();
            canvas.drawImage(this.mImage, this.mSrcLeft, 192.0f, this.mSrcLeft + 64, 256.0f, b.left, b.top, b.right, b.bottom, null);
        }

        @Override
        public int getIntrinsicWidth() {
            return this.mSize;
        }

        @Override
        public int getIntrinsicHeight() {
            return this.mSize;
        }

        @Override
        public boolean getPadding(@Nonnull Rect padding) {
            int h = Math.round((float)this.mSize / 4.0f);
            int v = Math.round((float)this.mSize / 6.0f);
            padding.set(h, v, h, v);
            return true;
        }
    }

    private static class ConnectorView
    extends FrameLayout {
        private final Image mImage;
        private final int mSize;
        private float mRodLength;
        private final Paint mBoxPaint = new Paint();
        private final ObjectAnimator mRodAnimator;
        private final ObjectAnimator mBoxAnimator;
        private final MinecraftSurfaceView mItemView;
        private final ItemStack mItem = Items.DIAMOND_BLOCK.getDefaultInstance();

        public ConnectorView(Context context, Image image) {
            super(context);
            this.mImage = image;
            this.mSize = this.dp(32.0f);
            this.mRodAnimator = ObjectAnimator.ofFloat(this, new FloatProperty<ConnectorView>("rodLength"){

                @Override
                public void setValue(@Nonnull ConnectorView object, float value) {
                    object.mRodLength = value;
                    this.invalidate();
                }

                @Override
                public Float get(@Nonnull ConnectorView object) {
                    return Float.valueOf(object.mRodLength);
                }
            }, 0.0f, this.dp(32.0f));
            this.mRodAnimator.setInterpolator(TimeInterpolator.DECELERATE);
            this.mRodAnimator.setDuration(400L);
            this.mRodAnimator.addListener(new AnimatorListener(){

                @Override
                public void onAnimationEnd(@Nonnull Animator animation) {
                    mBoxAnimator.start();
                }
            });
            this.mBoxAnimator = ObjectAnimator.ofInt(this.mBoxPaint, new IntProperty<Paint>("boxAlpha"){

                @Override
                public void setValue(@Nonnull Paint object, int value) {
                    object.setAlpha(value);
                    if (value > 0) {
                        mItemView.setVisibility(0);
                    }
                    this.invalidate();
                }

                @Override
                public Integer get(@Nonnull Paint object) {
                    return object.getAlpha();
                }
            }, 0, 128);
            this.mRodAnimator.setInterpolator(TimeInterpolator.LINEAR);
            this.mBoxAnimator.setDuration(400L);
            this.mBoxPaint.setRGBA(64, 64, 64, 0);
            this.mItemView = new MinecraftSurfaceView(context);
            this.mItemView.setVisibility(4);
            this.mItemView.setRenderer(new MinecraftSurfaceView.Renderer(){
                int mSurfaceWidth;
                int mSurfaceHeight;

                @Override
                public void onSurfaceChanged(int width, int height) {
                    this.mSurfaceWidth = width;
                    this.mSurfaceHeight = height;
                }

                @Override
                public void onDraw(@Nonnull GuiGraphics gr, int mouseX, int mouseY, float deltaTick, double guiScale, float alpha) {
                    int guiScaledWidth = (int)((double)this.mSurfaceWidth / guiScale);
                    int guiScaledHeight = (int)((double)this.mSurfaceHeight / guiScale);
                    int itemX = guiScaledWidth / 2 - 8;
                    int itemY = Math.round((float)guiScaledHeight * 0.120625f) - 8;
                    ExtendedGuiGraphics exGr = new ExtendedGuiGraphics(gr);
                    exGr.setGradient(ExtendedGuiGraphics.Orientation.TL_BR, Color.argb(128, 45, 212, 191), Color.argb(255, 14, 165, 233));
                    exGr.fillRoundRect(itemX - 1, itemY - 1, itemX + 17, itemY + 17, 3.0f);
                    gr.drawString(Minecraft.getInstance().font, "A", itemX, itemY, -1);
                    gr.renderItem(mItem, itemX, itemY);
                }
            });
            FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(this.mSize * 4, this.mSize * 5, 17);
            this.addView((View)this.mItemView, params);
        }

        @Override
        protected void onAttachedToWindow() {
            super.onAttachedToWindow();
            this.mRodAnimator.start();
        }

        @Override
        protected void onDraw(@Nonnull Canvas canvas) {
            Paint paint = Paint.obtain();
            paint.setColor(-14066038);
            paint.setAlpha(192);
            float centerX = (float)this.getWidth() / 2.0f;
            float centerY = (float)this.getHeight() / 2.0f;
            int boxAlpha = this.mBoxPaint.getAlpha();
            float px1l = centerX - 0.234375f * (float)this.mSize;
            float py1 = centerY + 0.125f * (float)this.mSize;
            canvas.save();
            canvas.rotate(22.5f, px1l, py1);
            canvas.drawLine(px1l, py1, px1l - this.mRodLength * 2.0f, py1, (float)this.mSize / 8.0f, paint);
            canvas.restore();
            if (boxAlpha > 0) {
                canvas.drawRect(px1l - (float)this.mSize * 2.9f, py1 - (float)this.mSize * 1.1f, px1l - (float)this.mSize * 1.9f, py1 - (float)this.mSize * 0.1f, this.mBoxPaint);
            }
            float px1r = centerX + 0.234375f * (float)this.mSize;
            canvas.save();
            canvas.rotate(-22.5f, px1r, py1);
            canvas.drawLine(px1r, py1, px1r + this.mRodLength * 2.0f, py1, (float)this.mSize / 8.0f, paint);
            canvas.restore();
            if (boxAlpha > 0) {
                canvas.drawRect(px1r + (float)this.mSize * 1.9f, py1 - (float)this.mSize * 1.1f, px1r + (float)this.mSize * 2.9f, py1 - (float)this.mSize * 0.1f, this.mBoxPaint);
            }
            float py2 = centerY + 0.296875f * (float)this.mSize;
            canvas.drawLine(centerX, py2, centerX, py2 + this.mRodLength, (float)this.mSize / 8.0f, paint);
            if (boxAlpha > 0) {
                canvas.drawRect(centerX - (float)this.mSize * 0.5f, py2 + (float)this.mSize * 1.1f, centerX + (float)this.mSize * 0.5f, py2 + (float)this.mSize * 2.1f, this.mBoxPaint);
            }
            float offset = (float)this.mSize / 2.0f;
            canvas.drawImage(this.mImage, 0.0f, 192.0f, 64.0f, 256.0f, centerX - offset, centerY - offset, centerX + offset, centerY + offset, null);
            canvas.save();
            canvas.rotate(-22.5f, px1l, py1);
            canvas.drawLine(px1l, py1, px1l - this.mRodLength * 2.0f, py1, (float)this.mSize / 8.0f, paint);
            canvas.restore();
            if (boxAlpha > 0) {
                canvas.drawRect(px1l - (float)this.mSize * 2.9f, py1 + (float)this.mSize * 0.1f, px1l - (float)this.mSize * 1.9f, py1 + (float)this.mSize * 1.1f, this.mBoxPaint);
            }
            canvas.save();
            canvas.rotate(22.5f, px1r, py1);
            canvas.drawLine(px1r, py1, px1r + this.mRodLength * 2.0f, py1, (float)this.mSize / 8.0f, paint);
            canvas.restore();
            if (boxAlpha > 0) {
                canvas.drawRect(px1r + (float)this.mSize * 1.9f, py1 + (float)this.mSize * 0.1f, px1r + (float)this.mSize * 2.9f, py1 + (float)this.mSize * 1.1f, this.mBoxPaint);
            }
            py2 = centerY - 0.296875f * (float)this.mSize;
            canvas.drawLine(centerX, py2, centerX, py2 - this.mRodLength, (float)this.mSize / 8.0f, paint);
            if (boxAlpha > 0) {
                canvas.drawRect(centerX - (float)this.mSize * 0.5f, py2 - (float)this.mSize * 2.1f, centerX + (float)this.mSize * 0.5f, py2 - (float)this.mSize * 1.1f, this.mBoxPaint);
            }
            paint.recycle();
        }
    }
}

