/*
 * Decompiled with CFR 0.152.
 */
package icyllis.modernui.mc.text;

import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.network.chat.Style;

public class CharacterStyle {
    public static final int NORMAL = 0;
    public static final int BOLD_MASK = 0x1000000;
    public static final int ITALIC_MASK = 0x2000000;
    public static final int FONT_STYLE_MASK = 0x3000000;
    public static final int UNDERLINE_MASK = 0x4000000;
    public static final int STRIKETHROUGH_MASK = 0x8000000;
    public static final int EFFECT_MASK = 0xC000000;
    public static final int OBFUSCATED_MASK = 0x10000000;
    public static final int LAYOUT_MASK = 0x1F000000;
    public static final int COLOR_EMOJI_REPLACEMENT = 0x20000000;
    public static final int BITMAP_REPLACEMENT = 0x40000000;
    public static final int ANY_BITMAP_REPLACEMENT = 0x60000000;
    public static final int COLOR_MASK = 0xFFFFFF;
    public static final int IMPLICIT_COLOR_MASK = Integer.MIN_VALUE;
    public static final int FULL_COLOR_MASK = -2130706433;
    public final int mStringIndex;
    public final int mStripIndex;
    private final int mFlags;

    @Deprecated
    public CharacterStyle(int stringIndex, int stripIndex, Style style) {
        this.mStringIndex = stringIndex;
        this.mStripIndex = stripIndex;
        this.mFlags = CharacterStyle.flatten(style);
    }

    public static int flatten(@Nonnull Style style) {
        int v = 0;
        v = style.getColor() == null ? (v |= Integer.MIN_VALUE) : (v |= style.getColor().getValue() & 0xFFFFFF);
        if (style.isBold()) {
            v |= 0x1000000;
        }
        if (style.isItalic()) {
            v |= 0x2000000;
        }
        if (style.isUnderlined()) {
            v |= 0x4000000;
        }
        if (style.isStrikethrough()) {
            v |= 0x8000000;
        }
        if (style.isObfuscated()) {
            v |= 0x10000000;
        }
        return v;
    }

    public static boolean equalsForTextLayout(@Nonnull Style a, @Nonnull Style b) {
        return a == b || a.isBold() == b.isBold() && a.isItalic() == b.isItalic() && a.isUnderlined() == b.isUnderlined() && a.isStrikethrough() == b.isStrikethrough() && a.isObfuscated() == b.isObfuscated() && Objects.equals(a.getColor(), b.getColor()) && Objects.equals(a.getFont(), b.getFont());
    }

    public int getFullColor() {
        return this.mFlags & 0x80FFFFFF;
    }

    public boolean isBold() {
        return (this.mFlags & 0x1000000) != 0;
    }

    public boolean isItalic() {
        return (this.mFlags & 0x2000000) != 0;
    }

    public int getFontStyle() {
        return this.mFlags & 0x3000000;
    }

    public boolean isUnderlined() {
        return (this.mFlags & 0x4000000) != 0;
    }

    public boolean isStrikethrough() {
        return (this.mFlags & 0x8000000) != 0;
    }

    public int getEffect() {
        return this.mFlags & 0xC000000;
    }

    public boolean isObfuscated() {
        return (this.mFlags & 0x10000000) != 0;
    }

    public boolean isFormattingCode() {
        return false;
    }

    public boolean isMetricAffecting(@Nonnull CharacterStyle s) {
        return (this.mFlags & 0x3000000) != (s.mFlags & 0x3000000);
    }

    public boolean isLayoutAffecting(@Nonnull CharacterStyle s) {
        return (this.mFlags & 0x1F000000) != (s.mFlags & 0x1F000000);
    }

    public String toString() {
        return "CharacterStyle{stringIndex=" + this.mStringIndex + ",stripIndex=" + this.mStripIndex + ",flags=0x" + Integer.toHexString(this.mFlags) + "}";
    }
}

