/*
 * Decompiled with CFR 0.152.
 */
package icyllis.modernui.mc.text;

import icyllis.modernui.graphics.text.LineBreaker;
import icyllis.modernui.mc.MuiModApi;
import icyllis.modernui.mc.text.FormattedTextWrapper;
import icyllis.modernui.mc.text.TextLayout;
import icyllis.modernui.mc.text.TextLayoutEngine;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.Optional;
import java.util.function.BiConsumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.ComponentCollector;
import net.minecraft.client.StringSplitter;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.FormattedCharSink;
import net.minecraft.util.Unit;
import org.apache.commons.lang3.mutable.MutableObject;

public final class ModernStringSplitter
extends StringSplitter {
    private final TextLayoutEngine mEngine;
    private static final int NOWHERE = -1;

    public ModernStringSplitter(TextLayoutEngine engine, StringSplitter.WidthProvider widthProvider) {
        super(widthProvider);
        this.mEngine = engine;
    }

    public float stringWidth(@Nullable String text) {
        return this.measureText(text);
    }

    public float stringWidth(@Nonnull FormattedText text) {
        return this.measureText(text);
    }

    public float stringWidth(@Nonnull FormattedCharSequence text) {
        return this.measureText(text);
    }

    public float measureText(@Nullable String text) {
        if (text == null) {
            return 0.0f;
        }
        return this.mEngine.lookupVanillaLayout(text).getTotalAdvance();
    }

    public float measureText(@Nonnull FormattedText text) {
        return this.mEngine.lookupFormattedLayout(text).getTotalAdvance();
    }

    public float measureText(@Nonnull FormattedCharSequence text) {
        return this.mEngine.lookupFormattedLayout(text).getTotalAdvance();
    }

    public int plainIndexAtWidth(@Nonnull String text, int width, @Nonnull Style style) {
        return this.indexByWidth(text, width, style);
    }

    @Nonnull
    public String plainHeadByWidth(@Nonnull String text, int width, @Nonnull Style style) {
        return this.headByWidth(text, (float)width, style);
    }

    @Nonnull
    public String plainTailByWidth(@Nonnull String text, int width, @Nonnull Style style) {
        return this.tailByWidth(text, width, style);
    }

    public int formattedIndexByWidth(@Nonnull String text, int width, @Nonnull Style style) {
        return this.indexByWidth(text, width, style);
    }

    @Nullable
    public Style componentStyleAtWidth(@Nonnull FormattedText text, int width) {
        return this.styleAtWidth(text, (float)width);
    }

    @Nullable
    public Style componentStyleAtWidth(@Nonnull FormattedCharSequence text, int width) {
        return this.styleAtWidth(text, (float)width);
    }

    @Nonnull
    public String formattedHeadByWidth(@Nonnull String text, int width, @Nonnull Style style) {
        return this.headByWidth(text, (float)width, style);
    }

    @Nonnull
    public FormattedText headByWidth(@Nonnull FormattedText text, int width, @Nonnull Style style) {
        return this.headByWidth(text, (float)width, style);
    }

    public static int breakText(@Nonnull TextLayout layout, boolean forwards, float width) {
        return ModernStringSplitter.breakText(layout, forwards, width, true);
    }

    public static int breakText(@Nonnull TextLayout layout, boolean forwards, float width, boolean trimSpace) {
        int i;
        int limit = layout.getCharCount();
        if (forwards) {
            int i2;
            for (i2 = 0; i2 < limit && !((width -= layout.getAdvances()[i2]) < 0.0f); ++i2) {
            }
            while (i2 > 0 && trimSpace && layout.getTextBuf()[i2 - 1] == ' ') {
                --i2;
            }
            return i2;
        }
        for (i = limit - 1; i >= 0 && !((width -= layout.getAdvances()[i]) < 0.0f); --i) {
        }
        while (i < limit - 1 && (trimSpace && layout.getTextBuf()[i + 1] == ' ' || layout.getAdvances()[i + 1] == 0.0f)) {
            ++i;
        }
        return i + 1;
    }

    public int breakText(@Nonnull String text, float width, @Nonnull Style style, boolean forwards) {
        if (text.isEmpty() || width < 0.0f) {
            return 0;
        }
        TextLayout layout = this.mEngine.lookupVanillaLayout(text, style, 1);
        if (width >= layout.getTotalAdvance()) {
            return forwards ? text.length() : 0;
        }
        int breakIndex = ModernStringSplitter.breakText(layout, forwards, width);
        int length = text.length();
        for (int j = 0; j < length && j != breakIndex; ++j) {
            if (text.charAt(j) != '\u00a7') continue;
            ++j;
            breakIndex += 2;
        }
        return breakIndex;
    }

    public int indexByWidth(@Nonnull String text, float width, @Nonnull Style style) {
        return this.breakText(text, width, style, true);
    }

    @Nonnull
    public String headByWidth(@Nonnull String text, float width, @Nonnull Style style) {
        return text.substring(0, this.indexByWidth(text, width, style));
    }

    @Nonnull
    public String tailByWidth(@Nonnull String text, float width, @Nonnull Style style) {
        return text.substring(this.breakText(text, width, style, false));
    }

    @Nullable
    public Style styleAtWidth(@Nonnull FormattedText text, float width) {
        if (text == CommonComponents.EMPTY || text == FormattedText.EMPTY || width < 0.0f) {
            return null;
        }
        TextLayout layout = this.mEngine.lookupFormattedLayout(text, Style.EMPTY, 1);
        if (width >= layout.getTotalAdvance()) {
            return null;
        }
        final int breakIndex = ModernStringSplitter.breakText(layout, true, width, false);
        return text.visit((FormattedText.StyledContentConsumer)new FormattedText.StyledContentConsumer<Style>(){
            private int mStripIndex;

            @Nonnull
            public Optional<Style> accept(@Nonnull Style style, @Nonnull String string) {
                int length = string.length();
                for (int i = 0; i < length; ++i) {
                    if (string.charAt(i) == '\u00a7') {
                        ++i;
                        continue;
                    }
                    if (++this.mStripIndex <= breakIndex) continue;
                    return Optional.of(style);
                }
                return Optional.empty();
            }
        }, Style.EMPTY).orElse(null);
    }

    @Nullable
    public Style styleAtWidth(@Nonnull FormattedCharSequence text, float width) {
        if (text == FormattedCharSequence.EMPTY || width < 0.0f) {
            return null;
        }
        if (text instanceof FormattedTextWrapper) {
            return this.styleAtWidth(((FormattedTextWrapper)text).mText, width);
        }
        TextLayout layout = this.mEngine.lookupFormattedLayout(text, 1);
        if (width >= layout.getTotalAdvance()) {
            return null;
        }
        final int breakIndex = ModernStringSplitter.breakText(layout, true, width, false);
        final MutableObject result = new MutableObject();
        text.accept(new FormattedCharSink(){
            private int mStripIndex;

            public boolean accept(int index, @Nonnull Style style, int codePoint) {
                if ((this.mStripIndex += Character.charCount(codePoint)) > breakIndex) {
                    result.setValue((Object)style);
                    return false;
                }
                return true;
            }
        });
        return (Style)result.getValue();
    }

    @Nonnull
    public FormattedText headByWidth(@Nonnull FormattedText text, float width, @Nonnull Style style) {
        if (text == CommonComponents.EMPTY || text == FormattedText.EMPTY || width < 0.0f) {
            return FormattedText.EMPTY;
        }
        TextLayout layout = this.mEngine.lookupFormattedLayout(text, style, 1);
        if (width >= layout.getTotalAdvance()) {
            return text;
        }
        final int breakIndex = ModernStringSplitter.breakText(layout, true, width);
        return text.visit((FormattedText.StyledContentConsumer)new FormattedText.StyledContentConsumer<FormattedText>(){
            private final ComponentCollector mCollector = new ComponentCollector();
            private int mSegmentIndex;

            @Nonnull
            public Optional<FormattedText> accept(@Nonnull Style sty, @Nonnull String string) {
                int length = string.length();
                int stripIndex = 0;
                for (int i = 0; i < length; ++i) {
                    if (string.charAt(i) == '\u00a7') {
                        ++i;
                        continue;
                    }
                    if (this.mSegmentIndex + ++stripIndex <= breakIndex) continue;
                    String substring = string.substring(0, stripIndex);
                    if (!substring.isEmpty()) {
                        this.mCollector.append(FormattedText.of((String)substring, (Style)sty));
                    }
                    return Optional.of(this.mCollector.getResultOrEmpty());
                }
                if (length > 0) {
                    this.mCollector.append(FormattedText.of((String)string, (Style)sty));
                }
                this.mSegmentIndex += stripIndex;
                return Optional.empty();
            }
        }, style).orElse(text);
    }

    public void splitLines(@Nonnull String text, int width, @Nonnull Style style, @Deprecated boolean withEndSpace, @Nonnull StringSplitter.LinePosConsumer linePos) {
        this.computeLineBreaks(text, (float)width, style, linePos);
    }

    public void splitLines(@Nonnull FormattedText text, int width, @Nonnull Style style, @Nonnull BiConsumer<FormattedText, Boolean> consumer) {
        this.computeLineBreaks(text, (float)width, style, consumer);
    }

    public void computeLineBreaks(@Nonnull String text, float width, @Nonnull Style base, @Nonnull StringSplitter.LinePosConsumer consumer) {
        String remainder;
        if (text.isEmpty()) {
            consumer.accept(base, 0, 0);
            return;
        }
        width = Math.max(width, 0.0f);
        TextLayout layout = this.mEngine.lookupVanillaLayout(text, base, 5);
        char[] buf = layout.getTextBuf();
        if (width >= layout.getTotalAdvance()) {
            boolean hasLineFeed = false;
            int e = layout.getCharCount();
            for (int i = 0; i < e; ++i) {
                if (buf[i] != '\n') continue;
                hasLineFeed = true;
                break;
            }
            if (!hasLineFeed) {
                consumer.accept(base, 0, text.length());
                return;
            }
        }
        LineProcessor lineBreaker = new LineProcessor(width);
        int end = layout.getCharCount();
        int nextBoundaryIndex = 0;
        int paraStart = 0;
        while (paraStart < end) {
            int paraEnd = -1;
            for (int i = paraStart; i < end; ++i) {
                if (buf[i] != '\n') continue;
                paraEnd = i;
                break;
            }
            paraEnd = paraEnd < 0 ? end : ++paraEnd;
            nextBoundaryIndex = lineBreaker.process(layout, buf, paraStart, paraEnd, nextBoundaryIndex);
            paraStart = paraEnd;
        }
        IntList result = lineBreaker.mBreakPoints;
        int mStripIndex = 0;
        int mBreakOffsetIndex = 0;
        int mBreakPointOffset = result.getInt(mBreakOffsetIndex++);
        Style currStyle = base;
        Style lastStyle = base;
        int lastSubPos = 0;
        int e = text.length();
        for (int i = 0; i < e; ++i) {
            char c = text.charAt(i);
            if (c == '\u00a7') {
                ChatFormatting formatting;
                if (++i >= e || (formatting = MuiModApi.getFormattingByCode(text.charAt(i))) == null) continue;
                currStyle = formatting == ChatFormatting.RESET ? base : currStyle.applyLegacyFormat(formatting);
                continue;
            }
            if (++mStripIndex < mBreakPointOffset) continue;
            consumer.accept(lastStyle, lastSubPos, i + 1);
            lastSubPos = i + 1;
            lastStyle = currStyle;
            if (mBreakOffsetIndex >= result.size()) break;
            mBreakPointOffset = result.getInt(mBreakOffsetIndex++);
        }
        if (!(remainder = text.substring(lastSubPos)).isEmpty()) {
            consumer.accept(lastStyle, lastSubPos, text.length());
        }
    }

    public void computeLineBreaks(@Nonnull FormattedText text, float width, @Nonnull Style base, final @Nonnull BiConsumer<FormattedText, Boolean> consumer) {
        FormattedText remainder;
        if (text == CommonComponents.EMPTY || text == FormattedText.EMPTY) {
            consumer.accept(FormattedText.EMPTY, Boolean.FALSE);
            return;
        }
        width = Math.max(width, 0.0f);
        TextLayout layout = this.mEngine.lookupFormattedLayout(text, base, 5);
        char[] buf = layout.getTextBuf();
        if (width >= layout.getTotalAdvance()) {
            boolean hasLineFeed = false;
            int e = layout.getCharCount();
            for (int i = 0; i < e; ++i) {
                if (buf[i] != '\n') continue;
                hasLineFeed = true;
                break;
            }
            if (!hasLineFeed) {
                consumer.accept(text, Boolean.FALSE);
                return;
            }
        }
        LineProcessor lineBreaker = new LineProcessor(width);
        int end = layout.getCharCount();
        int nextBoundaryIndex = 0;
        int paraStart = 0;
        while (paraStart < end) {
            int paraEnd = -1;
            for (int i = paraStart; i < end; ++i) {
                if (buf[i] != '\n') continue;
                paraEnd = i;
                break;
            }
            paraEnd = paraEnd < 0 ? end : ++paraEnd;
            nextBoundaryIndex = lineBreaker.process(layout, buf, paraStart, paraEnd, nextBoundaryIndex);
            paraStart = paraEnd;
        }
        final IntList result = lineBreaker.mBreakPoints;
        class LineBreakVisitor
        implements FormattedText.StyledContentConsumer<Unit> {
            private ComponentCollector mCollector = new ComponentCollector();
            private int mStripIndex = 0;
            private int mBreakOffsetIndex = 0;
            private int mBreakPointOffset = result.getInt(this.mBreakOffsetIndex++);
            private boolean mNonNewPara = false;

            LineBreakVisitor() {
            }

            @Nonnull
            public Optional<Unit> accept(@Nonnull Style aStyle, @Nonnull String aText) {
                Style currStyle = aStyle;
                Style lastStyle = aStyle;
                int lastSubPos = 0;
                int e = aText.length();
                for (int i = 0; i < e; ++i) {
                    char c = aText.charAt(i);
                    if (c == '\u00a7') {
                        ChatFormatting formatting;
                        if (++i >= e || (formatting = MuiModApi.getFormattingByCode(aText.charAt(i))) == null) continue;
                        currStyle = formatting == ChatFormatting.RESET ? aStyle : currStyle.applyLegacyFormat(formatting);
                        continue;
                    }
                    if (++this.mStripIndex < this.mBreakPointOffset) continue;
                    String substring = aText.substring(lastSubPos, i + 1);
                    if (!substring.isEmpty()) {
                        this.mCollector.append(FormattedText.of((String)substring, (Style)lastStyle));
                    }
                    consumer.accept(this.mCollector.getResultOrEmpty(), this.mNonNewPara);
                    lastSubPos = i + 1;
                    lastStyle = currStyle;
                    this.mCollector = new ComponentCollector();
                    this.mBreakPointOffset = this.mBreakOffsetIndex >= result.size() ? Integer.MAX_VALUE : result.getInt(this.mBreakOffsetIndex++);
                    this.mNonNewPara = c != '\n';
                }
                String substring = aText.substring(lastSubPos);
                if (!substring.isEmpty()) {
                    this.mCollector.append(FormattedText.of((String)substring, (Style)lastStyle));
                }
                return Optional.empty();
            }
        }
        LineBreakVisitor visitor = new LineBreakVisitor();
        text.visit((FormattedText.StyledContentConsumer)visitor, base);
        FormattedText formattedText = remainder = visitor.mBreakPointOffset == Integer.MAX_VALUE ? visitor.mCollector.getResult() : visitor.mCollector.getResultOrEmpty();
        if (remainder != null) {
            consumer.accept(remainder, visitor.mNonNewPara);
        } else if (!visitor.mNonNewPara) {
            consumer.accept(FormattedText.EMPTY, Boolean.FALSE);
        }
    }

    public static class LineProcessor {
        private float mLineWidth;
        private float mCharsAdvance;
        private final float mLineWidthLimit;
        private int mPrevBoundaryOffset;
        private float mCharsAdvanceAtPrevBoundary;
        private final IntList mBreakPoints = new IntArrayList();

        public LineProcessor(float lineWidthLimit) {
            this.mLineWidthLimit = lineWidthLimit;
        }

        public int process(@Nonnull TextLayout layout, @Nonnull char[] buf, int start, int end, int nextBoundaryIndex) {
            this.mLineWidth = 0.0f;
            this.mCharsAdvance = 0.0f;
            this.mPrevBoundaryOffset = -1;
            this.mCharsAdvanceAtPrevBoundary = 0.0f;
            float[] advances = layout.getAdvances();
            int[] lineBoundaries = layout.getLineBoundaries();
            int nextLineBoundary = lineBoundaries[nextBoundaryIndex++];
            for (int i = start; i < end; ++i) {
                this.updateLineWidth(buf[i], advances[i]);
                if (i + 1 != nextLineBoundary) continue;
                this.processLineBreak(advances, i + 1);
                if (nextLineBoundary < end) {
                    nextLineBoundary = lineBoundaries[nextBoundaryIndex++];
                }
                if (nextLineBoundary <= end) continue;
                nextLineBoundary = end;
            }
            if (this.getPrevLineBreakOffset() != end && this.mPrevBoundaryOffset != -1) {
                this.breakLineAt(this.mPrevBoundaryOffset, 0.0f, 0.0f);
            }
            return nextBoundaryIndex;
        }

        private void processLineBreak(float[] advances, int offset) {
            while (this.mLineWidth > this.mLineWidthLimit) {
                int start = this.getPrevLineBreakOffset();
                if (this.tryLineBreak() || !this.doLineBreakWithGraphemeBounds(advances, start, offset)) continue;
                return;
            }
            this.mPrevBoundaryOffset = offset;
            this.mCharsAdvanceAtPrevBoundary = this.mCharsAdvance;
        }

        private boolean tryLineBreak() {
            if (this.mPrevBoundaryOffset == -1) {
                return false;
            }
            this.breakLineAt(this.mPrevBoundaryOffset, this.mLineWidth - this.mCharsAdvanceAtPrevBoundary, this.mCharsAdvance - this.mCharsAdvanceAtPrevBoundary);
            return true;
        }

        private boolean doLineBreakWithGraphemeBounds(float[] advances, int start, int end) {
            float width = advances[start];
            for (int i = start + 1; i < end; ++i) {
                float w = advances[i];
                if (w == 0.0f) continue;
                if (width + w > this.mLineWidthLimit) {
                    this.breakLineAt(i, this.mLineWidth - width, this.mCharsAdvance - width);
                    return false;
                }
                width += w;
            }
            this.breakLineAt(end, 0.0f, 0.0f);
            return true;
        }

        private void breakLineAt(int offset, float remainingNextLineWidth, float remainingNextCharsAdvance) {
            this.mBreakPoints.add(offset);
            this.mLineWidth = remainingNextLineWidth;
            this.mCharsAdvance = remainingNextCharsAdvance;
            this.mPrevBoundaryOffset = -1;
            this.mCharsAdvanceAtPrevBoundary = 0.0f;
        }

        private void updateLineWidth(char c, float adv) {
            this.mCharsAdvance += adv;
            if (!LineBreaker.isLineEndSpace(c)) {
                this.mLineWidth = this.mCharsAdvance;
            }
        }

        private int getPrevLineBreakOffset() {
            return this.mBreakPoints.isEmpty() ? 0 : this.mBreakPoints.getInt(this.mBreakPoints.size() - 1);
        }
    }

    public record LineComponent(String text, Style style) implements FormattedText
    {
        @Nonnull
        public <T> Optional<T> visit(@Nonnull FormattedText.ContentConsumer<T> consumer) {
            return consumer.accept(this.text);
        }

        @Nonnull
        public <T> Optional<T> visit(@Nonnull FormattedText.StyledContentConsumer<T> consumer, @Nonnull Style base) {
            return consumer.accept(this.style.applyTo(base), this.text);
        }
    }
}

