/*
 * Decompiled with CFR 0.152.
 */
package icyllis.modernui.mc.text;

import com.mojang.blaze3d.font.GlyphInfo;
import com.mojang.blaze3d.font.SheetGlyphInfo;
import icyllis.modernui.graphics.text.Font;
import icyllis.modernui.graphics.text.FontCollection;
import icyllis.modernui.graphics.text.FontFamily;
import icyllis.modernui.graphics.text.FontPaint;
import icyllis.modernui.graphics.text.OutlineFont;
import icyllis.modernui.mc.text.BitmapFont;
import icyllis.modernui.mc.text.GLBakedGlyph;
import icyllis.modernui.mc.text.GlyphManager;
import icyllis.modernui.mc.text.ModernTextRenderer;
import icyllis.modernui.mc.text.SpaceFont;
import icyllis.modernui.mc.text.TextLayoutProcessor;
import icyllis.modernui.mc.text.TextRenderType;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.function.Function;
import java.util.function.IntFunction;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.font.CodepointMap;
import net.minecraft.client.gui.font.FontSet;
import net.minecraft.client.gui.font.GlyphRenderTypes;
import net.minecraft.client.gui.font.glyphs.BakedGlyph;
import net.minecraft.client.gui.font.glyphs.EmptyGlyph;
import net.minecraft.client.gui.font.glyphs.SpecialGlyphs;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Unmodifiable;

public class StandardFontSet
extends FontSet {
    private @Unmodifiable List<FontFamily> mFamilies = Collections.emptyList();
    private CodepointMap<BakedGlyph> mGlyphs;
    private final IntFunction<BakedGlyph> mCacheGlyph = this::cacheGlyph;
    private CodepointMap<GlyphInfo> mGlyphInfos;
    private final IntFunction<GlyphInfo> mCacheGlyphInfo = this::cacheGlyphInfo;
    private float mResLevel = 2.0f;
    private final FontPaint mStandardPaint = new FontPaint();

    public StandardFontSet(@Nonnull TextureManager texMgr, @Nonnull ResourceLocation fontName) {
        super(texMgr, fontName);
        this.mStandardPaint.setFontStyle(0);
        this.mStandardPaint.setLocale(Locale.ROOT);
    }

    public void reload(@Nonnull FontCollection fontCollection, int newResLevel) {
        super.reload(Collections.emptyList());
        this.mFamilies = fontCollection.getFamilies();
        this.invalidateCache(newResLevel);
    }

    public void invalidateCache(int newResLevel) {
        if (this.mGlyphs != null) {
            this.mGlyphs.clear();
        }
        if (this.mGlyphInfos != null) {
            this.mGlyphInfos.clear();
        }
        int fontSize = TextLayoutProcessor.computeFontSize(newResLevel);
        this.mStandardPaint.setFontSize(fontSize);
        this.mStandardPaint.setAntiAlias(GlyphManager.sAntiAliasing);
        this.mStandardPaint.setLinearMetrics(GlyphManager.sFractionalMetrics);
        this.mResLevel = newResLevel;
    }

    @Nonnull
    private GlyphInfo cacheGlyphInfo(int codePoint) {
        for (FontFamily family : this.mFamilies) {
            OutlineFont outlineFont;
            if (!family.hasGlyph(codePoint)) continue;
            Font font = family.getClosestMatch(0);
            if (font instanceof BitmapFont) {
                BitmapFont bitmapFont = (BitmapFont)font;
                BitmapFont.Glyph glyph = bitmapFont.getGlyph(codePoint);
                if (glyph == null) continue;
                return glyph;
            }
            if (font instanceof SpaceFont) {
                SpaceFont spaceFont = (SpaceFont)font;
                float adv = spaceFont.getAdvance(codePoint);
                if (Float.isNaN(adv)) continue;
                return () -> adv;
            }
            if (!(font instanceof OutlineFont) || !(outlineFont = (OutlineFont)font).hasGlyph(codePoint, 0)) continue;
            char[] chars = Character.toChars(codePoint);
            float adv = outlineFont.doSimpleLayout(chars, 0, chars.length, this.mStandardPaint, null, null, 0.0f, 0.0f);
            return new StandardGlyphInfo((int)(adv / this.mResLevel + 0.95f));
        }
        return SpecialGlyphs.MISSING;
    }

    @Nonnull
    public GlyphInfo getGlyphInfo(int codePoint, boolean notFishy) {
        if (this.mGlyphInfos == null) {
            this.mGlyphInfos = new CodepointMap(GlyphInfo[]::new, x$0 -> new GlyphInfo[x$0][]);
        }
        return (GlyphInfo)this.mGlyphInfos.computeIfAbsent(codePoint, this.mCacheGlyphInfo);
    }

    @Nonnull
    private BakedGlyph cacheGlyph(int codePoint) {
        for (FontFamily family : this.mFamilies) {
            GLBakedGlyph glyph;
            if (!family.hasGlyph(codePoint)) continue;
            Font font = family.getClosestMatch(0);
            if (font instanceof BitmapFont) {
                BitmapFont bitmapFont = (BitmapFont)font;
                GLBakedGlyph glyph2 = GlyphManager.getInstance().lookupGlyph(bitmapFont, (int)this.mStandardPaint.getFontSize(), codePoint);
                if (glyph2 != null) {
                    float up = 10.0f + (float)glyph2.y / 8.0f;
                    float left = (float)glyph2.x / 8.0f;
                    float right = left + (float)glyph2.width / 8.0f;
                    float down = up + (float)glyph2.height / 8.0f;
                    return new StandardBakedGlyph(bitmapFont, glyph2.u1, glyph2.u2, glyph2.v1, glyph2.v2, left, right, up, down);
                }
                return EmptyGlyph.INSTANCE;
            }
            if (font instanceof SpaceFont) {
                return EmptyGlyph.INSTANCE;
            }
            if (!(font instanceof OutlineFont)) continue;
            OutlineFont outlineFont = (OutlineFont)font;
            char[] chars = Character.toChars(codePoint);
            IntArrayList glyphs = new IntArrayList(1);
            float adv = outlineFont.doSimpleLayout(chars, 0, chars.length, this.mStandardPaint, glyphs, null, 0.0f, 0.0f);
            if (glyphs.size() == 1 && glyphs.getInt(0) != 0 && (glyph = GlyphManager.getInstance().lookupGlyph(outlineFont, (int)this.mStandardPaint.getFontSize(), glyphs.getInt(0))) != null) {
                float up = 10.0f + (float)glyph.y / this.mResLevel;
                float left = (float)glyph.x / this.mResLevel;
                float right = left + (float)glyph.width / this.mResLevel;
                float down = up + (float)glyph.height / this.mResLevel;
                return new StandardBakedGlyph(null, glyph.u1, glyph.u2, glyph.v1, glyph.v2, left, right, up, down);
            }
            if (!(adv > 0.0f)) continue;
            return EmptyGlyph.INSTANCE;
        }
        return super.getGlyph(codePoint);
    }

    @Nonnull
    public BakedGlyph getGlyph(int codePoint) {
        if (this.mGlyphs == null) {
            this.mGlyphs = new CodepointMap(BakedGlyph[]::new, x$0 -> new BakedGlyph[x$0][]);
        }
        return (BakedGlyph)this.mGlyphs.computeIfAbsent(codePoint, this.mCacheGlyph);
    }

    public static class StandardGlyphInfo
    implements GlyphInfo {
        private final float mAdvance;

        public StandardGlyphInfo(int advance) {
            this.mAdvance = advance;
        }

        public float getAdvance() {
            return this.mAdvance;
        }

        public float getBoldOffset() {
            return 0.5f;
        }

        public float getShadowOffset() {
            return ModernTextRenderer.sShadowOffset;
        }

        @Nonnull
        public BakedGlyph bake(@Nonnull Function<SheetGlyphInfo, BakedGlyph> function) {
            return EmptyGlyph.INSTANCE;
        }
    }

    public static class StandardBakedGlyph
    extends BakedGlyph {
        private static final GlyphRenderTypes EMPTY_TYPES = GlyphRenderTypes.createForColorTexture((ResourceLocation)new ResourceLocation(""));
        @Nullable
        private final BitmapFont mBitmapFont;

        public StandardBakedGlyph(@Nullable BitmapFont bitmapFont, float u0, float u1, float v0, float v1, float left, float right, float up, float down) {
            super(EMPTY_TYPES, u0, u1, v0, v1, left, right, up, down);
            this.mBitmapFont = bitmapFont;
        }

        @Nonnull
        public RenderType renderType(@Nonnull Font.DisplayMode mode) {
            if (this.mBitmapFont != null) {
                return TextRenderType.getOrCreate(GlyphManager.getInstance().getCurrentTexture(this.mBitmapFont), mode, true);
            }
            return TextRenderType.getOrCreate(GlyphManager.getInstance().getFontTexture(), mode, false);
        }
    }
}

