/*
 * Decompiled with CFR 0.152.
 */
package icyllis.modernui.mc.text;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.ibm.icu.text.Bidi;
import com.mojang.blaze3d.font.SpaceProvider;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import icyllis.modernui.ModernUI;
import icyllis.modernui.annotation.RenderThread;
import icyllis.modernui.core.Core;
import icyllis.modernui.graphics.Bitmap;
import icyllis.modernui.graphics.text.Font;
import icyllis.modernui.graphics.text.FontCollection;
import icyllis.modernui.graphics.text.FontFamily;
import icyllis.modernui.mc.FontResourceManager;
import icyllis.modernui.mc.ModernUIClient;
import icyllis.modernui.mc.ModernUIMod;
import icyllis.modernui.mc.MuiModApi;
import icyllis.modernui.mc.text.BitmapFont;
import icyllis.modernui.mc.text.Color3i;
import icyllis.modernui.mc.text.EffectRenderType;
import icyllis.modernui.mc.text.FormattedLayoutKey;
import icyllis.modernui.mc.text.FormattedTextWrapper;
import icyllis.modernui.mc.text.GLBakedGlyph;
import icyllis.modernui.mc.text.GlyphManager;
import icyllis.modernui.mc.text.ModernStringSplitter;
import icyllis.modernui.mc.text.ModernTextRenderer;
import icyllis.modernui.mc.text.ReorderTextHandler;
import icyllis.modernui.mc.text.SpaceFont;
import icyllis.modernui.mc.text.StandardFontSet;
import icyllis.modernui.mc.text.TextLayout;
import icyllis.modernui.mc.text.TextLayoutProcessor;
import icyllis.modernui.mc.text.TextRenderType;
import icyllis.modernui.mc.text.VanillaLayoutKey;
import icyllis.modernui.mc.text.mixin.AccessFontManager;
import icyllis.modernui.text.TextDirectionHeuristic;
import icyllis.modernui.text.TextDirectionHeuristics;
import icyllis.modernui.text.TextUtils;
import icyllis.modernui.text.Typeface;
import icyllis.modernui.util.Pools;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.gui.font.FontManager;
import net.minecraft.client.gui.font.FontSet;
import net.minecraft.client.gui.font.providers.BitmapProvider;
import net.minecraft.client.gui.font.providers.GlyphProviderDefinition;
import net.minecraft.client.gui.font.providers.ProviderReferenceDefinition;
import net.minecraft.client.gui.font.providers.TrueTypeGlyphProviderDefinition;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.DependencySorter;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

public class TextLayoutEngine
extends FontResourceManager
implements MuiModApi.OnWindowResizeListener,
MuiModApi.OnDebugDumpListener {
    public static final Marker MARKER = MarkerManager.getMarker((String)"TextLayout");
    public static volatile boolean sFixedResolution = false;
    public static volatile int sTextDirection = 1;
    public static volatile int sCacheLifespan = 6;
    public static boolean sCurrentInWorldRendering;
    public static volatile boolean sUseTextShadersInWorld;
    public static volatile boolean sRawUseTextShadersInWorld;
    public static final ResourceLocation SANS_SERIF;
    public static final ResourceLocation SERIF;
    public static final ResourceLocation MONOSPACED;
    private static final ResourceLocation INTERNAL_DEFAULT;
    private final GlyphManager mGlyphManager;
    public static final int COMPUTE_ADVANCES = 1;
    public static final int COMPUTE_LINE_BOUNDARIES = 4;
    public static final int DEFAULT_FONT_BEHAVIOR_IGNORE_ALL = 0;
    public static final int DEFAULT_FONT_BEHAVIOR_KEEP_ASCII = 1;
    public static final int DEFAULT_FONT_BEHAVIOR_KEEP_OTHER = 2;
    public static final int DEFAULT_FONT_BEHAVIOR_KEEP_ALL = 3;
    public static final int DEFAULT_FONT_BEHAVIOR_ONLY_INCLUDE = 4;
    public static final int DEFAULT_FONT_BEHAVIOR_ONLY_EXCLUDE = 5;
    public static volatile int sDefaultFontBehavior;
    public static volatile List<? extends String> sDefaultFontRuleSet;
    public static volatile boolean sUseComponentCache;
    public static volatile boolean sAllowAsyncLayout;
    private final VanillaLayoutKey mVanillaLookupKey = new VanillaLayoutKey();
    private Map<VanillaLayoutKey, TextLayout> mVanillaCache = new HashMap<VanillaLayoutKey, TextLayout>();
    private Map<MutableComponent, TextLayout> mComponentCache = new HashMap<MutableComponent, TextLayout>();
    private final FormattedLayoutKey.Lookup mFormattedLayoutKey = new FormattedLayoutKey.Lookup();
    private Map<FormattedLayoutKey, TextLayout> mFormattedCache = new HashMap<FormattedLayoutKey, TextLayout>();
    private final TextLayoutProcessor mProcessor = new TextLayoutProcessor(this);
    private final Pools.Pool<TextLayoutProcessor> mProcessorPool = Pools.newSynchronizedPool(3);
    private final HashMap<ResourceLocation, FontCollection> mFontCollections = new HashMap();
    private FontCollection mRawDefaultFontCollection;
    private final ConcurrentHashMap<ResourceLocation, FontCollection> mRegisteredFonts = new ConcurrentHashMap();
    public static final int DEFAULT_MIN_PIXEL_DENSITY_FOR_SDF = 4;
    public static volatile int sMinPixelDensityForSDF;
    private volatile int mResLevel = 2;
    private TextDirectionHeuristic mTextDirectionHeuristic = TextDirectionHeuristics.FIRSTSTRONG_LTR;
    private FontManager mVanillaFontManager;
    private final ModernTextRenderer mTextRenderer;
    private final ModernStringSplitter mStringSplitter;
    private Boolean mForceUnicodeFont;
    private int mTimer;

    public TextLayoutEngine() {
        this.mGlyphManager = GlyphManager.getInstance();
        this.mGlyphManager.addAtlasInvalidationCallback(invalidationInfo -> {
            if (invalidationInfo.resize()) {
                this.invalidateStrikeCache();
            } else {
                this.reload();
            }
        });
        this.mTextRenderer = new ModernTextRenderer(this);
        this.mStringSplitter = new ModernStringSplitter(this, (ch, style) -> {
            throw new UnsupportedOperationException("Modern Text Engine");
        });
        ModernUI.LOGGER.info(ModernUI.MARKER, "Created TextLayoutEngine");
    }

    @Nonnull
    public static TextLayoutEngine getInstance() {
        return (TextLayoutEngine)FontResourceManager.getInstance();
    }

    @Nonnull
    public ModernTextRenderer getTextRenderer() {
        return this.mTextRenderer;
    }

    @Nonnull
    public ModernStringSplitter getStringSplitter() {
        return this.mStringSplitter;
    }

    public FontCollection getRawDefaultFontCollection() {
        return this.mRawDefaultFontCollection;
    }

    @RenderThread
    public void invalidateStrikeCache() {
        TextRenderType.clear(false);
        if (this.mVanillaFontManager != null) {
            Map<ResourceLocation, FontSet> fontSets = ((AccessFontManager)this.mVanillaFontManager).getFontSets();
            for (FontSet fontSet : fontSets.values()) {
                if (!(fontSet instanceof StandardFontSet)) continue;
                StandardFontSet standardFontSet = (StandardFontSet)fontSet;
                standardFontSet.invalidateCache(this.mResLevel);
            }
        }
    }

    public void clear() {
        int count = this.getCacheCount();
        this.mVanillaCache.clear();
        this.mComponentCache.clear();
        this.mFormattedCache.clear();
        this.mVanillaCache = new HashMap<VanillaLayoutKey, TextLayout>();
        this.mComponentCache = new HashMap<MutableComponent, TextLayout>();
        this.mFormattedCache = new HashMap<FormattedLayoutKey, TextLayout>();
        TextRenderType.clear(false);
        if (count > 0) {
            ModernUI.LOGGER.debug(MARKER, "Cleanup {} text layout entries", (Object)count);
        }
    }

    @RenderThread
    public void reload() {
        Window window = Minecraft.getInstance().getWindow();
        int scale = window != null ? Math.round((float)window.getGuiScale()) : 2;
        this.internalReload(scale);
    }

    private void internalReload(int scale) {
        Locale locale;
        this.clear();
        int oldLevel = this.mResLevel;
        this.mResLevel = sFixedResolution ? 2 : Math.min(scale, 8);
        Options opts = Minecraft.getInstance().options;
        if (opts != null) {
            this.mForceUnicodeFont = (Boolean)opts.forceUnicodeFont().get();
        }
        boolean layoutRtl = TextUtils.getLayoutDirectionFromLocale(locale = ModernUI.getSelectedLocale()) == 1;
        this.mTextDirectionHeuristic = switch (sTextDirection) {
            case 2 -> TextDirectionHeuristics.ANYRTL_LTR;
            case 3 -> TextDirectionHeuristics.LTR;
            case 4 -> TextDirectionHeuristics.RTL;
            case 5 -> TextDirectionHeuristics.LOCALE;
            case 6 -> TextDirectionHeuristics.FIRSTSTRONG_LTR;
            case 7 -> TextDirectionHeuristics.FIRSTSTRONG_RTL;
            default -> layoutRtl ? TextDirectionHeuristics.FIRSTSTRONG_RTL : TextDirectionHeuristics.FIRSTSTRONG_LTR;
        };
        this.mFontCollections.putIfAbsent(SANS_SERIF, Typeface.SANS_SERIF);
        this.mFontCollections.putIfAbsent(SERIF, Typeface.SERIF);
        this.mFontCollections.putIfAbsent(MONOSPACED, Typeface.MONOSPACED);
        if (sDefaultFontBehavior == 0 || sDefaultFontBehavior == 4 && (sDefaultFontRuleSet == null || sDefaultFontRuleSet.isEmpty())) {
            this.mFontCollections.put(Minecraft.DEFAULT_FONT, ModernUI.getSelectedTypeface());
        } else {
            LinkedHashSet<FontFamily> defaultFonts = new LinkedHashSet<FontFamily>();
            this.populateDefaultFonts(defaultFonts, sDefaultFontBehavior);
            defaultFonts.addAll(ModernUI.getSelectedTypeface().getFamilies());
            this.mFontCollections.put(Minecraft.DEFAULT_FONT, new FontCollection(defaultFonts.toArray(new FontFamily[0])));
        }
        if (this.mVanillaFontManager != null) {
            FontSet fontSet;
            Object standardFontSet;
            Map<ResourceLocation, FontSet> fontSets = ((AccessFontManager)this.mVanillaFontManager).getFontSets();
            FontSet fontSet2 = fontSets.get(Minecraft.DEFAULT_FONT);
            if (fontSet2 instanceof StandardFontSet) {
                standardFontSet = (StandardFontSet)fontSet2;
                ((StandardFontSet)((Object)standardFontSet)).reload(this.mFontCollections.get(Minecraft.DEFAULT_FONT), this.mResLevel);
            }
            if ((fontSet = fontSets.get(Minecraft.UNIFORM_FONT)) instanceof StandardFontSet) {
                standardFontSet = (StandardFontSet)fontSet;
                ((StandardFontSet)((Object)standardFontSet)).reload(ModernUI.getSelectedTypeface(), this.mResLevel);
            }
            for (Map.Entry entry : fontSets.entrySet()) {
                Object v;
                if (((ResourceLocation)entry.getKey()).equals((Object)Minecraft.DEFAULT_FONT) || ((ResourceLocation)entry.getKey()).equals((Object)Minecraft.UNIFORM_FONT) || !((v = entry.getValue()) instanceof StandardFontSet)) continue;
                StandardFontSet standardFontSet2 = (StandardFontSet)((Object)v);
                standardFontSet2.invalidateCache(this.mResLevel);
            }
            if (!fontSets.containsKey(Minecraft.UNIFORM_FONT)) {
                StandardFontSet fontSet22 = new StandardFontSet(Minecraft.getInstance().getTextureManager(), Minecraft.UNIFORM_FONT);
                fontSet22.reload(ModernUI.getSelectedTypeface(), this.mResLevel);
                fontSets.put(Minecraft.UNIFORM_FONT, fontSet22);
            }
        }
        ModernUI.LOGGER.info(MARKER, "Reloaded text layout engine, res level: {} to {}, locale: {}, layout RTL: {}", (Object)oldLevel, (Object)this.mResLevel, (Object)locale, (Object)layoutRtl);
    }

    @Override
    @RenderThread
    public void reloadAll() {
        super.reloadAll();
        this.mGlyphManager.reload();
        ModernUI.LOGGER.info(GlyphManager.MARKER, "Reloaded glyph manager");
        this.reload();
    }

    @Override
    public void onWindowResize(int width, int height, int newScale, int oldScale) {
        if (Core.getRenderThread() != null) {
            boolean reload;
            boolean bl = reload = newScale != oldScale;
            if (!reload) {
                Boolean forceUnicodeFont = (Boolean)Minecraft.getInstance().options.forceUnicodeFont().get();
                boolean bl2 = reload = !Objects.equals(this.mForceUnicodeFont, forceUnicodeFont);
            }
            if (reload) {
                this.internalReload(newScale);
            }
        }
    }

    @Override
    public void onDebugDump(@Nonnull PrintWriter pw) {
        pw.print("TextLayoutEngine: ");
        pw.print("CacheCount=" + this.getCacheCount());
        long memorySize = this.getCacheMemorySize();
        pw.println(", CacheSize=" + TextUtils.binaryCompact(memorySize) + " (" + memorySize + " bytes)");
    }

    @Nonnull
    public TextLayoutEngine injectFontManager(@Nonnull FontManager manager) {
        this.mVanillaFontManager = manager;
        return this;
    }

    private void populateDefaultFonts(Set<FontFamily> set, int behavior) {
        if (this.mRawDefaultFontCollection == null) {
            return;
        }
        if (behavior == 4 || behavior == 5) {
            Pattern pattern = null;
            List<? extends String> rules = sDefaultFontRuleSet;
            if (rules != null && !rules.isEmpty()) {
                try {
                    pattern = Pattern.compile(rules.stream().distinct().collect(Collectors.joining("|")));
                }
                catch (PatternSyntaxException e) {
                    ModernUI.LOGGER.warn(MARKER, "Illegal default font rules: {}", rules, (Object)e);
                }
            }
            boolean exclusive = behavior == 5;
            for (FontFamily family : this.mRawDefaultFontCollection.getFamilies()) {
                String name = family.getFamilyName();
                boolean matches = pattern != null && pattern.matcher(name).matches();
                if (!(matches ^ exclusive)) continue;
                set.add(family);
            }
        } else {
            block12: for (FontFamily family : this.mRawDefaultFontCollection.getFamilies()) {
                switch (family.getFamilyName()) {
                    case "minecraft:font/nonlatin_european.png": 
                    case "minecraft:font/accented.png": 
                    case "minecraft:font/ascii.png": 
                    case "minecraft:include/space / minecraft:space": {
                        if ((behavior & 1) == 0) continue block12;
                        set.add(family);
                        continue block12;
                    }
                }
                if ((behavior & 2) == 0) continue;
                set.add(family);
            }
        }
    }

    @Override
    @Nonnull
    public CompletableFuture<Void> reload(@Nonnull PreparableReloadListener.PreparationBarrier preparationBarrier, @Nonnull ResourceManager resourceManager, @Nonnull ProfilerFiller preparationProfiler, @Nonnull ProfilerFiller reloadProfiler, @Nonnull Executor preparationExecutor, @Nonnull Executor reloadExecutor) {
        preparationProfiler.startTick();
        preparationProfiler.endTick();
        return ((CompletableFuture)this.prepareResources(resourceManager, preparationExecutor).thenCompose(arg_0 -> ((PreparableReloadListener.PreparationBarrier)preparationBarrier).wait(arg_0))).thenAcceptAsync(results -> {
            reloadProfiler.startTick();
            reloadProfiler.push("reload");
            this.applyResources((LoadResults)results);
            reloadProfiler.pop();
            reloadProfiler.endTick();
        }, reloadExecutor);
    }

    @Nonnull
    private CompletableFuture<LoadResults> prepareResources(@Nonnull ResourceManager resourceManager, @Nonnull Executor preparationExecutor) {
        LoadResults results = new LoadResults();
        CompletableFuture<Void> loadFonts = CompletableFuture.runAsync(() -> TextLayoutEngine.loadFonts(resourceManager, results), preparationExecutor);
        CompletableFuture<Void> loadEmojis = CompletableFuture.runAsync(() -> TextLayoutEngine.loadEmojis(resourceManager, results), preparationExecutor);
        CompletableFuture<Void> loadShortcodes = CompletableFuture.runAsync(() -> TextLayoutEngine.loadShortcodes(resourceManager, results), preparationExecutor);
        return CompletableFuture.allOf(loadFonts, loadEmojis, loadShortcodes).thenApply(__ -> results);
    }

    private void applyResources(@Nonnull LoadResults results) {
        this.closeFonts();
        this.mFontCollections.clear();
        this.mFontCollections.putAll(this.mRegisteredFonts);
        this.mFontCollections.putAll(results.mFontCollections);
        this.mRawDefaultFontCollection = this.mFontCollections.get(Minecraft.DEFAULT_FONT);
        if (this.mVanillaFontManager != null) {
            Map<ResourceLocation, FontSet> fontSets = ((AccessFontManager)this.mVanillaFontManager).getFontSets();
            fontSets.values().forEach(FontSet::close);
            fontSets.clear();
            TextureManager textureManager = Minecraft.getInstance().getTextureManager();
            this.mFontCollections.forEach((fontName, fontCollection) -> {
                StandardFontSet fontSet = new StandardFontSet(textureManager, (ResourceLocation)fontName);
                fontSet.reload((FontCollection)fontCollection, this.mResLevel);
                fontSets.put((ResourceLocation)fontName, fontSet);
            });
        } else {
            ModernUI.LOGGER.warn(MARKER, "Where is font manager?");
        }
        if (this.mRawDefaultFontCollection == null) {
            throw new IllegalStateException("Default font failed to load");
        }
        super.applyResources(results);
    }

    @Override
    public void close() {
        this.mGlyphManager.closeAtlases();
        this.closeFonts();
        TextRenderType.clear(true);
        EffectRenderType.clear();
    }

    private void closeFonts() {
        for (FontCollection fontCollection : this.mFontCollections.values()) {
            for (FontFamily family : fontCollection.getFamilies()) {
                Font font = family.getClosestMatch(0);
                if (!(font instanceof BitmapFont)) continue;
                BitmapFont bitmapFont = (BitmapFont)font;
                bitmapFont.close();
            }
        }
        if (this.mRawDefaultFontCollection != null) {
            for (FontFamily family : this.mRawDefaultFontCollection.getFamilies()) {
                Font font = family.getClosestMatch(0);
                if (!(font instanceof BitmapFont)) continue;
                BitmapFont bitmapFont = (BitmapFont)font;
                bitmapFont.close();
            }
        }
    }

    @Override
    public void onFontRegistered(@Nonnull FontFamily f) {
        super.onFontRegistered(f);
        String name = f.getFamilyName();
        try {
            String newName = name.toLowerCase(Locale.ROOT).replaceAll(" ", "-");
            FontCollection fc = new FontCollection(f);
            ResourceLocation location = ModernUIMod.location(newName);
            if (this.mRegisteredFonts.putIfAbsent(location, fc) == null) {
                ModernUI.LOGGER.info(MARKER, "Redirect registered font '{}' to '{}'", (Object)name, (Object)location);
            }
        }
        catch (Exception e) {
            ModernUI.LOGGER.warn(MARKER, "Failed to redirect registered font '{}'", (Object)name);
        }
    }

    private static boolean isUnicodeFont(@Nonnull ResourceLocation name) {
        if (name.equals((Object)Minecraft.UNIFORM_FONT)) {
            return true;
        }
        if (name.getNamespace().equals("minecraft")) {
            return name.getPath().equals("include/unifont");
        }
        return false;
    }

    private static void loadFonts(@Nonnull ResourceManager resources, @Nonnull LoadResults results) {
        Gson gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
        ArrayList<RawFontBundle> bundles = new ArrayList<RawFontBundle>();
        for (Map.Entry entry : resources.listResourceStacks("font", res -> res.getPath().endsWith(".json")).entrySet()) {
            String path;
            ResourceLocation location = (ResourceLocation)entry.getKey();
            ResourceLocation name2 = location.withPath((path = location.getPath()).substring(5, path.length() - 5));
            if (TextLayoutEngine.isUnicodeFont(name2)) continue;
            RawFontBundle bundle2 = new RawFontBundle(name2);
            bundles.add(bundle2);
            for (Resource resource : (List)entry.getValue()) {
                try {
                    BufferedReader reader = resource.openAsReader();
                    try {
                        JsonArray providers = GsonHelper.getAsJsonArray((JsonObject)Objects.requireNonNull((JsonObject)gson.fromJson((Reader)reader, JsonObject.class)), (String)"providers");
                        for (int i = 0; i < providers.size(); ++i) {
                            JsonObject metadata = GsonHelper.convertToJsonObject((JsonElement)providers.get(i), (String)("providers[" + i + "]"));
                            GlyphProviderDefinition definition = (GlyphProviderDefinition)Util.getOrThrow((DataResult)GlyphProviderDefinition.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)metadata), JsonParseException::new);
                            TextLayoutEngine.loadSingleFont(resources, name2, bundle2, resource.sourcePackId(), i, metadata, definition);
                        }
                        ModernUI.LOGGER.info(MARKER, "Loaded raw font '{}' in pack: '{}'", (Object)name2, (Object)resource.sourcePackId());
                    }
                    finally {
                        if (reader == null) continue;
                        reader.close();
                    }
                }
                catch (Exception e) {
                    ModernUI.LOGGER.warn(MARKER, "Failed to load font '{}' in pack: '{}'", (Object)name2, (Object)resource.sourcePackId(), (Object)e);
                }
            }
            ModernUI.LOGGER.info(MARKER, "Loaded raw font bundle: '{}', font set: [{}]", (Object)location, (Object)bundle2.families.stream().map(object -> {
                if (object instanceof FontFamily) {
                    FontFamily family = (FontFamily)object;
                    return family.getFamilyName();
                }
                return object.toString();
            }).collect(Collectors.joining(",")));
        }
        DependencySorter sorter = new DependencySorter();
        for (RawFontBundle bundle3 : bundles) {
            sorter.addEntry((Object)bundle3.name, (DependencySorter.Entry)bundle3);
        }
        HashMap<ResourceLocation, FontCollection> map = new HashMap<ResourceLocation, FontCollection>();
        map.put(INTERNAL_DEFAULT, ModernUI.getSelectedTypeface());
        sorter.orderByDependencies((name, bundle) -> {
            if (TextLayoutEngine.isUnicodeFont(name)) {
                return;
            }
            LinkedHashSet<FontFamily> set = new LinkedHashSet<FontFamily>();
            for (Object object : bundle.families) {
                if (object instanceof FontFamily) {
                    FontFamily family = (FontFamily)object;
                    set.add(family);
                    continue;
                }
                ResourceLocation reference = (ResourceLocation)object;
                FontCollection resolved = (FontCollection)map.get(reference);
                if (resolved != null) {
                    set.addAll(resolved.getFamilies());
                    continue;
                }
                ModernUI.LOGGER.warn(MARKER, "Failed to resolve font: {}", (Object)reference);
            }
            if (!set.isEmpty()) {
                map.put((ResourceLocation)name, new FontCollection(set.toArray(new FontFamily[0])));
                ModernUI.LOGGER.info(MARKER, "Loaded font: '{}', font set: [{}]", name, (Object)set.stream().map(FontFamily::getFamilyName).collect(Collectors.joining(",")));
            } else {
                ModernUI.LOGGER.warn(MARKER, "Ignore font: '{}', because it's empty", name);
            }
        });
        map.remove(INTERNAL_DEFAULT);
        results.mFontCollections = map;
    }

    private static void loadSingleFont(@Nonnull ResourceManager resources, ResourceLocation name, RawFontBundle bundle, String sourcePackId, int index, JsonObject metadata, @Nonnull GlyphProviderDefinition definition) {
        switch (definition.type()) {
            case BITMAP: {
                BitmapFont bitmapFont = BitmapFont.create((BitmapProvider.Definition)definition, resources);
                bundle.families.add(new FontFamily(bitmapFont));
                break;
            }
            case TTF: {
                TrueTypeGlyphProviderDefinition ttf = (TrueTypeGlyphProviderDefinition)definition;
                if (metadata.has("size")) {
                    ModernUI.LOGGER.info(MARKER, "Ignore 'size={}' of providers[{}] in font '{}' in pack: '{}'", (Object)Float.valueOf(ttf.size()), (Object)index, (Object)name, (Object)sourcePackId);
                }
                if (metadata.has("oversample")) {
                    ModernUI.LOGGER.info(MARKER, "Ignore 'oversample={}' of providers[{}] in font '{}' in pack: '{}'", (Object)Float.valueOf(ttf.oversample()), (Object)index, (Object)name, (Object)sourcePackId);
                }
                if (metadata.has("shift")) {
                    ModernUI.LOGGER.info(MARKER, "Ignore 'shift={}' of providers[{}] in font '{}' in pack: '{}'", (Object)ttf.shift(), (Object)index, (Object)name, (Object)sourcePackId);
                }
                if (metadata.has("skip")) {
                    ModernUI.LOGGER.info(MARKER, "Ignore 'skip={}' of providers[{}] in font '{}' in pack: '{}'", (Object)ttf.skip(), (Object)index, (Object)name, (Object)sourcePackId);
                }
                bundle.families.add(TextLayoutEngine.createTTF(ttf.location(), resources));
                break;
            }
            case SPACE: {
                SpaceFont spaceFont = SpaceFont.create(name, (SpaceProvider.Definition)definition);
                bundle.families.add(new FontFamily(spaceFont));
                break;
            }
            case UNIHEX: {
                bundle.families.add(INTERNAL_DEFAULT);
                break;
            }
            case REFERENCE: {
                ResourceLocation reference = ((ProviderReferenceDefinition)definition).id();
                if (!TextLayoutEngine.isUnicodeFont(reference)) {
                    bundle.families.add(reference);
                    bundle.dependencies.add(reference);
                    break;
                }
                if (name.equals((Object)Minecraft.DEFAULT_FONT)) break;
                bundle.families.add(INTERNAL_DEFAULT);
                break;
            }
            default: {
                ModernUI.LOGGER.info(MARKER, "Unknown provider type '{}' in font '{}' in pack: '{}'", (Object)definition.type(), (Object)name, (Object)sourcePackId);
            }
        }
    }

    @Nonnull
    private static FontFamily createTTF(@Nonnull ResourceLocation file, ResourceManager resources) {
        FontFamily fontFamily;
        block8: {
            ResourceLocation location = file.withPrefix("font/");
            InputStream stream = resources.open(location);
            try {
                fontFamily = FontFamily.createFamily(stream, false);
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            stream.close();
        }
        return fontFamily;
    }

    public static int adjustPixelDensityForSDF(int resLevel) {
        return Math.max(resLevel, sMinPixelDensityForSDF);
    }

    @Nonnull
    public TextLayout lookupVanillaLayout(@Nonnull String text) {
        return this.lookupVanillaLayout(text, Style.EMPTY, 0);
    }

    @Nonnull
    public TextLayout lookupVanillaLayout(@Nonnull String text, @Nonnull Style style) {
        return this.lookupVanillaLayout(text, style, 0);
    }

    @Nonnull
    public TextLayout lookupVanillaLayout(@Nonnull String text, @Nonnull Style style, int computeFlags) {
        if (text.isEmpty()) {
            return TextLayout.EMPTY;
        }
        if (!RenderSystem.isOnRenderThread()) {
            if (sAllowAsyncLayout) {
                TextLayoutProcessor proc = this.mProcessorPool.acquire();
                if (proc == null) {
                    proc = new TextLayoutProcessor(this);
                }
                TextLayout layout = proc.createVanillaLayout(text, style, this.mResLevel, computeFlags);
                this.mProcessorPool.release(proc);
                return layout;
            }
            return (TextLayout)Minecraft.getInstance().submit(() -> this.lookupVanillaLayout(text, style, computeFlags)).join();
        }
        TextLayout layout = this.mVanillaCache.get(this.mVanillaLookupKey.update(text, style));
        int nowFlags = 0;
        if (layout == null || ((nowFlags = layout.mComputedFlags) & computeFlags) != computeFlags) {
            layout = this.mProcessor.createVanillaLayout(text, style, this.mResLevel, nowFlags | computeFlags);
            this.mVanillaCache.put(this.mVanillaLookupKey.copy(), layout);
            return layout;
        }
        return layout.get();
    }

    @Nonnull
    public TextLayout lookupFormattedLayout(@Nonnull FormattedText text) {
        return this.lookupFormattedLayout(text, Style.EMPTY, 0);
    }

    @Nonnull
    public TextLayout lookupFormattedLayout(@Nonnull FormattedText text, @Nonnull Style style) {
        return this.lookupFormattedLayout(text, style, 0);
    }

    @Nonnull
    public TextLayout lookupFormattedLayout(@Nonnull FormattedText text, @Nonnull Style style, int computeFlags) {
        TextLayout layout;
        if (text == CommonComponents.EMPTY || text == FormattedText.EMPTY) {
            return TextLayout.EMPTY;
        }
        if (!RenderSystem.isOnRenderThread()) {
            if (sAllowAsyncLayout) {
                TextLayoutProcessor proc = this.mProcessorPool.acquire();
                if (proc == null) {
                    proc = new TextLayoutProcessor(this);
                }
                TextLayout layout2 = proc.createTextLayout(text, style, this.mResLevel, computeFlags);
                this.mProcessorPool.release(proc);
                return layout2;
            }
            return (TextLayout)Minecraft.getInstance().submit(() -> this.lookupFormattedLayout(text, style, computeFlags)).join();
        }
        int nowFlags = 0;
        if (style.isEmpty() && sUseComponentCache && text instanceof MutableComponent) {
            MutableComponent component = (MutableComponent)text;
            layout = this.mComponentCache.get(component);
            if (layout == null || ((nowFlags = layout.mComputedFlags) & computeFlags) != computeFlags) {
                layout = this.mProcessor.createTextLayout(text, Style.EMPTY, this.mResLevel, nowFlags | computeFlags);
                this.mComponentCache.put(component, layout);
                return layout;
            }
        } else {
            layout = this.mFormattedCache.get(this.mFormattedLayoutKey.update(text, style));
            if (layout == null || ((nowFlags = layout.mComputedFlags) & computeFlags) != computeFlags) {
                layout = this.mProcessor.createTextLayout(text, style, this.mResLevel, nowFlags | computeFlags);
                this.mFormattedCache.put(this.mFormattedLayoutKey.copy(), layout);
                return layout;
            }
        }
        return layout.get();
    }

    @Nonnull
    public TextLayout lookupFormattedLayout(@Nonnull FormattedCharSequence sequence) {
        return this.lookupFormattedLayout(sequence, 0);
    }

    @Nonnull
    public TextLayout lookupFormattedLayout(@Nonnull FormattedCharSequence sequence, int computeFlags) {
        if (sequence == FormattedCharSequence.EMPTY) {
            return TextLayout.EMPTY;
        }
        if (!RenderSystem.isOnRenderThread()) {
            if (sAllowAsyncLayout) {
                TextLayoutProcessor proc = this.mProcessorPool.acquire();
                if (proc == null) {
                    proc = new TextLayoutProcessor(this);
                }
                TextLayout layout = proc.createSequenceLayout(sequence, this.mResLevel, computeFlags);
                this.mProcessorPool.release(proc);
                return layout;
            }
            return (TextLayout)Minecraft.getInstance().submit(() -> this.lookupFormattedLayout(sequence, computeFlags)).join();
        }
        int nowFlags = 0;
        if (sequence instanceof FormattedTextWrapper) {
            TextLayout layout;
            FormattedText text = ((FormattedTextWrapper)sequence).mText;
            if (text == CommonComponents.EMPTY || text == FormattedText.EMPTY) {
                return TextLayout.EMPTY;
            }
            if (sUseComponentCache && text instanceof MutableComponent) {
                MutableComponent component = (MutableComponent)text;
                layout = this.mComponentCache.get(component);
                if (layout == null || ((nowFlags = layout.mComputedFlags) & computeFlags) != computeFlags) {
                    layout = this.mProcessor.createTextLayout(text, Style.EMPTY, this.mResLevel, nowFlags | computeFlags);
                    this.mComponentCache.put(component, layout);
                    return layout;
                }
            } else {
                layout = this.mFormattedCache.get(this.mFormattedLayoutKey.update(text, Style.EMPTY));
                if (layout == null || ((nowFlags = layout.mComputedFlags) & computeFlags) != computeFlags) {
                    layout = this.mProcessor.createTextLayout(text, Style.EMPTY, this.mResLevel, nowFlags | computeFlags);
                    this.mFormattedCache.put(this.mFormattedLayoutKey.copy(), layout);
                    return layout;
                }
            }
            return layout.get();
        }
        TextLayout layout = this.mFormattedCache.get(this.mFormattedLayoutKey.update(sequence));
        if (layout == null || ((nowFlags = layout.mComputedFlags) & computeFlags) != computeFlags) {
            layout = this.mProcessor.createSequenceLayout(sequence, this.mResLevel, nowFlags | computeFlags);
            this.mFormattedCache.put(this.mFormattedLayoutKey.copy(), layout);
            return layout;
        }
        return layout.get();
    }

    @Deprecated
    public boolean handleSequence(FormattedCharSequence sequence, ReorderTextHandler.IConsumer consumer) {
        throw new UnsupportedOperationException();
    }

    @Nonnull
    public FontCollection getFontCollection(@Nonnull ResourceLocation fontName) {
        FontCollection fontCollection;
        if (this.mForceUnicodeFont == Boolean.TRUE && fontName.equals((Object)Minecraft.DEFAULT_FONT)) {
            fontName = Minecraft.UNIFORM_FONT;
        }
        return (fontCollection = this.mFontCollections.get(fontName)) != null ? fontCollection : ModernUI.getSelectedTypeface();
    }

    public void dumpBitmapFonts() {
        String basePath = Bitmap.saveDialogGet(Bitmap.SaveFormat.PNG, null, "BitmapFont");
        if (basePath != null) {
            basePath = basePath.substring(0, basePath.length() - 4);
        }
        int index = 0;
        IdentityHashMap<BitmapFont, Boolean> visited = new IdentityHashMap<BitmapFont, Boolean>();
        for (FontCollection fc : this.mFontCollections.values()) {
            for (FontFamily family : fc.getFamilies()) {
                BitmapFont bmf;
                Font font = family.getClosestMatch(0);
                if (!(font instanceof BitmapFont) || visited.put(bmf = (BitmapFont)font, Boolean.TRUE) != null) continue;
                if (basePath != null) {
                    bmf.dumpAtlas(index, basePath + "_" + index + ".png");
                } else {
                    bmf.dumpAtlas(index, null);
                }
                ++index;
            }
        }
    }

    @Deprecated
    @Nullable
    private GLBakedGlyph lookupEmoji(@Nonnull char[] buf, int start, int end) {
        return null;
    }

    public void onEndClientTick() {
        if (this.mTimer == 0) {
            boolean useTextShadersEffective;
            int lifespan = sCacheLifespan;
            Predicate<TextLayout> ticker = layout -> layout.tick(lifespan);
            this.mVanillaCache.values().removeIf(ticker);
            this.mComponentCache.values().removeIf(ticker);
            this.mFormattedCache.values().removeIf(ticker);
            boolean bl = useTextShadersEffective = sRawUseTextShadersInWorld && !ModernUIClient.areShadersEnabled();
            if (sUseTextShadersInWorld != useTextShadersEffective) {
                this.reload();
                sUseTextShadersInWorld = useTextShadersEffective;
            }
        }
        this.mTimer = (this.mTimer + 1) % 20;
    }

    public int getCacheCount() {
        return this.mVanillaCache.size() + this.mComponentCache.size() + this.mFormattedCache.size();
    }

    public int getCacheMemorySize() {
        int size = 0;
        for (TextLayout textLayout : this.mVanillaCache.values()) {
            size += textLayout.getMemorySize();
        }
        for (TextLayout textLayout : this.mComponentCache.values()) {
            size += textLayout.getMemorySize();
        }
        for (Map.Entry entry : this.mFormattedCache.entrySet()) {
            size += ((FormattedLayoutKey)entry.getKey()).getMemorySize();
            size += ((TextLayout)entry.getValue()).getMemorySize();
        }
        return size;
    }

    public void dumpLayoutCache() {
        int i = 0;
        for (Map.Entry<VanillaLayoutKey, TextLayout> entry : this.mVanillaCache.entrySet()) {
            ModernUI.LOGGER.info(MARKER, "VanillaCache {}\n{}\n{}", (Object)i, (Object)entry.getKey(), (Object)entry.getValue().toDetailedString());
            ++i;
        }
        for (Map.Entry<VanillaLayoutKey, TextLayout> entry : this.mComponentCache.entrySet()) {
            ModernUI.LOGGER.info(MARKER, "ComponentCache {}\n{}\n{}", (Object)i, (Object)entry.getKey(), (Object)entry.getValue().toDetailedString());
            ++i;
        }
        for (Map.Entry<Object, TextLayout> entry : this.mFormattedCache.entrySet()) {
            ModernUI.LOGGER.info(MARKER, "FormattedCache {}\n{}\n{}", (Object)i, entry.getKey(), (Object)entry.getValue().toDetailedString());
            ++i;
        }
    }

    public int getResLevel() {
        return this.mResLevel;
    }

    @Nonnull
    public TextDirectionHeuristic getTextDirectionHeuristic() {
        return this.mTextDirectionHeuristic;
    }

    @Deprecated
    private void cacheDigitGlyphs() {
    }

    @Nullable
    @Deprecated
    private TextLayout generateAndCache(VanillaLayoutKey key, @Nonnull CharSequence string, @Nonnull Style style) {
        if (!RenderSystem.isOnRenderThread()) {
            return (TextLayout)Minecraft.getInstance().submit(() -> this.generateAndCache(key, string, style)).join();
        }
        return null;
    }

    @Nonnull
    @Deprecated
    private Entry getOrCacheString(@Nonnull String str) {
        RenderSystem.assertOnRenderThread();
        char[] text = str.toCharArray();
        Entry entry = new Entry();
        int length = this.extractFormattingCodes(entry, str, text);
        ArrayList<Glyph> glyphList = new ArrayList<Glyph>();
        entry.advance = this.layoutBidiString(glyphList, text, 0, length, entry.codes);
        entry.glyphs = new Glyph[glyphList.size()];
        entry.glyphs = glyphList.toArray(entry.glyphs);
        Arrays.sort(entry.glyphs);
        boolean colorIndex = false;
        boolean shift = false;
        for (int glyphIndex = 0; glyphIndex < entry.glyphs.length; ++glyphIndex) {
            Glyph glyph = entry.glyphs[glyphIndex];
        }
        Key key = new Key();
        key.str = str;
        return entry;
    }

    @Deprecated
    private void layoutFont(TextLayoutProcessor data, char[] text, int start, int limit, int flag, Font font, boolean random, byte effect) {
    }

    @Deprecated
    private void layoutRandom(TextLayoutProcessor data, char[] text, int start, int limit, int flag, Font font, byte effect) {
    }

    @Deprecated
    private void insertColorState(@Nonnull TextLayoutProcessor data) {
    }

    @Deprecated
    private int extractFormattingCodes(Entry cacheEntry, @Nonnull String str, char[] text) {
        int next;
        ArrayList<FormattingCode> codeList = new ArrayList<FormattingCode>();
        int start = 0;
        int shift = 0;
        int fontStyle = 0;
        int renderStyle = 0;
        int colorCode = -1;
        while ((next = str.indexOf(167, start)) != -1 && next + 1 < str.length()) {
            System.arraycopy(text, next - shift + 2, text, next - shift, text.length - next - 2);
            int code = "0123456789abcdefklmnor".indexOf(Character.toLowerCase(str.charAt(next + 1)));
            switch (code) {
                case 16: {
                    break;
                }
                case 17: {
                    fontStyle = (byte)(fontStyle | 1);
                    break;
                }
                case 18: {
                    renderStyle = (byte)(renderStyle | 2);
                    cacheEntry.needExtraRender = true;
                    break;
                }
                case 19: {
                    renderStyle = (byte)(renderStyle | 1);
                    cacheEntry.needExtraRender = true;
                    break;
                }
                case 20: {
                    fontStyle = (byte)(fontStyle | 2);
                    break;
                }
                case 21: {
                    fontStyle = 0;
                    renderStyle = 0;
                    colorCode = -1;
                    break;
                }
                default: {
                    if (code < 0) break;
                    colorCode = (byte)code;
                }
            }
            FormattingCode formatting = new FormattingCode();
            formatting.stringIndex = next;
            formatting.stripIndex = next - shift;
            formatting.color = Color3i.fromFormattingCode(colorCode);
            formatting.fontStyle = (byte)fontStyle;
            formatting.renderEffect = (byte)renderStyle;
            codeList.add(formatting);
            start = next + 2;
            shift += 2;
        }
        cacheEntry.codes = codeList.toArray(new FormattingCode[0]);
        return text.length - shift;
    }

    @Deprecated
    private float layoutBidiString(List<Glyph> glyphList, char[] text, int start, int limit, FormattingCode[] codes) {
        float advance = 0.0f;
        if (Bidi.requiresBidi((char[])text, (int)start, (int)limit)) {
            Bidi bidi = new Bidi(text, start, null, 0, limit - start, 126);
            if (bidi.isRightToLeft()) {
                return this.layoutStyle(glyphList, text, start, limit, 0, advance, codes);
            }
            int runCount = bidi.getRunCount();
            byte[] levels = new byte[runCount];
            Object[] ranges = new Integer[runCount];
            for (int index = 0; index < runCount; ++index) {
                levels[index] = (byte)bidi.getRunLevel(index);
                ranges[index] = index;
            }
            Bidi.reorderVisually((byte[])levels, (int)0, (Object[])ranges, (int)0, (int)runCount);
            for (int visualIndex = 0; visualIndex < runCount; ++visualIndex) {
                int logicalIndex = (Integer)ranges[visualIndex];
                int layoutFlag = 0;
                advance = this.layoutStyle(glyphList, text, start + bidi.getRunStart(logicalIndex), start + bidi.getRunLimit(logicalIndex), layoutFlag, advance, codes);
            }
            return advance;
        }
        return this.layoutStyle(glyphList, text, start, limit, 0, advance, codes);
    }

    @Deprecated
    private float layoutStyle(List<Glyph> glyphList, char[] text, int start, int limit, int layoutFlags, float advance, FormattingCode[] codes) {
        boolean currentFontStyle = false;
        return advance;
    }

    @Deprecated
    private float layoutString(List<Glyph> glyphList, char[] text, int start, int limit, int layoutFlags, float advance, int style) {
        while (start < limit) {
            int next = 0;
            if (next == start) {
                // empty if block
            }
            start = ++next;
        }
        return advance;
    }

    @Deprecated
    private float layoutFont(List<Glyph> glyphList, char[] text, int start, int limit, int layoutFlags, float advance, Font font) {
        Object vector = null;
        Object glyph = null;
        boolean numGlyphs = true;
        return advance;
    }

    static {
        sUseTextShadersInWorld = true;
        sRawUseTextShadersInWorld = true;
        SANS_SERIF = ModernUIMod.location("sans-serif");
        SERIF = ModernUIMod.location("serif");
        MONOSPACED = ModernUIMod.location("monospace");
        INTERNAL_DEFAULT = ModernUIMod.location("internal-default");
        sDefaultFontBehavior = 0;
        sUseComponentCache = true;
        sAllowAsyncLayout = true;
        sMinPixelDensityForSDF = 4;
    }

    private static final class LoadResults
    extends FontResourceManager.LoadResults {
        volatile Map<ResourceLocation, FontCollection> mFontCollections;

        private LoadResults() {
        }
    }

    private static final class RawFontBundle
    implements DependencySorter.Entry<ResourceLocation> {
        final ResourceLocation name;
        Set<Object> families = new LinkedHashSet<Object>();
        Set<ResourceLocation> dependencies = new HashSet<ResourceLocation>();

        RawFontBundle(ResourceLocation name) {
            this.name = name;
        }

        public void visitRequiredDependencies(@Nonnull Consumer<ResourceLocation> visitor) {
            this.dependencies.forEach(visitor);
        }

        public void visitOptionalDependencies(@Nonnull Consumer<ResourceLocation> visitor) {
        }
    }

    @Deprecated
    private static class Entry {
        public WeakReference<Key> keyRef;
        public float advance;
        public Glyph[] glyphs;
        public FormattingCode[] codes;
        public boolean needExtraRender;

        private Entry() {
        }
    }

    @Deprecated
    private static class FormattingCode
    implements Comparable<Integer> {
        public static final byte UNDERLINE = 1;
        public static final byte STRIKETHROUGH = 2;
        public int stringIndex;
        public int stripIndex;
        public byte fontStyle;
        @Nullable
        public Color3i color;
        public byte renderEffect;

        private FormattingCode() {
        }

        @Override
        public int compareTo(@Nonnull Integer i) {
            return Integer.compare(this.stringIndex, i);
        }
    }

    @Deprecated
    private static class Glyph
    implements Comparable<Glyph> {
        int stringIndex;
        int texture;
        int x;
        int y;
        float advance;

        private Glyph() {
        }

        @Override
        public int compareTo(Glyph o) {
            return Integer.compare(this.stringIndex, o.stringIndex);
        }
    }

    @Deprecated
    private static class Key {
        public String str;

        private Key() {
        }

        public int hashCode() {
            int code = 0;
            int length = this.str.length();
            boolean colorCode = false;
            for (int index = 0; index < length; ++index) {
                int c = this.str.charAt(index);
                if (c >= 48 && c <= 57 && !colorCode) {
                    c = 48;
                }
                code = code * 31 + c;
                colorCode = c == 167;
            }
            return code;
        }

        public boolean equals(Object o) {
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            String other = o.toString();
            int length = this.str.length();
            if (length != other.length()) {
                return false;
            }
            boolean colorCode = false;
            for (int index = 0; index < length; ++index) {
                char c2;
                char c1 = this.str.charAt(index);
                if (c1 != (c2 = other.charAt(index)) && (c1 < '0' || c1 > '9' || c2 < '0' || c2 > '9' || colorCode)) {
                    return false;
                }
                colorCode = c1 == '\u00a7';
            }
            return true;
        }

        public String toString() {
            return this.str;
        }
    }
}

