/*
 * Decompiled with CFR 0.152.
 */
package icyllis.modernui.mc.text.mixin;

import com.mojang.blaze3d.vertex.VertexConsumer;
import icyllis.modernui.mc.text.TextLayout;
import icyllis.modernui.mc.text.TextLayoutEngine;
import icyllis.modernui.mc.text.VanillaTextWrapper;
import java.util.function.BiFunction;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import org.joml.Matrix4f;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={EditBox.class})
public abstract class MixinEditBox
extends AbstractWidget {
    @Shadow
    @Final
    private static String CURSOR_APPEND_CHARACTER;
    @Shadow
    private boolean isEditable;
    @Shadow
    private int textColor;
    @Shadow
    private int textColorUneditable;
    @Shadow
    private int cursorPos;
    @Shadow
    private int displayPos;
    @Shadow
    private int highlightPos;
    @Shadow
    private String value;
    @Shadow
    private long focusedTime;
    @Shadow
    private boolean bordered;
    @Shadow
    @Nullable
    private String suggestion;
    @Shadow
    private BiFunction<String, Integer, FormattedCharSequence> formatter;

    public MixinEditBox(int x, int y, int w, int h, Component msg) {
        super(x, y, w, h, msg);
    }

    @Inject(method={"<init>(Lnet/minecraft/client/gui/Font;IIIILnet/minecraft/client/gui/components/EditBox;Lnet/minecraft/network/chat/Component;)V"}, at={@At(value="RETURN")})
    public void EditBox(Font font, int x, int y, int w, int h, @Nullable EditBox src, Component msg, CallbackInfo ci) {
        this.formatter = (s, i) -> new VanillaTextWrapper((String)s);
    }

    @Shadow
    public abstract int getInnerWidth();

    @Shadow
    protected abstract int getMaxLength();

    @Inject(method={"renderWidget(Lnet/minecraft/client/gui/GuiGraphics;IIF)V"}, at={@At(value="FIELD", target="Lnet/minecraft/client/gui/components/EditBox;isEditable:Z", opcode=180)}, cancellable=true)
    public void onRenderWidget(@Nonnull GuiGraphics gr, int mouseX, int mouseY, float deltaTicks, CallbackInfo ci) {
        float cursorX;
        TextLayout layout;
        boolean cursorNotAtEnd;
        boolean separate;
        TextLayoutEngine engine = TextLayoutEngine.getInstance();
        int color = this.isEditable ? this.textColor : this.textColorUneditable;
        String viewText = engine.getStringSplitter().headByWidth(this.value.substring(this.displayPos), (float)this.getInnerWidth(), Style.EMPTY);
        int viewCursorPos = this.cursorPos - this.displayPos;
        int clampedViewHighlightPos = Mth.clamp((int)(this.highlightPos - this.displayPos), (int)0, (int)viewText.length());
        boolean cursorInRange = viewCursorPos >= 0 && viewCursorPos <= viewText.length();
        boolean cursorVisible = this.isFocused() && ((Util.getMillis() - this.focusedTime) / 500L & 1L) == 0L && cursorInRange;
        int baseX = this.bordered ? this.getX() + 4 : this.getX();
        int baseY = this.bordered ? this.getY() + (this.height - 8) / 2 : this.getY();
        float hori = baseX;
        Matrix4f matrix = gr.pose().last().pose();
        MultiBufferSource.BufferSource bufferSource = gr.bufferSource();
        if (!viewText.isEmpty()) {
            String subText = cursorInRange ? viewText.substring(0, viewCursorPos) : viewText;
            FormattedCharSequence subSequence = this.formatter.apply(subText, this.displayPos);
            if (subSequence != null && !(subSequence instanceof VanillaTextWrapper)) {
                separate = true;
                hori = engine.getTextRenderer().drawText(subSequence, hori, (float)baseY, color, true, matrix, (MultiBufferSource)bufferSource, Font.DisplayMode.NORMAL, 0, 0xF000F0);
            } else {
                separate = false;
                hori = engine.getTextRenderer().drawText(viewText, hori, (float)baseY, color, true, matrix, (MultiBufferSource)bufferSource, Font.DisplayMode.NORMAL, 0, 0xF000F0);
            }
        } else {
            separate = false;
        }
        boolean bl = cursorNotAtEnd = this.cursorPos < this.value.length() || this.value.length() >= this.getMaxLength();
        if (cursorInRange) {
            if (!separate && !viewText.isEmpty()) {
                layout = engine.lookupVanillaLayout(viewText, Style.EMPTY, 1);
                float curAdv = 0.0f;
                int stripIndex = 0;
                for (int i = 0; i < viewCursorPos; ++i) {
                    if (viewText.charAt(i) == '\u00a7') {
                        ++i;
                        continue;
                    }
                    curAdv += layout.getAdvances()[stripIndex++];
                }
                cursorX = (float)baseX + curAdv;
            } else {
                cursorX = hori;
            }
        } else {
            float f = cursorX = viewCursorPos > 0 ? (float)(baseX + this.width) : (float)baseX;
        }
        if (!viewText.isEmpty() && cursorInRange && viewCursorPos < viewText.length() && separate) {
            String subText = viewText.substring(viewCursorPos);
            FormattedCharSequence subSequence = this.formatter.apply(subText, this.cursorPos);
            if (subSequence != null && !(subSequence instanceof VanillaTextWrapper)) {
                engine.getTextRenderer().drawText(subSequence, hori, (float)baseY, color, true, matrix, (MultiBufferSource)bufferSource, Font.DisplayMode.NORMAL, 0, 0xF000F0);
            } else {
                engine.getTextRenderer().drawText(subText, hori, (float)baseY, color, true, matrix, (MultiBufferSource)bufferSource, Font.DisplayMode.NORMAL, 0, 0xF000F0);
            }
        }
        if (!cursorNotAtEnd && this.suggestion != null) {
            engine.getTextRenderer().drawText(this.suggestion, cursorX, (float)baseY, -8355712, true, matrix, (MultiBufferSource)bufferSource, Font.DisplayMode.NORMAL, 0, 0xF000F0);
        }
        if (viewCursorPos != clampedViewHighlightPos) {
            gr.flush();
            layout = engine.lookupVanillaLayout(viewText, Style.EMPTY, 1);
            float startX = baseX;
            float endX = cursorX;
            int stripIndex = 0;
            for (int i = 0; i < clampedViewHighlightPos; ++i) {
                if (viewText.charAt(i) == '\u00a7') {
                    ++i;
                    continue;
                }
                startX += layout.getAdvances()[stripIndex++];
            }
            if (endX < startX) {
                float temp = startX;
                startX = endX;
                endX = temp;
            }
            if (startX > (float)(this.getX() + this.width)) {
                startX = this.getX() + this.width;
            }
            if (endX > (float)(this.getX() + this.width)) {
                endX = this.getX() + this.width;
            }
            VertexConsumer consumer = gr.bufferSource().getBuffer(RenderType.guiOverlay());
            consumer.vertex(matrix, startX, (float)(baseY + 10), 0.0f).color(51, 181, 229, 56).endVertex();
            consumer.vertex(matrix, endX, (float)(baseY + 10), 0.0f).color(51, 181, 229, 56).endVertex();
            consumer.vertex(matrix, endX, (float)(baseY - 1), 0.0f).color(51, 181, 229, 56).endVertex();
            consumer.vertex(matrix, startX, (float)(baseY - 1), 0.0f).color(51, 181, 229, 56).endVertex();
            gr.flush();
        } else if (cursorVisible) {
            if (cursorNotAtEnd) {
                gr.flush();
                VertexConsumer consumer = gr.bufferSource().getBuffer(RenderType.guiOverlay());
                consumer.vertex(matrix, cursorX - 0.5f, (float)(baseY + 10), 0.0f).color(208, 208, 208, 255).endVertex();
                consumer.vertex(matrix, cursorX + 0.5f, (float)(baseY + 10), 0.0f).color(208, 208, 208, 255).endVertex();
                consumer.vertex(matrix, cursorX + 0.5f, (float)(baseY - 1), 0.0f).color(208, 208, 208, 255).endVertex();
                consumer.vertex(matrix, cursorX - 0.5f, (float)(baseY - 1), 0.0f).color(208, 208, 208, 255).endVertex();
                gr.flush();
            } else {
                engine.getTextRenderer().drawText(CURSOR_APPEND_CHARACTER, cursorX, (float)baseY, color, true, matrix, (MultiBufferSource)bufferSource, Font.DisplayMode.NORMAL, 0, 0xF000F0);
                gr.flush();
            }
        } else {
            gr.flush();
        }
        ci.cancel();
    }
}

