/*
 * Decompiled with CFR 0.152.
 */
package fuzs.hangglider.client;

import fuzs.hangglider.HangGlider;
import fuzs.hangglider.client.handler.ElytraEquippedHandler;
import fuzs.hangglider.client.handler.FovModifierHandler;
import fuzs.hangglider.client.handler.GlidingCameraHandler;
import fuzs.hangglider.client.handler.GlidingCrouchHandler;
import fuzs.hangglider.client.init.ModClientRegistry;
import fuzs.hangglider.client.model.GliderModel;
import fuzs.hangglider.client.renderer.entity.layers.GliderLayer;
import fuzs.hangglider.helper.PlayerGlidingHelper;
import fuzs.hangglider.init.ModRegistry;
import fuzs.puzzleslib.api.client.core.v1.ClientModConstructor;
import fuzs.puzzleslib.api.client.core.v1.context.ItemModelPropertiesContext;
import fuzs.puzzleslib.api.client.core.v1.context.LayerDefinitionsContext;
import fuzs.puzzleslib.api.client.core.v1.context.LivingEntityRenderLayersContext;
import fuzs.puzzleslib.api.client.event.v1.ClientTickEvents;
import fuzs.puzzleslib.api.client.event.v1.entity.player.ComputeFovModifierCallback;
import fuzs.puzzleslib.api.client.event.v1.renderer.ComputeCameraAnglesCallback;
import fuzs.puzzleslib.api.client.event.v1.renderer.RenderGuiCallback;
import fuzs.puzzleslib.api.client.event.v1.renderer.RenderHandCallback;
import fuzs.puzzleslib.api.client.event.v1.renderer.RenderPlayerEvents;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;

public class HangGliderClient
implements ClientModConstructor {
    public static final ResourceLocation ITEM_PROPERTY_DEPLOYED = HangGlider.id("deployed");
    public static final ResourceLocation ITEM_PROPERTY_BROKEN = HangGlider.id("broken");

    public void onConstructMod() {
        HangGliderClient.registerHandlers();
    }

    private static void registerHandlers() {
        ComputeFovModifierCallback.EVENT.register(FovModifierHandler::onComputeFovModifier);
        ClientTickEvents.END.register(GlidingCameraHandler::onEndClientTick);
        ClientTickEvents.END.register(ElytraEquippedHandler.INSTANCE::onClientTick$End);
        RenderGuiCallback.EVENT.register(ElytraEquippedHandler.INSTANCE::onRenderGui);
        RenderPlayerEvents.BEFORE.register(GlidingCrouchHandler::onRenderPlayer$Pre);
        RenderPlayerEvents.AFTER.register(GlidingCrouchHandler::onRenderPlayer$Post);
        RenderHandCallback.EVENT.register(GlidingCameraHandler::onRenderHand);
        ComputeCameraAnglesCallback.EVENT.register(GlidingCameraHandler::onComputeCameraRoll);
    }

    public void onClientSetup() {
        GliderLayer.registerGliderTexture((Item)ModRegistry.REINFORCED_HANG_GLIDER_ITEM.value(), HangGlider.id("textures/models/glider/reinforced_hang_glider.png"));
    }

    public void onRegisterLayerDefinitions(LayerDefinitionsContext context) {
        context.registerLayerDefinition(ModClientRegistry.GLIDER, GliderModel::createLayer);
    }

    public void onRegisterItemModelProperties(ItemModelPropertiesContext context) {
        context.registerItemProperty(ITEM_PROPERTY_DEPLOYED, (itemStack, clientLevel, livingEntity, i) -> {
            Player player;
            return livingEntity instanceof Player && PlayerGlidingHelper.getGliderInHand(player = (Player)livingEntity) == itemStack ? 1.0f : 0.0f;
        }, new ItemLike[]{(ItemLike)ModRegistry.HANG_GLIDER_ITEM.value(), (ItemLike)ModRegistry.REINFORCED_HANG_GLIDER_ITEM.value()});
        context.registerItemProperty(ITEM_PROPERTY_BROKEN, (itemStack, clientLevel, livingEntity, i) -> !PlayerGlidingHelper.isValidGlider(itemStack) ? 1.0f : 0.0f, new ItemLike[]{(ItemLike)ModRegistry.HANG_GLIDER_ITEM.value(), (ItemLike)ModRegistry.REINFORCED_HANG_GLIDER_ITEM.value()});
    }

    public void onRegisterLivingEntityRenderLayers(LivingEntityRenderLayersContext context) {
        context.registerRenderLayer(EntityType.PLAYER, (renderLayerParent, context1) -> new GliderLayer((RenderLayerParent<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>>)renderLayerParent, context1.getModelSet()));
    }
}

