/*
 * Decompiled with CFR 0.152.
 */
package fuzs.hangglider.client.handler;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import fuzs.hangglider.capability.GlidingCapability;
import fuzs.hangglider.init.ModRegistry;
import fuzs.puzzleslib.api.event.v1.core.EventResult;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;

public class GlidingCrouchHandler {
    private static boolean appliedGlidingRotations;

    public static EventResult onRenderPlayer$Pre(Player player, PlayerRenderer renderer, float partialTick, PoseStack poseStack, MultiBufferSource multiBufferSource, int packedLight) {
        if (((GlidingCapability)ModRegistry.GLIDING_CAPABILITY.get((Object)player)).isGliding()) {
            PlayerModel model = (PlayerModel)renderer.getModel();
            model.leftArmPose = model.rightArmPose = HumanoidModel.ArmPose.EMPTY;
            if (player.isCrouching()) {
                model.crouching = false;
                Vec3 vec3 = renderer.getRenderOffset((AbstractClientPlayer)player, partialTick);
                poseStack.translate(-vec3.x(), -vec3.y(), -vec3.z());
            }
            float interpolatedYaw = Mth.lerp((float)partialTick, (float)player.yHeadRotO, (float)player.yHeadRot);
            poseStack.pushPose();
            poseStack.mulPose(Axis.YP.rotationDegrees(-interpolatedYaw));
            poseStack.translate(0.0f, player.getBbHeight() / 2.0f, 0.0f);
            poseStack.mulPose(Axis.XP.rotationDegrees(90.0f));
            poseStack.translate(0.0f, -player.getBbHeight() / 2.0f, 0.0f);
            poseStack.mulPose(Axis.YP.rotationDegrees(interpolatedYaw));
            appliedGlidingRotations = true;
            poseStack.translate(0.0f, -0.5f, 0.0f);
        }
        return EventResult.PASS;
    }

    public static void onRenderPlayer$Post(Player player, PlayerRenderer renderer, float partialTick, PoseStack poseStack, MultiBufferSource multiBufferSource, int packedLight) {
        if (appliedGlidingRotations) {
            appliedGlidingRotations = false;
            poseStack.popPose();
        }
        if (((GlidingCapability)ModRegistry.GLIDING_CAPABILITY.get((Object)player)).isGliding() && player.isCrouching()) {
            Vec3 vec3 = renderer.getRenderOffset((AbstractClientPlayer)player, partialTick);
            poseStack.translate(vec3.x(), vec3.y(), vec3.z());
        }
    }
}

