/*
 * Decompiled with CFR 0.152.
 */
package fuzs.hangglider.data.client;

import com.google.gson.JsonElement;
import fuzs.hangglider.HangGlider;
import fuzs.hangglider.client.HangGliderClient;
import fuzs.hangglider.init.ModRegistry;
import fuzs.puzzleslib.api.client.data.v2.AbstractModelProvider;
import fuzs.puzzleslib.api.data.v2.core.DataProviderContext;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.data.models.ItemModelGenerators;
import net.minecraft.data.models.model.ModelLocationUtils;
import net.minecraft.data.models.model.ModelTemplate;
import net.minecraft.data.models.model.ModelTemplates;
import net.minecraft.data.models.model.TextureMapping;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;

public class ModModelProvider
extends AbstractModelProvider {
    public ModModelProvider(DataProviderContext context) {
        super(context);
    }

    public void addItemModels(ItemModelGenerators builder) {
        ResourceLocation deployedHangGlider = ModModelProvider.generateFlatItem(HangGlider.id("deployed_hang_glider"), ModelTemplates.FLAT_ITEM, builder.output);
        ResourceLocation brokenHangGlider = ModModelProvider.generateFlatItem(HangGlider.id("broken_hang_glider"), ModelTemplates.FLAT_ITEM, builder.output);
        ResourceLocation brokenReinforcedHangGlider = ModModelProvider.generateFlatItem(HangGlider.id("broken_reinforced_hang_glider"), ModelTemplates.FLAT_ITEM, builder.output);
        builder.generateFlatItem((Item)ModRegistry.GLIDER_WING_ITEM.value(), ModelTemplates.FLAT_ITEM);
        builder.generateFlatItem((Item)ModRegistry.GLIDER_FRAMEWORK_ITEM.value(), ModelTemplates.FLAT_ITEM);
        ModModelProvider.generateFlatItem((Item)ModRegistry.HANG_GLIDER_ITEM.value(), ModelTemplates.FLAT_ITEM, (BiConsumer<ResourceLocation, Supplier<JsonElement>>)builder.output, AbstractModelProvider.ItemOverride.of((ResourceLocation)deployedHangGlider, (ResourceLocation)HangGliderClient.ITEM_PROPERTY_DEPLOYED, (float)1.0f), AbstractModelProvider.ItemOverride.of((ResourceLocation)brokenHangGlider, (ResourceLocation)HangGliderClient.ITEM_PROPERTY_BROKEN, (float)1.0f));
        ModModelProvider.generateFlatItem((Item)ModRegistry.REINFORCED_HANG_GLIDER_ITEM.value(), ModelTemplates.FLAT_ITEM, (BiConsumer<ResourceLocation, Supplier<JsonElement>>)builder.output, AbstractModelProvider.ItemOverride.of((ResourceLocation)deployedHangGlider, (ResourceLocation)HangGliderClient.ITEM_PROPERTY_DEPLOYED, (float)1.0f), AbstractModelProvider.ItemOverride.of((ResourceLocation)brokenReinforcedHangGlider, (ResourceLocation)HangGliderClient.ITEM_PROPERTY_BROKEN, (float)1.0f));
    }

    public static ResourceLocation generateFlatItem(ResourceLocation resourceLocation, ModelTemplate modelTemplate, BiConsumer<ResourceLocation, Supplier<JsonElement>> modelOutput) {
        return modelTemplate.create(ModModelProvider.decorateItemModelLocation((ResourceLocation)resourceLocation), TextureMapping.layer0((ResourceLocation)ModModelProvider.decorateItemModelLocation((ResourceLocation)resourceLocation)), modelOutput);
    }

    public static ResourceLocation generateFlatItem(Item item, ModelTemplate modelTemplate, BiConsumer<ResourceLocation, Supplier<JsonElement>> modelOutput, AbstractModelProvider.ItemOverride ... itemOverrides) {
        return ModModelProvider.generateFlatItem(item, modelTemplate, modelOutput, ModModelProvider.overrides((ModelTemplate)modelTemplate, (AbstractModelProvider.ItemOverride.Factory[])((AbstractModelProvider.ItemOverride.Factory[])Stream.of(itemOverrides).map(override -> resourceLocation -> override).toArray(AbstractModelProvider.ItemOverride.Factory[]::new))));
    }

    public static ResourceLocation generateFlatItem(Item item, ModelTemplate modelTemplate, BiConsumer<ResourceLocation, Supplier<JsonElement>> modelOutput, ModelTemplate.JsonFactory factory) {
        return modelTemplate.create(ModelLocationUtils.getModelLocation((Item)item), TextureMapping.layer0((Item)item), modelOutput, factory);
    }
}

