/*
 * Decompiled with CFR 0.152.
 */
package shiroroku.tarotcards.Item.Tarot;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.event.entity.living.LivingHurtEvent;
import shiroroku.tarotcards.Configuration;
import shiroroku.tarotcards.Item.TarotItem;
import shiroroku.tarotcards.Registry.ItemRegistry;
import shiroroku.tarotcards.TarotCards;

public class JusticeTarot
extends TarotItem {
    private static final ResourceKey<DamageType> JUSTICE = ResourceKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)new ResourceLocation("tarotcards", "justice"));

    public static void handleOnHurt(LivingHurtEvent event) {
        Entity entity = event.getSource().getEntity();
        if (entity instanceof LivingEntity) {
            LivingEntity attacker = (LivingEntity)entity;
            entity = event.getEntity();
            if (entity instanceof Player) {
                Player player = (Player)entity;
                if (event.getSource().is(JUSTICE)) {
                    return;
                }
                if (JusticeTarot.hasTarot(player, (Item)ItemRegistry.justice.get())) {
                    float amount = (float)((double)event.getAmount() * (Double)Configuration.justice_damagemultiplier.get());
                    attacker.hurt(JusticeTarot.justice_damage((Entity)player), amount);
                    TarotCards.LOGGER.debug("{} - Returning damage", ItemRegistry.justice.get());
                    TarotCards.LOGGER.debug("From: {}, To: {} [{}]", (Object)player, (Object)attacker, (Object)Float.valueOf(attacker.getHealth()));
                    TarotCards.LOGGER.debug("Amount: {}", (Object)Float.valueOf(amount));
                }
            }
        }
    }

    @Override
    public void appendHoverText(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.translatable((String)(this.getDescriptionId() + ".desc"), (Object[])new Object[]{String.valueOf((Double)Configuration.justice_damagemultiplier.get() * 100.0)}).withStyle(ChatFormatting.BLUE));
    }

    private static DamageSource justice_damage(Entity entity) {
        return new DamageSource((Holder)entity.level().registryAccess().registryOrThrow(Registries.DAMAGE_TYPE).getHolderOrThrow(JUSTICE));
    }
}

