/*
 * Decompiled with CFR 0.152.
 */
package shiroroku.tarotcards.Item.TarotDeck;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.Nullable;
import shiroroku.tarotcards.Item.TarotDeck.TarotDeckContainer;

public class TarotDeckItem
extends Item
implements MenuProvider {
    private static final TagKey<Item> tarot = ItemTags.create((ResourceLocation)new ResourceLocation("tarotcards", "tarot_cards"));

    public TarotDeckItem() {
        super(new Item.Properties().stacksTo(1).rarity(Rarity.UNCOMMON).fireResistant());
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player player, InteractionHand hand) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            serverPlayer.openMenu((MenuProvider)this);
        }
        return super.use(world, player, hand);
    }

    public Component getDisplayName() {
        return this.getDescription();
    }

    @Nullable
    public AbstractContainerMenu createMenu(int id, Inventory playerInventory, Player player) {
        return new TarotDeckContainer(id, playerInventory, player);
    }

    public void appendHoverText(ItemStack stack, @javax.annotation.Nullable Level world, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.translatable((String)(this.getDescriptionId() + ".desc")).withStyle(ChatFormatting.GRAY));
    }

    public static class TarotDeckInventory
    extends ItemStackHandler {
        private final ItemStack deck;

        public TarotDeckInventory(ItemStack parent) {
            super(22);
            this.deck = parent;
            this.deserializeNBT(parent.getOrCreateTagElement("held_cards"));
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            return stack.getTags().anyMatch(t -> t == tarot) && this.stacks.stream().noneMatch(s -> s.is(stack.getItem()));
        }

        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            this.deck.getOrCreateTag().put("held_cards", (Tag)this.serializeNBT());
        }
    }
}

