/*
 * Decompiled with CFR 0.152.
 */
package shiroroku.tarotcards.Item;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.ItemStackHandler;
import shiroroku.tarotcards.Configuration;
import shiroroku.tarotcards.CuriosCompat;
import shiroroku.tarotcards.Registry.ItemRegistry;
import shiroroku.tarotcards.TarotCards;

public abstract class TarotItem
extends Item {
    public TarotItem() {
        super(new Item.Properties().rarity(Rarity.UNCOMMON).stacksTo(1));
    }

    public boolean isFoil(ItemStack stack) {
        return TarotItem.isActivated(stack);
    }

    public static boolean isActivated(ItemStack tarot) {
        return !tarot.getOrCreateTag().getBoolean("deactivated");
    }

    public InteractionResultHolder<ItemStack> use(Level pLevel, Player pPlayer, InteractionHand pUsedHand) {
        ItemStack tarot = pPlayer.getItemInHand(pUsedHand);
        tarot.getOrCreateTag().putBoolean("deactivated", !tarot.getOrCreateTag().getBoolean("deactivated"));
        return super.use(pLevel, pPlayer, pUsedHand);
    }

    public static boolean hasTarot(Player player, Item tarot) {
        Object object;
        if (player == null) {
            return false;
        }
        ItemStack deck = null;
        Inventory pInv = player.getInventory();
        ImmutableList fullInv = ImmutableList.of((Object)pInv.items, (Object)pInv.armor, (Object)pInv.offhand);
        if (ModList.get().isLoaded("curios")) {
            ItemStack singlecard = CuriosCompat.getTarotCardCurio(player, tarot);
            if (singlecard != null && TarotItem.isActivated(singlecard)) {
                return true;
            }
            deck = CuriosCompat.getTarotDeckCurio(player);
        }
        if (!((Boolean)Configuration.require_card_in_curio.get()).booleanValue()) {
            for (List compartment : fullInv) {
                object = compartment.iterator();
                while (object.hasNext()) {
                    ItemStack stack = (ItemStack)object.next();
                    if (stack.is(tarot)) {
                        return TarotItem.isActivated(stack);
                    }
                    if (stack.getItem() != ItemRegistry.tarot_deck.get()) continue;
                    deck = stack;
                }
            }
        }
        if (deck == null) {
            return false;
        }
        ItemStack finalCard = null;
        if (((Boolean)Configuration.tarot_deck_applies_effects.get()).booleanValue() && (object = deck.getCapability(Capabilities.ItemHandler.ITEM)) instanceof ItemStackHandler) {
            ItemStackHandler handler = (ItemStackHandler)object;
            for (int i = 0; i < handler.getSlots(); ++i) {
                if (!handler.getStackInSlot(i).is(tarot)) continue;
                finalCard = handler.getStackInSlot(i).copy();
                break;
            }
        }
        return finalCard != null && TarotItem.isActivated(finalCard);
    }

    public static void handleAttributeTick(Player player, Attribute a, AttributeModifier mod, Item tarot) {
        TarotItem.handleAttributeTick(player, a, mod, tarot, () -> true);
    }

    public static void handleAttributeTick(Player player, Attribute a, AttributeModifier mod, Item tarot, Supplier<Boolean> additionalRequirements) {
        boolean hasCard;
        boolean bl = hasCard = TarotItem.hasTarot(player, tarot) && additionalRequirements.get() != false;
        if (player.getAttribute(a).hasModifier(mod)) {
            if (!hasCard) {
                TarotCards.LOGGER.debug("Removing Tarot Modifier: {} - {}", (Object)tarot, (Object)mod);
                player.getAttribute(a).removeModifier(mod.getId());
            }
        } else if (hasCard) {
            TarotCards.LOGGER.debug("Adding Tarot Modifier: {} - {}", (Object)tarot, (Object)mod);
            player.getAttribute(a).addTransientModifier(mod);
        }
    }

    public void appendHoverText(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.translatable((String)(this.getDescriptionId() + ".desc")).withStyle(ChatFormatting.BLUE));
    }
}

