/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.attachment.forcerod;

import com.mrbysco.forcecraft.attachment.ForceAttachments;
import com.mrbysco.forcecraft.attachment.forcerod.IForceRodModifier;
import com.mrbysco.forcecraft.util.ForceUtils;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.common.util.INBTSerializable;

public class ForceRodAttachment
implements IForceRodModifier,
INBTSerializable<CompoundTag> {
    boolean camo = false;
    boolean ender = false;
    boolean sight = false;
    int speed = 0;
    int healing = 0;
    GlobalPos homeLocation = null;
    boolean light;

    @Override
    public int getHealingLevel() {
        return this.healing;
    }

    @Override
    public boolean hasHealing() {
        return this.healing > 0;
    }

    @Override
    public void incrementHealing() {
        ++this.healing;
    }

    @Override
    public void setHealing(int newHealing) {
        this.healing = newHealing;
    }

    @Override
    public boolean hasCamoModifier() {
        return this.camo;
    }

    @Override
    public void setCamoModifier(boolean newVal) {
        this.camo = newVal;
    }

    @Override
    public GlobalPos getHomeLocation() {
        return this.homeLocation;
    }

    @Override
    public void setHomeLocation(GlobalPos globalPos) {
        this.homeLocation = globalPos;
    }

    @Override
    public void teleportPlayerToLocation(Player player, GlobalPos globalPos) {
        if (player.level().dimension().location().equals((Object)globalPos.dimension().location())) {
            BlockPos pos = globalPos.pos();
            int x = pos.getX();
            int y = pos.getY() + 1;
            int z = pos.getZ();
            ForceUtils.teleportToLocation(player, x, y, z, true);
        } else if (!player.level().isClientSide) {
            player.sendSystemMessage((Component)Component.translatable((String)"forcecraft.ender_rod.dimension.text").withStyle(ChatFormatting.YELLOW));
        }
    }

    @Override
    public boolean hasEnderModifier() {
        return this.ender;
    }

    @Override
    public void setEnderModifier(boolean newVal) {
        this.ender = newVal;
    }

    @Override
    public boolean isRodofEnder() {
        return this.ender;
    }

    @Override
    public boolean hasSightModifier() {
        return this.sight;
    }

    @Override
    public void setSightModifier(boolean newVal) {
        this.sight = newVal;
    }

    @Override
    public boolean hasLight() {
        return this.light;
    }

    @Override
    public void setLight(boolean val) {
        this.light = val;
    }

    @Override
    public int getSpeedLevel() {
        return this.speed;
    }

    @Override
    public void incrementSpeed() {
        this.setSpeed(this.speed + 1);
    }

    @Override
    public void setSpeed(int newSpeed) {
        this.speed = Math.min(3, newSpeed);
    }

    public static void attachInformation(ItemStack stack, List<Component> tooltip) {
        if (stack.hasData(ForceAttachments.FORCE_ROD)) {
            ForceRodAttachment attachment = (ForceRodAttachment)stack.getData(ForceAttachments.FORCE_ROD);
            if (attachment.hasHealing()) {
                tooltip.add((Component)Component.translatable((String)("item.infuser.tooltip.healing" + attachment.getHealingLevel())).withStyle(ChatFormatting.RED));
            }
            if (attachment.getSpeedLevel() > 0) {
                tooltip.add((Component)Component.translatable((String)("item.infuser.tooltip.speed" + attachment.getSpeedLevel())));
            }
            if (attachment.hasCamoModifier()) {
                tooltip.add((Component)Component.translatable((String)"item.infuser.tooltip.camo").withStyle(ChatFormatting.DARK_GREEN));
            }
            if (attachment.hasEnderModifier()) {
                tooltip.add((Component)Component.translatable((String)"item.infuser.tooltip.ender").withStyle(ChatFormatting.DARK_PURPLE));
                if (attachment.getHomeLocation() != null) {
                    GlobalPos globalPos = attachment.getHomeLocation();
                    BlockPos pos = globalPos.pos();
                    tooltip.add((Component)Component.translatable((String)"forcecraft.ender_rod.location", (Object[])new Object[]{pos.getX(), pos.getY(), pos.getZ(), globalPos.dimension().location()}).withStyle(ChatFormatting.YELLOW));
                } else {
                    tooltip.add((Component)Component.translatable((String)"forcecraft.ender_rod.unset").withStyle(ChatFormatting.RED));
                }
                tooltip.add((Component)Component.translatable((String)"forcecraft.ender_rod.text").withStyle(ChatFormatting.GRAY));
            }
            if (attachment.hasSightModifier()) {
                tooltip.add((Component)Component.translatable((String)"item.infuser.tooltip.sight").withStyle(ChatFormatting.LIGHT_PURPLE));
            }
            if (attachment.hasLight()) {
                tooltip.add((Component)Component.translatable((String)"item.infuser.tooltip.light").withStyle(ChatFormatting.YELLOW));
            }
        }
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.putInt("speed", this.getSpeedLevel());
        tag.putInt("healing", this.getHealingLevel());
        if (this.getHomeLocation() != null) {
            tag.putBoolean("HasHome", true);
            tag.putLong("HomeLocation", this.getHomeLocation().pos().asLong());
            tag.putString("HomeDimension", this.getHomeLocation().dimension().location().toString());
        }
        tag.putBoolean("camo", this.hasCamoModifier());
        tag.putBoolean("ender", this.hasEnderModifier());
        tag.putBoolean("sight", this.hasSightModifier());
        tag.putBoolean("light", this.hasLight());
        return tag;
    }

    public void deserializeNBT(CompoundTag tag) {
        this.setSpeed(tag.getInt("speed"));
        this.setHealing(tag.getInt("healing"));
        if (tag.getBoolean("HasHome")) {
            BlockPos pos = BlockPos.of((long)tag.getLong("HomeLocation"));
            ResourceLocation location = ResourceLocation.tryParse((String)tag.getString("HomeDimension"));
            if (location != null) {
                ResourceKey dimension = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)location);
                this.setHomeLocation(GlobalPos.of((ResourceKey)dimension, (BlockPos)pos));
            }
        }
        this.setCamoModifier(tag.getBoolean("camo"));
        this.setEnderModifier(tag.getBoolean("ender"));
        this.setSightModifier(tag.getBoolean("sight"));
        this.setLight(tag.getBoolean("light"));
    }
}

