/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.attachment.forcewrench;

import com.mrbysco.forcecraft.attachment.ForceAttachments;
import com.mrbysco.forcecraft.attachment.forcewrench.IForceWrench;
import com.mrbysco.forcecraft.items.infuser.ForceToolData;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.common.util.INBTSerializable;

public class ForceWrenchAttachment
implements IForceWrench,
INBTSerializable<CompoundTag> {
    CompoundTag storedBlockNBT = null;
    BlockState storedBlockState = null;
    String name = "";

    @Override
    public boolean hasBlockStored() {
        return this.storedBlockState != null;
    }

    @Override
    public boolean canStoreBlock() {
        return this.hasBlockStored();
    }

    @Override
    public CompoundTag getStoredBlockNBT() {
        return this.storedBlockNBT;
    }

    @Override
    public BlockState getStoredBlockState() {
        return this.storedBlockState;
    }

    @Override
    public String getStoredName() {
        return this.name;
    }

    @Override
    public void storeBlockNBT(CompoundTag tag) {
        this.storedBlockNBT = tag;
    }

    @Override
    public void storeBlockState(BlockState base) {
        this.storedBlockState = base;
    }

    @Override
    public void setBlockName(String name) {
        this.name = name;
    }

    @Override
    public void clearBlockStorage() {
        this.storedBlockState = null;
        this.storedBlockNBT = null;
        this.name = "";
    }

    public static void attachInformation(ItemStack stack, List<Component> tooltip) {
        ForceWrenchAttachment attachment;
        ForceToolData fd = new ForceToolData(stack);
        fd.attachInformation(tooltip);
        if (stack.hasData(ForceAttachments.FORCE_WRENCH) && (attachment = (ForceWrenchAttachment)stack.getData(ForceAttachments.FORCE_WRENCH)).getStoredName() != null && !attachment.getStoredName().isEmpty()) {
            tooltip.add((Component)Component.literal((String)"Stored: ").withStyle(ChatFormatting.GOLD).append((Component)Component.translatable((String)attachment.getStoredName()).withStyle(ChatFormatting.GRAY)));
        }
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        if (this.getStoredBlockNBT() != null) {
            tag.put("storedNBT", (Tag)this.getStoredBlockNBT());
        }
        if (this.getStoredBlockState() != null) {
            tag.put("storedBlockState", (Tag)NbtUtils.writeBlockState((BlockState)this.getStoredBlockState()));
        }
        if (!this.getStoredName().isEmpty()) {
            tag.putString("name", this.getStoredName());
        }
        return tag;
    }

    public void deserializeNBT(CompoundTag tag) {
        this.storeBlockNBT(tag.getCompound("storedNBT"));
        if (tag.contains("storedBlockState")) {
            this.storeBlockState(NbtUtils.readBlockState((HolderGetter)BuiltInRegistries.BLOCK.asLookup(), (CompoundTag)tag.getCompound("storedBlockState")));
        }
        this.setBlockName(tag.getString("name"));
    }
}

