/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.attachment.magnet;

import com.mrbysco.forcecraft.attachment.ForceAttachments;
import com.mrbysco.forcecraft.attachment.magnet.IMagnet;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.common.util.INBTSerializable;

public class MagnetAttachment
implements IMagnet,
INBTSerializable<CompoundTag> {
    boolean active;

    @Override
    public boolean isActivated() {
        return this.active;
    }

    @Override
    public void activate() {
        this.active = true;
    }

    @Override
    public void deactivate() {
        this.active = false;
    }

    @Override
    public void setActivation(boolean value) {
        this.active = value;
    }

    public static void attachInformation(ItemStack stack, List<Component> tooltip) {
        if (stack.hasData(ForceAttachments.MAGNET)) {
            MagnetAttachment attachment = (MagnetAttachment)stack.getData(ForceAttachments.MAGNET);
            if (attachment.isActivated()) {
                tooltip.add((Component)Component.translatable((String)"forcecraft.magnet_glove.active").withStyle(ChatFormatting.GREEN));
            } else {
                tooltip.add((Component)Component.translatable((String)"forcecraft.magnet_glove.deactivated").withStyle(ChatFormatting.RED));
            }
            tooltip.add((Component)Component.empty());
            tooltip.add((Component)Component.translatable((String)"forcecraft.magnet_glove.change").withStyle(ChatFormatting.BOLD));
        }
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.putBoolean("activated", this.isActivated());
        return tag;
    }

    public void deserializeNBT(CompoundTag tag) {
        this.setActivation(tag.getBoolean("activated"));
    }
}

