/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.attachment.toolmodifier;

import com.mrbysco.forcecraft.attachment.ForceAttachments;
import com.mrbysco.forcecraft.attachment.toolmodifier.IToolModifier;
import com.mrbysco.forcecraft.items.ForceArmorItem;
import com.mrbysco.forcecraft.items.tools.ForceBowItem;
import com.mrbysco.forcecraft.items.tools.ForcePickaxeItem;
import com.mrbysco.forcecraft.items.tools.ForceRodItem;
import com.mrbysco.forcecraft.items.tools.ForceShearsItem;
import com.mrbysco.forcecraft.items.tools.ForceShovelItem;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.common.util.INBTSerializable;

public class ToolModifierAttachment
implements IToolModifier,
INBTSerializable<CompoundTag> {
    private int speed;
    private boolean heat;
    private int force;
    private boolean silk;
    private int sharpness;
    private int luck;
    private int sturdy;
    boolean rainbow;
    boolean lumberJack;
    int bleed;
    int bane;
    boolean wing;
    boolean camo;
    boolean sight;
    boolean light;
    boolean ender;
    boolean freezing;
    boolean treasure;

    @Override
    public int getSpeedLevel() {
        return this.speed;
    }

    @Override
    public void incrementSpeed() {
        ++this.speed;
    }

    @Override
    public void setSpeed(int newSpeed) {
        this.speed = newSpeed;
    }

    @Override
    public boolean hasHeat() {
        return this.heat;
    }

    @Override
    public void setHeat(boolean val) {
        this.heat = val;
    }

    @Override
    public int getForceLevel() {
        return this.force;
    }

    @Override
    public boolean hasForce() {
        return this.force != 0;
    }

    @Override
    public void incrementForce() {
        ++this.force;
    }

    @Override
    public void setForce(int newForce) {
        this.force = newForce;
    }

    @Override
    public boolean hasSilk() {
        return this.silk;
    }

    @Override
    public void setSilk(boolean val) {
        this.silk = val;
    }

    @Override
    public int getSharpLevel() {
        return this.sharpness;
    }

    @Override
    public boolean hasSharp() {
        return this.sharpness > 0;
    }

    @Override
    public void incrementSharp() {
        ++this.sharpness;
    }

    @Override
    public void setSharp(int newSharp) {
        this.sharpness = newSharp;
    }

    @Override
    public int getLuckLevel() {
        return this.luck;
    }

    @Override
    public boolean hasLuck() {
        return this.luck > 0;
    }

    @Override
    public void incrementLuck() {
        ++this.luck;
    }

    @Override
    public void setLuck(int newLuck) {
        this.luck = newLuck;
    }

    @Override
    public int getSturdyLevel() {
        return this.sturdy;
    }

    @Override
    public boolean hasSturdy() {
        return this.sturdy > 0;
    }

    @Override
    public void incrementSturdy() {
        ++this.sturdy;
    }

    @Override
    public void setSturdy(int newSturdy) {
        this.sturdy = newSturdy;
    }

    @Override
    public boolean hasRainbow() {
        return this.rainbow;
    }

    @Override
    public void setRainbow(boolean val) {
        this.rainbow = val;
    }

    @Override
    public boolean hasLumberjack() {
        return this.lumberJack;
    }

    @Override
    public void setLumberjack(boolean val) {
        this.lumberJack = val;
    }

    @Override
    public int getBleedLevel() {
        return this.bleed;
    }

    @Override
    public boolean hasBleed() {
        return this.bleed > 0;
    }

    @Override
    public void incrementBleed() {
        ++this.bleed;
    }

    @Override
    public void setBleed(int newBleed) {
        this.bleed = newBleed;
    }

    @Override
    public int getBaneLevel() {
        return this.bane;
    }

    @Override
    public boolean hasBane() {
        return this.bane > 0;
    }

    @Override
    public void incrementBane() {
        ++this.bane;
    }

    @Override
    public void setBane(int newBane) {
        this.bane = newBane;
    }

    @Override
    public boolean hasWing() {
        return this.wing;
    }

    @Override
    public void setWing(boolean val) {
        this.wing = val;
    }

    @Override
    public boolean hasCamo() {
        return this.camo;
    }

    @Override
    public void setCamo(boolean val) {
        this.camo = val;
    }

    @Override
    public boolean hasSight() {
        return this.sight;
    }

    @Override
    public void setSight(boolean val) {
        this.sight = val;
    }

    @Override
    public boolean hasLight() {
        return this.light;
    }

    @Override
    public void setLight(boolean val) {
        this.light = val;
    }

    @Override
    public boolean hasEnder() {
        return this.ender;
    }

    @Override
    public void setEnder(boolean val) {
        this.ender = val;
    }

    @Override
    public boolean hasFreezing() {
        return this.freezing;
    }

    @Override
    public void setFreezing(boolean val) {
        this.freezing = val;
    }

    @Override
    public boolean hasTreasure() {
        return this.treasure;
    }

    @Override
    public void setTreasure(boolean val) {
        this.treasure = val;
    }

    public static void attachInformation(ItemStack stack, List<Component> tooltip) {
        if (stack.hasData(ForceAttachments.TOOL_MODIFIER)) {
            ToolModifierAttachment attachment = (ToolModifierAttachment)stack.getData(ForceAttachments.TOOL_MODIFIER);
            Item item = stack.getItem();
            if (attachment.getSpeedLevel() > 0 && (item instanceof ForceBowItem || item instanceof ForceArmorItem || item instanceof ForceRodItem)) {
                tooltip.add((Component)Component.translatable((String)("item.infuser.tooltip.speed" + attachment.getSpeedLevel())).withStyle(ChatFormatting.YELLOW));
            }
            if (attachment.hasLumberjack()) {
                tooltip.add((Component)Component.translatable((String)"item.infuser.tooltip.lumberjack").withStyle(ChatFormatting.YELLOW));
            }
            if (attachment.getLuckLevel() > 0 && (item instanceof ForceBowItem || item instanceof ForceArmorItem)) {
                tooltip.add((Component)Component.translatable((String)("item.infuser.tooltip.luck" + attachment.getLuckLevel())).withStyle(ChatFormatting.GREEN));
            }
            if (attachment.getBaneLevel() > 0) {
                tooltip.add((Component)Component.translatable((String)"item.infuser.tooltip.bane").withStyle(ChatFormatting.LIGHT_PURPLE));
            }
            if (attachment.getSturdyLevel() > 0 && stack.getItem() instanceof ForceArmorItem) {
                tooltip.add((Component)Component.translatable((String)("item.infuser.tooltip.sturdy" + attachment.getSturdyLevel())).withStyle(ChatFormatting.DARK_PURPLE));
            }
            if (attachment.hasWing()) {
                tooltip.add((Component)Component.translatable((String)"item.infuser.tooltip.wing"));
            }
            if (attachment.hasBleed()) {
                tooltip.add((Component)Component.translatable((String)("item.infuser.tooltip.bleed" + attachment.getBleedLevel())).withStyle(ChatFormatting.RED));
            }
            if (attachment.hasRainbow()) {
                tooltip.add((Component)Component.translatable((String)"item.infuser.tooltip.rainbow").withStyle(ChatFormatting.GOLD));
            }
            if (attachment.hasHeat() && (item instanceof ForceShovelItem || item instanceof ForcePickaxeItem || item instanceof ForceShearsItem || item instanceof ForceArmorItem)) {
                tooltip.add((Component)Component.translatable((String)"item.infuser.tooltip.heat").withStyle(ChatFormatting.RED));
            }
            if (attachment.hasCamo()) {
                tooltip.add((Component)Component.translatable((String)"item.infuser.tooltip.camo").withStyle(ChatFormatting.DARK_GREEN));
            }
            if (attachment.hasEnder()) {
                tooltip.add((Component)Component.translatable((String)"item.infuser.tooltip.ender").withStyle(ChatFormatting.DARK_PURPLE));
            }
            if (attachment.hasFreezing()) {
                tooltip.add((Component)Component.translatable((String)"item.infuser.tooltip.freezing").withStyle(ChatFormatting.BLUE));
            }
            if (attachment.hasTreasure()) {
                tooltip.add((Component)Component.translatable((String)"item.infuser.tooltip.treasure").withStyle(ChatFormatting.GOLD));
            }
            if (attachment.hasLight()) {
                tooltip.add((Component)Component.translatable((String)"item.infuser.tooltip.light").withStyle(ChatFormatting.GOLD));
            }
            if (attachment.hasSharp() && stack.getItem() instanceof ForceArmorItem) {
                tooltip.add((Component)Component.translatable((String)"item.infuser.tooltip.sharp").withStyle(ChatFormatting.GOLD));
            }
        }
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.putInt("speed", this.getSpeedLevel());
        tag.putBoolean("heat", this.hasHeat());
        tag.putInt("force", this.getForceLevel());
        tag.putBoolean("silk", this.hasSilk());
        tag.putInt("sharp", this.getSharpLevel());
        tag.putInt("luck", this.getLuckLevel());
        tag.putInt("sturdy", this.getSturdyLevel());
        tag.putBoolean("rainbow", this.hasRainbow());
        tag.putBoolean("lumber", this.hasLumberjack());
        tag.putInt("bleed", this.getBleedLevel());
        tag.putInt("bane", this.getBaneLevel());
        tag.putBoolean("wing", this.hasWing());
        tag.putBoolean("camo", this.hasCamo());
        tag.putBoolean("sight", this.hasSight());
        tag.putBoolean("light", this.hasLight());
        tag.putBoolean("ender", this.hasEnder());
        tag.putBoolean("freezing", this.hasFreezing());
        tag.putBoolean("treasure", this.hasTreasure());
        return tag;
    }

    public void deserializeNBT(CompoundTag tag) {
        this.setSpeed(tag.getInt("speed"));
        this.setHeat(tag.getBoolean("heat"));
        this.setForce(tag.getInt("force"));
        this.setSilk(tag.getBoolean("silk"));
        this.setSharp(tag.getInt("sharp"));
        this.setLuck(tag.getInt("luck"));
        this.setSturdy(tag.getInt("sturdy"));
        this.setRainbow(tag.getBoolean("rainbow"));
        this.setLumberjack(tag.getBoolean("lumber"));
        this.setBleed(tag.getInt("bleed"));
        this.setBane(tag.getInt("bane"));
        this.setWing(tag.getBoolean("wing"));
        this.setCamo(tag.getBoolean("camo"));
        this.setSight(tag.getBoolean("sight"));
        this.setLight(tag.getBoolean("light"));
        this.setEnder(tag.getBoolean("ender"));
        this.setFreezing(tag.getBoolean("freezing"));
        this.setTreasure(tag.getBoolean("treasure"));
    }
}

