/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.blockentities;

import com.mrbysco.forcecraft.blocks.torch.TimeTorchBlock;
import com.mrbysco.forcecraft.blocks.torch.WallTimeTorchBlock;
import com.mrbysco.forcecraft.config.ConfigHandler;
import com.mrbysco.forcecraft.registry.ForceRegistry;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class TimeTorchBlockEntity
extends BlockEntity {
    private final List<BlockPos> positionList = new ArrayList<BlockPos>();
    private int speed;

    public TimeTorchBlockEntity(BlockEntityType<?> blockEntityType, BlockPos pos, BlockState state) {
        super(blockEntityType, pos, state);
        this.speed = (Integer)ConfigHandler.COMMON.timeTorchAmount.get();
        this.initializePositions();
    }

    public TimeTorchBlockEntity(BlockPos pos, BlockState state) {
        this(ForceRegistry.TIME_TORCH_BLOCK_ENTITY.get(), pos, state);
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, TimeTorchBlockEntity timeTorch) {
        int rate = (Integer)ConfigHandler.COMMON.timeTorchRate.get();
        if (rate > 0 && level.getGameTime() % (long)rate == 0L) {
            timeTorch.tickNeighbor();
        }
    }

    private void tickNeighbor() {
        this.positionList.forEach(this::tickBlock);
    }

    private void initializePositions() {
        this.positionList.clear();
        this.positionList.addAll(BlockPos.betweenClosedStream((BlockPos)this.worldPosition.offset(-1, -1, -1), (BlockPos)this.worldPosition.offset(1, 1, 1)).map(BlockPos::immutable).toList());
    }

    private void tickBlock(@Nonnull BlockPos pos) {
        if (pos.equals((Object)this.getBlockPos()) || !this.level.isAreaLoaded(pos, 1)) {
            return;
        }
        BlockState blockState = this.level.getBlockState(pos);
        if (blockState != null) {
            BlockEntity blockEntity;
            Block block = blockState.getBlock();
            if (block == null || block instanceof LiquidBlock || block instanceof TimeTorchBlock || block instanceof WallTimeTorchBlock || block == Blocks.AIR) {
                return;
            }
            if (block.isRandomlyTicking(blockState) && !this.level.isClientSide) {
                for (int i = 0; i < this.speed && this.getLevel().getBlockState(pos) == blockState; ++i) {
                    if (!this.getLevel().random.nextBoolean()) continue;
                    block.randomTick(blockState, (ServerLevel)this.level, pos, this.level.random);
                }
            }
            if ((blockEntity = this.level.getBlockEntity(pos)) != null) {
                for (int i = 0; i < this.speed && !blockEntity.isRemoved(); ++i) {
                    BlockEntityTicker ticker = blockState.getTicker(this.level, blockEntity.getType());
                    if (ticker == null) continue;
                    ticker.tick(this.level, pos, blockEntity.getBlockState(), blockEntity);
                }
            }
        }
    }

    public void saveAdditional(CompoundTag tag) {
        super.saveAdditional(tag);
        tag.putInt("Speed", this.speed);
    }

    public void load(CompoundTag tag) {
        super.load(tag);
        if (tag.contains("Speed")) {
            this.speed = tag.getInt("Speed");
        }
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket packet) {
        this.load(packet.getTag());
    }

    public CompoundTag getUpdateTag() {
        CompoundTag tag = new CompoundTag();
        this.saveAdditional(tag);
        return tag;
    }

    public void handleUpdateTag(CompoundTag tag) {
        this.load(tag);
    }

    public CompoundTag getPersistentData() {
        CompoundTag tag = new CompoundTag();
        this.saveAdditional(tag);
        return tag;
    }
}

