/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.blocks;

import com.mrbysco.forcecraft.Reference;
import com.mrbysco.forcecraft.config.ConfigHandler;
import com.mrbysco.forcecraft.entities.IColdMob;
import com.mrbysco.forcecraft.registry.ForceEffects;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FlowingFluid;
import net.neoforged.neoforge.common.IShearable;

public class ForceFluidBlock
extends LiquidBlock {
    public ForceFluidBlock(Supplier<? extends FlowingFluid> supplier, BlockBehaviour.Properties properties) {
        super(supplier, properties);
    }

    public void entityInside(BlockState state, Level level, BlockPos pos, Entity entityIn) {
        if (entityIn instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entityIn;
            if (livingEntity instanceof Player) {
                Player player = (Player)livingEntity;
                if (player.getHealth() < player.getMaxHealth()) {
                    player.addEffect(new MobEffectInstance(MobEffects.REGENERATION, 10, ((Integer)ConfigHandler.COMMON.liquidRegenLevel.get()).intValue(), false, false));
                    if (((Boolean)ConfigHandler.COMMON.enableForceShake.get()).booleanValue()) {
                        player.addEffect(new MobEffectInstance(ForceEffects.SHAKING.get(), 10, 0, false, false));
                    }
                }
            } else {
                boolean secondPassed;
                Zombie zombie;
                if (livingEntity instanceof Zombie && !(zombie = (Zombie)livingEntity).isBaby()) {
                    zombie.setBaby(true);
                    for (ItemStack armor : zombie.getArmorSlots()) {
                        zombie.spawnAtLocation(armor.copy());
                        armor.shrink(armor.getMaxStackSize());
                    }
                    for (ItemStack held : zombie.getHandSlots()) {
                        zombie.spawnAtLocation(held.copy());
                        held.shrink(held.getMaxStackSize());
                    }
                }
                MobType creatureAttribute = livingEntity.getMobType();
                MobCategory classification = livingEntity.getClassification(false);
                boolean bl = secondPassed = level.getGameTime() % 20L == 0L;
                if (classification == MobCategory.MONSTER) {
                    if (creatureAttribute == MobType.UNDEAD && level.getGameTime() % 10L == 0L) {
                        livingEntity.hurt(Reference.causeLiquidForceDamage((Entity)livingEntity), 1.0f);
                    }
                } else {
                    if (level.getGameTime() % 10L == 0L) {
                        livingEntity.heal(0.5f);
                    }
                    if (livingEntity instanceof IShearable && secondPassed && level.getRandom().nextInt(10) <= 3) {
                        if (livingEntity instanceof Sheep) {
                            ((Sheep)livingEntity).setSheared(false);
                        } else if (livingEntity instanceof IColdMob) {
                            IColdMob coldMob = (IColdMob)livingEntity;
                            coldMob.transformMob(livingEntity, level);
                        }
                    }
                }
            }
        }
    }
}

