/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.forcecraft.blocks;

import com.mojang.serialization.MapCodec;
import com.mrbysco.forcecraft.blockentities.furnace.AbstractForceFurnaceBlockEntity;
import com.mrbysco.forcecraft.blockentities.furnace.ForceFurnaceBlockEntity;
import com.mrbysco.forcecraft.items.UpgradeCoreItem;
import com.mrbysco.forcecraft.registry.ForceRegistry;
import java.util.function.ToIntFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.RandomSource;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AbstractFurnaceBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class ForceFurnaceBlock
extends AbstractFurnaceBlock
implements EntityBlock {
    public static final MapCodec<ForceFurnaceBlock> CODEC = ForceFurnaceBlock.simpleCodec(ForceFurnaceBlock::new);
    private static final String NBT_UPGRADE = "upgrade";

    public ForceFurnaceBlock(BlockBehaviour.Properties builder) {
        super(builder);
    }

    protected MapCodec<? extends AbstractFurnaceBlock> codec() {
        return CODEC;
    }

    public static ToIntFunction<BlockState> getLightValueLit(int lightValue) {
        return state -> (Boolean)state.getValue((Property)BlockStateProperties.LIT) != false ? lightValue : 0;
    }

    protected void openContainer(Level level, BlockPos pos, Player player) {
        BlockEntity blockentity = level.getBlockEntity(pos);
        if (blockentity instanceof ForceFurnaceBlockEntity) {
            if (!level.isClientSide) {
                player.openMenu((MenuProvider)((ForceFurnaceBlockEntity)blockentity), pos);
            }
            player.awardStat(Stats.INTERACT_WITH_FURNACE);
        }
    }

    public void animateTick(BlockState stateIn, Level level, BlockPos pos, RandomSource rand) {
        if (((Boolean)stateIn.getValue((Property)LIT)).booleanValue()) {
            double d0 = (double)pos.getX() + 0.5;
            double d1 = pos.getY();
            double d2 = (double)pos.getZ() + 0.5;
            if (rand.nextDouble() < 0.1) {
                level.playLocalSound(d0, d1, d2, SoundEvents.FURNACE_FIRE_CRACKLE, SoundSource.BLOCKS, 1.0f, 1.0f, false);
            }
            Direction direction = (Direction)stateIn.getValue((Property)FACING);
            Direction.Axis direction$axis = direction.getAxis();
            double d3 = 0.52;
            double d4 = rand.nextDouble() * 0.6 - 0.3;
            double d5 = direction$axis == Direction.Axis.X ? (double)direction.getStepX() * d3 : d4;
            double d6 = rand.nextDouble() * 6.0 / 16.0;
            double d7 = direction$axis == Direction.Axis.Z ? (double)direction.getStepZ() * d3 : d4;
            level.addParticle((ParticleOptions)ParticleTypes.SMOKE, d0 + d5, d1 + d6, d2 + d7, 0.0, 0.0, 0.0);
            level.addParticle((ParticleOptions)ParticleTypes.FLAME, d0 + d5, d1 + d6, d2 + d7, 0.0, 0.0, 0.0);
        }
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new ForceFurnaceBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return ForceFurnaceBlock.createForceFurnaceTicker(level, blockEntityType, ForceRegistry.FURNACE_BLOCK_ENTITY.get());
    }

    @Nullable
    protected static <T extends BlockEntity> BlockEntityTicker<T> createForceFurnaceTicker(Level level, BlockEntityType<T> p_151989_, BlockEntityType<? extends AbstractForceFurnaceBlockEntity> abstractForceFurnaceType) {
        return level.isClientSide ? null : ForceFurnaceBlock.createTickerHelper(p_151989_, abstractForceFurnaceType, AbstractForceFurnaceBlockEntity::serverTick);
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.is(newState.getBlock())) {
            BlockEntity blockentity = level.getBlockEntity(pos);
            if (blockentity instanceof AbstractForceFurnaceBlockEntity) {
                AbstractForceFurnaceBlockEntity furnaceTile = (AbstractForceFurnaceBlockEntity)blockentity;
                for (int i = 0; i < furnaceTile.getContainerSize(); ++i) {
                    if (furnaceTile.getItem(i).getItem() instanceof UpgradeCoreItem) continue;
                    ForceFurnaceBlock.spawnItemStack(level, pos.getX(), pos.getY(), pos.getZ(), furnaceTile.getItem(i));
                }
                if (level instanceof ServerLevel) {
                    furnaceTile.getRecipesToAwardAndPopExperience((ServerLevel)level, Vec3.atCenterOf((Vec3i)pos));
                }
                level.updateNeighbourForOutputSignal(pos, (Block)this);
            }
            super.onRemove(state, level, pos, newState, isMoving);
        }
    }

    public static void spawnItemStack(Level level, double x, double y, double z, ItemStack stack) {
        double d0 = EntityType.ITEM.getWidth();
        double d1 = 1.0 - d0;
        double d2 = d0 / 2.0;
        double d3 = Math.floor(x) + level.random.nextDouble() * d1 + d2;
        double d4 = Math.floor(y) + level.random.nextDouble() * d1;
        double d5 = Math.floor(z) + level.random.nextDouble() * d1 + d2;
        while (!stack.isEmpty()) {
            ItemEntity itementity = new ItemEntity(level, d3, d4, d5, stack.split(level.random.nextInt(21) + 10));
            float f = 0.05f;
            itementity.setDeltaMovement(level.random.nextGaussian() * (double)0.05f, level.random.nextGaussian() * (double)f + (double)0.2f, level.random.nextGaussian() * (double)f);
            level.addFreshEntity((Entity)itementity);
        }
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        BlockEntity blockentity = level.getBlockEntity(pos);
        if (blockentity instanceof AbstractForceFurnaceBlockEntity) {
            AbstractForceFurnaceBlockEntity furnaceTile = (AbstractForceFurnaceBlockEntity)blockentity;
            if (stack.hasCustomHoverName()) {
                furnaceTile.setCustomName(stack.getHoverName());
            }
            if (stack.getTag() != null && stack.getTag().contains(NBT_UPGRADE)) {
                ItemStack upgrade = ItemStack.of((CompoundTag)stack.getTag().getCompound(NBT_UPGRADE));
                furnaceTile.setUpgrade(upgrade);
            }
        }
    }

    public void playerDestroy(Level level, Player player, BlockPos pos, BlockState state, @Nullable BlockEntity te, ItemStack stack) {
        ForceFurnaceBlockEntity tile;
        super.playerDestroy(level, player, pos, state, te, stack);
        if (te instanceof ForceFurnaceBlockEntity && !(tile = (ForceFurnaceBlockEntity)te).getUpgrade().isEmpty()) {
            level.playSound((Player)null, pos, SoundEvents.ITEM_BREAK, SoundSource.BLOCKS, 0.5f, 1.0f);
        }
    }

    public PushReaction getPistonPushReaction(BlockState state) {
        return PushReaction.BLOCK;
    }
}

